package com.tencent.qcloud.image.avif.glide.avif;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.tencent.qcloud.image.avif.Avif;

import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferAvifDecoder implements ResourceDecoder<ByteBuffer, Bitmap> {

    public static final String TAG = "ByteBufferAvifDecoder";

    @NonNull
    private final BitmapPool bitmapPool;

    public ByteBufferAvifDecoder(@NonNull final BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;

    }

    @Override
    public boolean handles(@NonNull ByteBuffer source, @NonNull Options options) throws IOException {
        return Avif.isAvif(source);
    }

    @Nullable
    @Override
    public Resource<Bitmap> decode(@NonNull ByteBuffer source, int width, int height, @NonNull Options options) throws IOException {
        byte[] arr = new byte[source.remaining()];
        source.get(arr);
        final Bitmap bitmap = Avif.decode(arr, width, bitmapPool);
        return new AvifBitmapResource(bitmapPool, bitmap);
    }
}
