package com.tencent.qcloud.image.avif.glide.avif;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.tencent.libqcloudavif.AvifDecoder;
import com.tencent.libavif.AvifSequenceDrawable;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.glide.CiOptions;

import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferAvifSequenceDecoder implements ResourceDecoder<ByteBuffer, AvifSequenceDrawable> {

    private static final String TAG = "ByteBufferAvifSeqDecoder";

    private final AvifSequenceDrawable.BitmapProvider bitmapProvider;

    public ByteBufferAvifSequenceDecoder(@NonNull final BitmapPool bitmapPool) {
        bitmapProvider = new AvifSequenceDrawable.BitmapProvider() {
            @Override
            public Bitmap acquireBitmap(int minWidth, int minHeight) {
                return bitmapPool.getDirty(minWidth, minHeight, Bitmap.Config.ARGB_8888);
            }

            @Override
            public void releaseBitmap(Bitmap bitmap) {
                bitmapPool.put(bitmap);
            }
        };
    }

    @Override
    public boolean handles(@NonNull ByteBuffer source, @NonNull Options options) throws IOException {
        if (options.get(CiOptions.DISABLE_ANIMATION)) {
            return false;
        }
        return Avif.isAvis(source);
    }

    @Nullable
    @Override
    public Resource<AvifSequenceDrawable> decode(@NonNull ByteBuffer source, int width, int height, @NonNull Options options) throws IOException {

        final AvifDecoder avifDecoder = Avif.getAvifDecoder(source);
        if (avifDecoder == null) {
            return null;
        }

        final AvifSequenceDrawable drawable = new AvifSequenceDrawable(avifDecoder, source.remaining(), bitmapProvider);

        if (options.get(CiOptions.LOOP_ONCE)) {
            drawable.setLoopBehavior(AvifSequenceDrawable.LOOP_FINITE);
            drawable.setLoopCount(1);
        } else {
            drawable.setLoopBehavior(AvifSequenceDrawable.LOOP_DEFAULT);
        }

        return new AvifSequenceDrawableResource(drawable);
    }

}
