package com.tencent.qcloud.image.avif.glide.avif;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.utils.ResourcesUtil;

import java.io.IOException;
import java.io.InputStream;

public class StreamAvifDecoder implements ResourceDecoder<InputStream, Bitmap> {

    public static final String TAG = "StreamAvifDecoder";

    @NonNull
    private final BitmapPool bitmapPool;
    @NonNull
    private final ArrayPool byteArrayPool;

    public StreamAvifDecoder(@NonNull final BitmapPool bitmapPool, @NonNull ArrayPool byteArrayPool) {
        this.bitmapPool = bitmapPool;
        this.byteArrayPool = byteArrayPool;
    }

    @Override
    public boolean handles(@NonNull InputStream source, @NonNull Options options) throws IOException {
        return Avif.isAvif(source, byteArrayPool);
    }

    @Nullable
    @Override
    public Resource<Bitmap> decode(@NonNull InputStream source, int width, int height, @NonNull Options options) throws IOException {
        final byte[] bytes = ResourcesUtil.inputStreamToBytes(source);
        final Bitmap bitmap = Avif.decode(bytes, width, bitmapPool);
        return new AvifBitmapResource(bitmapPool, bitmap);
    }
}
