package com.tencent.qcloud.image.avif.glide.avif;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.tencent.libqcloudavif.AvifDecoder;
import com.tencent.libavif.AvifSequenceDrawable;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.glide.CiOptions;
import com.tencent.qcloud.image.decoder.utils.ResourcesUtil;

import java.io.IOException;
import java.io.InputStream;

public class StreamAvifSequenceDecoder implements ResourceDecoder<InputStream, AvifSequenceDrawable> {

    public static final String TAG = "StreamAvifSeqDecoder";

    @NonNull
    private final ArrayPool byteArrayPool;
    private final AvifSequenceDrawable.BitmapProvider bitmapProvider;

    public StreamAvifSequenceDecoder(@NonNull final BitmapPool bitmapPool, @NonNull ArrayPool byteArrayPool) {
        this.byteArrayPool = byteArrayPool;
        bitmapProvider = new AvifSequenceDrawable.BitmapProvider() {
            @Override
            public Bitmap acquireBitmap(int minWidth, int minHeight) {
                return bitmapPool.getDirty(minWidth, minHeight, Bitmap.Config.ARGB_8888);
            }

            @Override
            public void releaseBitmap(Bitmap bitmap) {
                bitmapPool.put(bitmap);
            }
        };
    }

    @Override
    public boolean handles(@NonNull InputStream source, @NonNull Options options) throws IOException {
        if (options.get(CiOptions.DISABLE_ANIMATION)) {
            return false;
        }
        return Avif.isAvis(source, byteArrayPool);
    }

    @Nullable
    @Override
    public Resource<AvifSequenceDrawable> decode(@NonNull InputStream source, int width, int height, @NonNull Options options) throws IOException {


        final byte[] bytes = ResourcesUtil.inputStreamToBytes(source);
        if (bytes == null) {
            return null;
        }
        final AvifDecoder avifDecoder = Avif.getAvifDecoder(bytes);
        if (avifDecoder == null) {
            return null;
        }

        final AvifSequenceDrawable drawable = new AvifSequenceDrawable(avifDecoder, bytes.length, bitmapProvider);
        if (options.get(CiOptions.LOOP_ONCE)) {
            drawable.setLoopBehavior(AvifSequenceDrawable.LOOP_FINITE);
            drawable.setLoopCount(1);
        } else {
            drawable.setLoopBehavior(AvifSequenceDrawable.LOOP_DEFAULT);
        }

        return new AvifSequenceDrawableResource(drawable);
    }
}
