/*
 * Copyright (c) 2010-2020 Tencent Cloud. All rights reserved.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */

package com.tencent.qcloud.image.avif.subsampling;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;

import androidx.annotation.NonNull;

import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.subsampling.SubsamplingUtil;

public class AvifSubsamplingImageDecoder implements ImageDecoder {
    @NonNull
    @Override
    public Bitmap decode(Context context, @NonNull Uri uri) throws Exception {
        byte[] bytes = SubsamplingUtil.getBytes(context, uri);
        if(Avif.isAvif(bytes) || Avif.isAvis(bytes)){
            Bitmap bitmap = Avif.decode(bytes);
            if (bitmap == null) {
                throw new RuntimeException("avif image decoder returned null bitmap - image format may not be supported");
            }
            return bitmap;
        } else {
            throw new RuntimeException("Non-avif format, please use the default decoder(SkiaImageDecoder) or other decoder");
        }
    }
}
