/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.crypto.CipherLite;
import com.tencent.cos.xml.crypto.ContentCryptoScheme;
import com.tencent.cos.xml.crypto.GCMCipherLite;
import com.tencent.cos.xml.exception.CosXmlClientException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

class AesGcm
extends ContentCryptoScheme {
    AesGcm() {
    }

    @Override
    String getKeyGeneratorAlgorithm() {
        return "AES";
    }

    @Override
    String getCipherAlgorithm() {
        return "AES/GCM/NoPadding";
    }

    @Override
    int getKeyLengthInBits() {
        return 256;
    }

    @Override
    int getBlockSizeInBytes() {
        return 16;
    }

    @Override
    int getIVLengthInBytes() {
        return 12;
    }

    @Override
    long getMaxPlaintextSize() {
        return 0xFFFFFFFE0L;
    }

    @Override
    int getTagLengthInBits() {
        return 128;
    }

    @Override
    String getSpecificCipherProvider() {
        return "BC";
    }

    @Override
    CipherLite createAuxillaryCipher(SecretKey cek, byte[] ivOrig, int cipherMode, Provider securityProvider, long startingBytePos) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        byte[] iv = AES_CTR.adjustIV(ivOrig, startingBytePos);
        try {
            return AES_CTR.createCipherLite(cek, iv, cipherMode, securityProvider);
        }
        catch (CosXmlClientException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected CipherLite newCipherLite(Cipher cipher, SecretKey cek, int cipherMode) {
        return new GCMCipherLite(cipher, cek, cipherMode);
    }
}

