/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.Range;
import com.tencent.cos.xml.crypto.COSCryptoScheme;
import com.tencent.cos.xml.crypto.CipherLite;
import com.tencent.cos.xml.crypto.CipherLiteInputStream;
import com.tencent.cos.xml.crypto.ContentCryptoMaterial;
import com.tencent.cos.xml.crypto.ContentCryptoScheme;
import com.tencent.cos.xml.crypto.CryptoModule;
import com.tencent.cos.xml.crypto.EncryptionMaterials;
import com.tencent.cos.xml.crypto.EncryptionMaterialsProvider;
import com.tencent.cos.xml.crypto.InputSubstream;
import com.tencent.cos.xml.crypto.JSONUtils;
import com.tencent.cos.xml.crypto.KMSSecuredCEK;
import com.tencent.cos.xml.crypto.LengthCheckInputStream;
import com.tencent.cos.xml.crypto.MultipartUploadCryptoContext;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.crypto.QCLOUDKMS;
import com.tencent.cos.xml.crypto.RenewableCipherLiteInputStream;
import com.tencent.cos.xml.crypto.ResettableInputStream;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.s3.Base64;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;

public abstract class CryptoModuleBase
implements CryptoModule {
    private static final boolean IS_MULTI_PART = true;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final COSCryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final Map<String, MultipartUploadCryptoContext> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final CosXmlSimpleService cos;
    protected final QCLOUDKMS kms;

    protected CryptoModuleBase(QCLOUDKMS kms, CosXmlSimpleService cos, QCloudCredentialProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider) {
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cos = cos;
        this.cryptoScheme = COSCryptoScheme.from();
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = kms;
    }

    protected CryptoModuleBase(CosXmlSimpleService cos, QCloudCredentialProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider) {
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cos = cos;
        this.cryptoScheme = COSCryptoScheme.from();
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = null;
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest req) throws CosXmlClientException, CosXmlServiceException {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial((CosXmlRequest)req);
        PutObjectRequest wrappedReq = this.wrapWithCipher(req, cekMaterial);
        req.setMetadata(this.updateMetadataWithContentCryptoMaterial(req.getMetadata(), cekMaterial));
        return this.cos.putObject(wrappedReq);
    }

    abstract MultipartUploadCryptoContext newUploadContext(InitMultipartUploadRequest var1, ContentCryptoMaterial var2);

    @Override
    public InitMultipartUploadResult initMultipartUploadSecurely(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        this.cipherInitMultipartUploadRequest(request);
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial((CosXmlRequest)request);
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        request.setMetadata(this.updateMetadataWithContentCryptoMaterial(metadata, cekMaterial));
        InitMultipartUploadResult result = this.cos.initMultipartUpload(request);
        MultipartUploadCryptoContext uploadContext = this.newUploadContext(request, cekMaterial);
        this.multipartUploadContexts.put(result.initMultipartUpload.uploadId, uploadContext);
        return result;
    }

    public boolean hasMultipartUploadContext(String uploadId) {
        return this.multipartUploadContexts.containsKey(uploadId);
    }

    public MultipartUploadCryptoContext getCryptoContext(String uploadId) {
        return this.multipartUploadContexts.get(uploadId);
    }

    abstract CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext var1);

    abstract long computeLastPartSize(UploadPartRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) throws CosXmlClientException, CosXmlServiceException {
        UploadPartResult result;
        boolean partSizeMultipleOfCipherBlockSize;
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean isLastPart = req.isLastPart();
        String uploadId = req.getUploadId();
        long partSize = req.getFileLength();
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw CosXmlClientException.internalException((String)("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part."));
        }
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (uploadContext == null) {
            throw CosXmlClientException.internalException((String)("No client-side information available on upload ID " + uploadId));
        }
        uploadContext.beginPartUpload(req.getPartNumber());
        CipherLite cipherLite = this.cipherLiteForNextPart(uploadContext);
        CipherLiteInputStream isCurr = null;
        try {
            CipherLiteInputStream clis;
            isCurr = clis = this.newMultipartCOSCipherInputStream(req, cipherLite);
            req.setInputStream((InputStream)isCurr);
            req.setSrcPath(null);
            req.setFileOffset(0L);
            if (isLastPart) {
                long lastPartSize = this.computeLastPartSize(req);
                if (lastPartSize > -1L) {
                    req.setFileContentLength(lastPartSize);
                }
                if (uploadContext.hasFinalPartBeenSeen()) {
                    throw CosXmlClientException.internalException((String)"This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            result = this.cos.uploadPart(req);
        }
        finally {
            uploadContext.endPartUpload();
        }
        if (isLastPart) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadPartAsyncSecurely(UploadPartRequest req, CosXmlResultListener resultListener) {
        MultipartUploadCryptoContext uploadContext = null;
        boolean isLastPart = req.isLastPart();
        try {
            CipherLiteInputStream clis;
            boolean partSizeMultipleOfCipherBlockSize;
            int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
            String uploadId = req.getUploadId();
            long partSize = req.getFileLength();
            boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
            if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
                throw CosXmlClientException.internalException((String)("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part."));
            }
            uploadContext = this.multipartUploadContexts.get(uploadId);
            if (uploadContext == null) {
                throw CosXmlClientException.internalException((String)("No client-side information available on upload ID " + uploadId));
            }
            uploadContext.beginPartUpload(req.getPartNumber());
            CipherLite cipherLite = this.cipherLiteForNextPart(uploadContext);
            CipherLiteInputStream isCurr = null;
            isCurr = clis = this.newMultipartCOSCipherInputStream(req, cipherLite);
            req.setInputStream((InputStream)isCurr);
            req.setSrcPath(null);
            req.setFileOffset(0L);
            if (isLastPart) {
                long lastPartSize = this.computeLastPartSize(req);
                if (lastPartSize > -1L) {
                    req.setFileContentLength(lastPartSize);
                }
                if (uploadContext.hasFinalPartBeenSeen()) {
                    throw CosXmlClientException.internalException((String)"This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            this.cos.uploadPartAsync(req, resultListener);
        }
        catch (CosXmlClientException clientException) {
            resultListener.onFail((CosXmlRequest)req, clientException, null);
        }
        finally {
            if (uploadContext != null) {
                uploadContext.endPartUpload();
            }
        }
        if (isLastPart && uploadContext != null) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
    }

    public final CipherLiteInputStream newMultipartCOSCipherInputStream(UploadPartRequest req, CipherLite cipherLite) throws CosXmlClientException {
        String fileOrig = req.getSrcPath();
        Uri uri = req.getUri();
        InputStream isCurr = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)fileOrig)) {
                isCurr = new ResettableInputStream(fileOrig);
            } else if (uri != null && ContextHolder.getAppContext() != null) {
                isCurr = ContextHolder.getAppContext().getContentResolver().openInputStream(uri);
            }
            isCurr = new InputSubstream(isCurr, req.getFileOffset(), req.getFileContentLength(), req.isLastPart());
            return cipherLite.markSupported() ? new CipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart()) : new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart());
        }
        catch (Exception e) {
            throw CosXmlClientException.internalException((String)("Unable to create cipher input stream: " + e.getMessage()));
        }
    }

    @Override
    public CompleteMultiUploadResult completeMultipartUploadSecurely(CompleteMultiUploadRequest req) throws CosXmlClientException, CosXmlServiceException {
        String uploadId = req.getUploadId();
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (uploadContext != null && !uploadContext.hasFinalPartBeenSeen()) {
            throw CosXmlClientException.internalException((String)"Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in COS is incomplete and corrupt.");
        }
        CompleteMultiUploadResult result = this.cos.completeMultiUpload(req);
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, ContentCryptoMaterial instruction) throws CosXmlClientException {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        try {
            return instruction.toObjectMetadata(metadata);
        }
        catch (JSONException e) {
            throw CosXmlClientException.internalException((String)e.getMessage());
        }
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(CosXmlRequest req) throws CosXmlClientException {
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, null, req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider, CosXmlRequest req) throws CosXmlClientException {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        if (kekMaterials == null) {
            return null;
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider, CosXmlRequest req) throws CosXmlClientException {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        if (kekMaterials == null) {
            throw CosXmlClientException.internalException((String)"No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials materials, Provider provider, CosXmlRequest req) throws CosXmlClientException {
        byte[] iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(iv);
        if (materials.isKMSEnabled()) {
            Map<String, String> encryptionContext = ContentCryptoMaterial.mergeMaterialDescriptions(materials, req);
            GenerateDataKeyRequest keyGenReq = new GenerateDataKeyRequest();
            try {
                keyGenReq.setEncryptionContext(JSONUtils.toJsonString(encryptionContext));
            }
            catch (JSONException e) {
                throw CosXmlClientException.internalException((String)"generate datakey request set encryption context got json processing exception");
            }
            keyGenReq.setKeyId(materials.getCustomerMasterKeyId());
            keyGenReq.setKeySpec(this.contentCryptoScheme.getKeySpec());
            GenerateDataKeyResponse keyGenRes = this.kms.generateDataKey(keyGenReq);
            byte[] key = Base64.decode(keyGenRes.getPlaintext());
            SecretKeySpec cek = new SecretKeySpec(key, this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            byte[] keyBlob = keyGenRes.getCiphertextBlob().getBytes();
            return ContentCryptoMaterial.wrap(cek, iv, this.contentCryptoScheme, provider, new KMSSecuredCEK(keyBlob, encryptionContext));
        }
        return ContentCryptoMaterial.create(this.generateCEK(materials, provider), iv, materials, this.cryptoScheme, provider, this.kms, req);
    }

    protected final SecretKey generateCEK(EncryptionMaterials kekMaterials, Provider providerIn) throws CosXmlClientException {
        String keygenAlgo = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        try {
            String keyWrapAlgo;
            KeyGenerator generator = providerIn == null ? KeyGenerator.getInstance(keygenAlgo) : KeyGenerator.getInstance(keygenAlgo, providerIn);
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            boolean involvesBCPublicKey = false;
            KeyPair keypair = kekMaterials.getKeyPair();
            if (keypair != null && (keyWrapAlgo = this.cryptoScheme.getKeyWrapScheme().getKeyWrapAlgorithm(keypair.getPublic())) == null) {
                Provider provider = generator.getProvider();
                String providerName = provider == null ? null : provider.getName();
                involvesBCPublicKey = "BC".equals(providerName);
            }
            SecretKey secretKey = generator.generateKey();
            if (!involvesBCPublicKey || secretKey.getEncoded()[0] != 0) {
                return secretKey;
            }
            for (int retry = 0; retry < 10; ++retry) {
                secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw CosXmlClientException.internalException((String)"Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException e) {
            throw CosXmlClientException.internalException((String)("Unable to generate envelope symmetric key:" + e.getMessage()));
        }
    }

    @Nullable
    private InputStream openInputStream(PutObjectRequest putObjectRequest) throws IOException {
        String filePath = putObjectRequest.getSrcPath();
        Uri uri = putObjectRequest.getUri();
        InputStream inputStream = null;
        if (filePath != null) {
            inputStream = new FileInputStream(filePath);
        } else if (uri != null && ContextHolder.getAppContext() != null) {
            inputStream = ContextHolder.getAppContext().getContentResolver().openInputStream(uri);
        }
        return inputStream;
    }

    protected final PutObjectRequest wrapWithCipher(PutObjectRequest request, ContentCryptoMaterial cekMaterial) throws CosXmlClientException {
        String md5;
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (TextUtils.isEmpty((CharSequence)(md5 = metadata.getContentMD5()))) {
            try {
                InputStream inputStream = this.openInputStream(request);
                if (inputStream != null) {
                    md5 = DigestUtils.getCOSMd5((InputStream)inputStream, (long)0L, (long)-1L);
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        if (md5 != null) {
            metadata.addUserMetadata("x-cos-meta-client-side-encryption-unencrypted-content-md5", md5);
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("x-cos-meta-client-side-encryption-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setMetadata(metadata);
        request.setInputStream(this.newCOSCipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setSrcPath(null);
        return request;
    }

    protected final InitMultipartUploadRequest cipherInitMultipartUploadRequest(InitMultipartUploadRequest request) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            return request;
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("x-cos-meta-client-side-encryption-unencrypted-content-md5", metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        if (metadata.getContentLength() != 0L) {
            metadata.addUserMetadata("x-cos-meta-client-side-encryption-unencrypted-content-length", Long.toString(metadata.getContentLength()));
            metadata.setContentLength(0L);
        }
        request.setMetadata(metadata);
        return request;
    }

    private CipherLiteInputStream newCOSCipherLiteInputStream(PutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) throws CosXmlClientException {
        try {
            CipherLite cipherLite;
            InputStream isCurr = this.openInputStream(req);
            if (plaintextLength > -1L) {
                isCurr = new LengthCheckInputStream(isCurr, plaintextLength, false);
            }
            if ((cipherLite = cekMaterial.getCipherLite()).markSupported()) {
                return new CipherLiteInputStream(isCurr, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048);
        }
        catch (Exception e) {
            throw CosXmlClientException.internalException((String)("Unable to create cipher input stream: " + e.getMessage()));
        }
    }

    public CipherLiteInputStream newCOSCipherLiteInputStream(PutObjectRequest req, CipherLite cipherLite) throws CosXmlClientException {
        try {
            InputStream isCurr = this.openInputStream(req);
            if (cipherLite.markSupported()) {
                return new CipherLiteInputStream(isCurr, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048);
        }
        catch (Exception e) {
            throw CosXmlClientException.internalException((String)("Unable to create cipher input stream: " + e.getMessage()));
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        Context context;
        String filePath = request.getSrcPath();
        Uri uri = request.getUri();
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            return new File(filePath).length();
        }
        if (uri != null && (context = ContextHolder.getAppContext()) != null) {
            return QCloudUtils.getUriContentLength((Uri)uri, (ContentResolver)context.getContentResolver());
        }
        return -1L;
    }

    public final COSCryptoScheme getCOSCryptoScheme() {
        return this.cryptoScheme;
    }

    static Range getAdjustedCryptoRange(Range range) {
        if (range == null) {
            return null;
        }
        long rangeStart = CryptoModuleBase.getCipherBlockLowerBound(range.getStart());
        long rangeEnd = range.getEnd() == -1L ? -1L : CryptoModuleBase.getCipherBlockUpperBound(range.getEnd());
        return new Range(rangeStart, rangeEnd);
    }

    static long[] getAdjustedCryptoRange(long[] range) {
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{CryptoModuleBase.getCipherBlockLowerBound(range[0]), CryptoModuleBase.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        return lowerBound < 0L ? 0L : lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        long upperBound = rightmostBytePosition + offset + cipherBlockSize;
        return upperBound < 0L ? Long.MAX_VALUE : upperBound;
    }
}

