/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import bolts.CancellationTokenSource;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.crypto.MultipartUploadCryptoContext;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.crypto.ResettableInputStream;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.tag.ListMultipartUploads;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.model.tag.UrlUploadPolicy;
import com.tencent.cos.xml.transfer.BaseUploadPartsTask;
import com.tencent.cos.xml.transfer.COSTransferTask;
import com.tencent.cos.xml.transfer.ParallelUploadPartsTask;
import com.tencent.cos.xml.transfer.SerialUploadPartsTask;
import com.tencent.cos.xml.transfer.TransferTaskMetrics;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class COSUploadTask
extends COSTransferTask {
    public static final String TAG = "QCloudUpload";
    private static final int UPLOAD_CONCURRENT = 2;
    private static ThreadPoolExecutor uploadTaskExecutor = new ThreadPoolExecutor(2, 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new COSTransferTask.TaskThreadFactory("QCloudUpload-", 8));
    private PutObjectRequest mPutObjectRequest;
    private BaseUploadTask uploadTask;
    private long multipartUploadThreshold = 0x200000L;
    private long mMaxPartSize = 0x100000L;
    private boolean verifyCRC64 = true;
    private boolean mForceSimpleUpload = false;
    private long uploadLength = -1L;

    public COSUploadTask(COSDirect cosDirect, PutObjectRequest putObjectRequest) {
        super(cosDirect, (ObjectRequest)putObjectRequest);
        this.mPutObjectRequest = putObjectRequest;
    }

    @Override
    protected String tag() {
        return TAG;
    }

    @Override
    protected Executor executor() {
        return uploadTaskExecutor;
    }

    @Override
    public void pause() {
        super.pause();
        if (this.uploadTask != null) {
            this.uploadTask.cancel();
        }
    }

    @Override
    public void pause(boolean now) {
        super.pause();
        if (this.uploadTask != null) {
            this.uploadTask.cancel(now);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.uploadTask != null) {
            this.uploadTask.cancel();
        }
        if (this.uploadTask instanceof MultipartUploadTask) {
            ((MultipartUploadTask)this.uploadTask).abort();
        }
    }

    @Override
    public void cancel(boolean now) {
        super.cancel();
        if (this.uploadTask != null) {
            this.uploadTask.cancel(now);
        }
        if (this.uploadTask instanceof MultipartUploadTask) {
            ((MultipartUploadTask)this.uploadTask).abort();
        }
    }

    void setPartSize(long partSize) {
        this.mMaxPartSize = partSize;
    }

    void setVerifyCRC64(boolean verifyCRC64) {
        this.verifyCRC64 = verifyCRC64;
    }

    void setSliceSizeThreshold(long threshold) {
        this.multipartUploadThreshold = threshold;
    }

    void forceSimpleUpload(boolean forceSimpleUpload) {
        this.mForceSimpleUpload = forceSimpleUpload;
    }

    @Override
    protected void checking() throws CosXmlClientException {
        super.checking();
        this.mPutObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                COSUploadTask.this.onTransferProgressChange(complete, COSUploadTask.this.getUploadLength());
            }
        });
        byte[] bytes = this.mPutObjectRequest.getData();
        InputStream inputStream = this.mPutObjectRequest.getInputStream();
        String filePath = this.mPutObjectRequest.getSrcPath();
        Uri uri = this.mPutObjectRequest.getUri();
        URL url = this.mPutObjectRequest.getUrl();
        String str = this.mPutObjectRequest.getStrData();
        UrlUploadPolicy urlUploadPolicy = this.mPutObjectRequest.getUrlUploadPolicy();
        if (TextUtils.isEmpty((CharSequence)filePath) && uri == null && bytes == null && str == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Only support upload file path, uri, bytes array and string");
        }
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            if (!file.exists()) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), filePath + " is not exist.");
            }
            if (file.isDirectory()) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), filePath + " is directory.");
            }
            if (!file.canRead()) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), " read " + filePath + " failed, please check permission to read this file.");
            }
            this.uploadLength = file.length();
        } else if (uri != null) {
            Context context = ContextHolder.getAppContext();
            if (context != null) {
                if (!QCloudUtils.doesUriFileExist((Uri)uri, (ContentResolver)context.getContentResolver())) {
                    throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "uri " + uri + " is not exist");
                }
                this.uploadLength = QCloudUtils.getUriContentLength((Uri)uri, (ContentResolver)context.getContentResolver());
            }
        } else if (bytes != null) {
            this.uploadLength = bytes.length;
        } else if (str != null) {
            this.uploadLength = str.getBytes().length;
        }
        COSUploadTask.loggerInfo(TAG, this.taskId, "checkout upload length=%d", this.uploadLength);
    }

    @Override
    protected CosXmlResult execute() throws Exception {
        if (this.shouldMultipartUpload()) {
            COSUploadTask.loggerInfo(TAG, this.taskId, "start upload with multipart upload", new Object[0]);
            MultipartUploadTask multipartUploadTask = new MultipartUploadTask(this.cosDirect, this.mPutObjectRequest, this.mTransferTaskCts, this.getUploadLength());
            multipartUploadTask.mMaxPartSize = this.mMaxPartSize;
            multipartUploadTask.verifyCRC64 = this.verifyCRC64;
            this.uploadTask = multipartUploadTask;
        } else {
            COSUploadTask.loggerInfo(TAG, this.taskId, "start upload with simple upload.", this.key);
            this.uploadTask = new SimpleUploadTask(this.cosDirect, this.mPutObjectRequest, this.mTransferTaskCts, this.getUploadLength());
        }
        this.uploadTask.mTransferMetrics = this.transferTaskMetrics;
        this.uploadTask.setTaskId(this.taskId);
        CosXmlResult cosxmlResult = this.uploadTask.upload(this.mPutObjectRequest);
        if (cosxmlResult instanceof CompleteMultiUploadResult) {
            return this.buildPutObjectResult((CompleteMultiUploadResult)cosxmlResult);
        }
        return cosxmlResult;
    }

    private PutObjectResult buildPutObjectResult(CompleteMultiUploadResult completeMultiUploadResult) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.httpCode = completeMultiUploadResult.httpCode;
        putObjectResult.httpMessage = completeMultiUploadResult.httpMessage;
        putObjectResult.headers = completeMultiUploadResult.headers;
        putObjectResult.accessUrl = completeMultiUploadResult.accessUrl;
        putObjectResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
        putObjectResult.picUploadResult = completeMultiUploadResult.completeMultipartUpload.getPicUploadResult();
        return putObjectResult;
    }

    private boolean shouldMultipartUpload() {
        return !this.mForceSimpleUpload && this.isMultipartUploadRequest() && this.isMultipartUploadLength();
    }

    private boolean isMultipartUploadLength() {
        return this.uploadLength >= this.multipartUploadThreshold;
    }

    private boolean isMultipartUploadRequest() {
        return this.mPutObjectRequest.getSrcPath() != null || this.mPutObjectRequest.getUri() != null;
    }

    private long getUploadLength() {
        return this.uploadLength;
    }

    private static class MultipartUploadTask
    extends BaseUploadTask {
        private String bucket;
        private String region;
        private String key;
        private TreeSet<UploadPart> uploadParts;
        private BaseUploadPartsTask uploadPartsTask;
        private String mUploadId;
        private volatile ListMultiUploadsRequest listMultiUploadsRequest;
        private volatile InitMultipartUploadRequest initMultipartUploadRequest;
        private volatile ListPartsRequest listPartsRequest;
        private volatile CompleteMultiUploadRequest completeMultiUploadRequest;
        private CosXmlSimpleService cosService;
        private MultipartUploadCryptoContext mCryptoContext;
        private long mMaxPartSize = 0x100000L;
        private boolean verifyCRC64 = true;

        public MultipartUploadTask(COSDirect apiDirect, PutObjectRequest putObjectRequest, CancellationTokenSource cts, long totalUploadSize) {
            super(apiDirect, putObjectRequest, cts, totalUploadSize);
            this.putObjectRequest = putObjectRequest;
            this.tcs = new TaskCompletionSource();
            this.bucket = putObjectRequest.getBucket();
            this.region = putObjectRequest.getRegion();
            this.key = putObjectRequest.getCosPath();
            this.uploadParts = new TreeSet<UploadPart>(new Comparator<UploadPart>(){

                @Override
                public int compare(UploadPart o1, UploadPart o2) {
                    int x = o1.number;
                    int y = o2.number;
                    return x < y ? -1 : (x == y ? 0 : 1);
                }
            });
            this.cosService = this.cosDirect.getCosService();
        }

        @Override
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        protected CosXmlResult upload(PutObjectRequest putObjectRequest) throws Exception {
            if (!this.cosDirect.isTransferSecurely()) {
                this.checkoutManualCanceled();
                List<String> uploadIds = this.listObjectUploadIds();
                this.checkoutManualCanceled();
                for (String uploadId : uploadIds) {
                    if (!this.checkoutUploadId(uploadId)) continue;
                    this.mUploadId = uploadId;
                    break;
                }
            }
            this.checkoutManualCanceled();
            if (TextUtils.isEmpty((CharSequence)this.mUploadId)) {
                this.mUploadId = this.initUploadId();
            }
            this.checkoutManualCanceled();
            this.uploadParts(this.mUploadId);
            this.checkoutManualCanceled();
            CosXmlResult cosXmlResult = this.completeMultipartUpload(this.mUploadId);
            if (this.verifyCRC64) {
                this.checkoutManualCanceled();
                this.crc64Verify(cosXmlResult.getHeader("x-cos-hash-crc64ecma"));
            }
            return cosXmlResult;
        }

        @Override
        public void cancel() {
            if (this.listMultiUploadsRequest != null) {
                this.cosDirect.cancel(this.listMultiUploadsRequest);
            }
            if (this.initMultipartUploadRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.initMultipartUploadRequest);
            }
            if (this.listPartsRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.listPartsRequest);
            }
            if (this.completeMultiUploadRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.completeMultiUploadRequest);
            }
            if (this.uploadPartsTask != null) {
                this.uploadPartsTask.cancel();
            }
        }

        @Override
        public void cancel(boolean now) {
            if (this.listMultiUploadsRequest != null) {
                this.cosDirect.cancel(this.listMultiUploadsRequest, now);
            }
            if (this.initMultipartUploadRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.initMultipartUploadRequest, now);
            }
            if (this.listPartsRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.listPartsRequest, now);
            }
            if (this.completeMultiUploadRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.completeMultiUploadRequest, now);
            }
            if (this.uploadPartsTask != null) {
                this.uploadPartsTask.cancel(now);
            }
        }

        private void abort() {
            if (!TextUtils.isEmpty((CharSequence)this.mUploadId)) {
                AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.key, this.mUploadId);
                abortMultiUploadRequest.setRegion(this.region);
                this.cosService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

                    public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    }

                    public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                    }
                });
            }
        }

        private boolean isParallelUpload() {
            return !this.cosDirect.isTransferSecurely();
        }

        private void checkoutManualCanceled() throws CosXmlClientException {
            if (this.mTransferTaskCts.isCancellationRequested()) {
                throw CosXmlClientException.manualCancelException();
            }
        }

        private String getStorageClass() {
            List storageClassList = (List)this.putObjectRequest.getRequestHeaders().get("x-cos-storage-class");
            if (storageClassList == null || storageClassList.isEmpty()) {
                return "STANDARD";
            }
            return (String)storageClassList.get(0);
        }

        private List<String> listObjectUploadIds() throws CosXmlClientException, CosXmlServiceException {
            String prefix = this.key.startsWith("/") ? this.key.substring(1) : this.key;
            HttpTaskMetrics httpTaskMetrics = new HttpTaskMetrics();
            this.listMultiUploadsRequest = new ListMultiUploadsRequest(this.bucket);
            this.listMultiUploadsRequest.setPrefix(prefix);
            this.listMultiUploadsRequest.setRegion(this.region);
            this.listMultiUploadsRequest.attachMetrics(httpTaskMetrics);
            LinkedList<String> uploadIds = new LinkedList<String>();
            ListMultiUploadsResult listMultiUploadsResult = this.cosService.listMultiUploads(this.listMultiUploadsRequest);
            this.mTransferMetrics.connectAddress = httpTaskMetrics.getConnectAddress();
            ListMultipartUploads listMultipartUploads = listMultiUploadsResult.listMultipartUploads;
            if (listMultipartUploads != null) {
                List<ListMultipartUploads.Upload> uploads = listMultipartUploads.uploads;
                COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "find %d uploadIds with prefix %s", uploads.size(), prefix);
                if (!uploads.isEmpty()) {
                    Collections.sort(uploads, new Comparator<ListMultipartUploads.Upload>(){

                        @Override
                        public int compare(ListMultipartUploads.Upload o1, ListMultipartUploads.Upload o2) {
                            Long y = this.parseInitiatedDate(o1.initiated);
                            Long x = this.parseInitiatedDate(o2.initiated);
                            return x < y ? -1 : (x == y ? 0 : 1);
                        }
                    });
                    for (ListMultipartUploads.Upload upload : uploads) {
                        if (!upload.key.equals(prefix) || !upload.storageClass.equals(this.getStorageClass())) continue;
                        uploadIds.add(upload.uploadID);
                    }
                }
            }
            COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "find %d plan uploadId", uploadIds.size());
            return uploadIds;
        }

        private String initUploadId() throws Exception {
            this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.key);
            this.initMultipartUploadRequest.setRegion(this.region);
            this.initMultipartUploadRequest.setRequestHeaders(this.getInitHeaders(this.putObjectRequest));
            HttpTaskMetrics httpTaskMetrics = new HttpTaskMetrics();
            this.initMultipartUploadRequest.attachMetrics(httpTaskMetrics);
            if (this.cosDirect.isTransferSecurely()) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentLength(this.totalUploadSize);
                objectMetadata.setContentMD5(DigestUtils.getCOSMd5((InputStream)this.openUnencryptedInputStream(), (long)0L, (long)this.totalUploadSize));
                this.initMultipartUploadRequest.setMetadata(objectMetadata);
            }
            InitMultipartUploadResult initMultipartUploadResult = this.cosDirect.initMultipartUpload(this.initMultipartUploadRequest);
            this.mTransferMetrics.connectAddress = httpTaskMetrics.getConnectAddress();
            String uploadId = initMultipartUploadResult.initMultipartUpload.uploadId;
            if (this.cosDirect.isTransferSecurely()) {
                this.mCryptoContext = this.cosDirect.getCryptoModule().getCryptoContext(uploadId);
            }
            COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "create a new uploadId %s", uploadId);
            return uploadId;
        }

        private Map<String, List<String>> getInitHeaders(PutObjectRequest putObjectRequest) {
            Map customHeaders = putObjectRequest.getRequestHeaders();
            if (customHeaders == null) {
                return new HashMap<String, List<String>>();
            }
            return new HashMap<String, List<String>>(customHeaders);
        }

        private Map<String, List<String>> getCompleteHeaders(PutObjectRequest putObjectRequest) {
            Map customHeaders = putObjectRequest.getRequestHeaders();
            if (customHeaders == null) {
                return new HashMap<String, List<String>>();
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(customHeaders);
            headers.remove("Content-Type");
            return headers;
        }

        private boolean checkoutUploadId(String uploadId) throws CosXmlClientException, CosXmlServiceException {
            this.uploadParts.clear();
            if (this.cosDirect.isTransferSecurely()) {
                if (this.cosDirect.getCryptoModule() == null) {
                    throw CosXmlClientException.internalException((String)"cannot client size encryption, crypto module is null");
                }
                if (!this.cosDirect.getCryptoModule().hasMultipartUploadContext(uploadId)) {
                    return false;
                }
            }
            this.listPartsRequest = new ListPartsRequest(this.bucket, this.key, uploadId);
            this.listPartsRequest.setRegion(this.region);
            ListPartsResult listPartsResult = this.cosService.listParts(this.listPartsRequest);
            List<ListParts.Part> parts = listPartsResult.listParts.parts;
            Collections.sort(parts, new Comparator<ListParts.Part>(){

                @Override
                public int compare(ListParts.Part o1, ListParts.Part o2) {
                    int y;
                    int x = Integer.parseInt(o1.partNumber);
                    return x < (y = Integer.parseInt(o2.partNumber)) ? -1 : (x == y ? 0 : 1);
                }
            });
            int nextPartNumber = 0;
            int offset = 0;
            try {
                InputStream localInputStream = this.openInputStream();
                for (ListParts.Part part : parts) {
                    int partNumber = Integer.parseInt(part.partNumber);
                    long partSize = Long.parseLong(part.size);
                    if (++nextPartNumber != partNumber) {
                        COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "part number %d not continuous", partNumber);
                        break;
                    }
                    String localMd5 = DigestUtils.getCOSMd5((InputStream)localInputStream, (long)0L, (long)partSize);
                    if (localMd5 == null || !localMd5.equals(part.eTag)) {
                        COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "part number %d md5 not the same, local md5=%s, part md5=%s", partNumber, localMd5, part.eTag);
                        break;
                    }
                    COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "check part %d success", partNumber);
                    this.uploadParts.add(new UploadPart(part.eTag, partNumber, offset, partSize));
                    offset = (int)((long)offset + partSize);
                }
                localInputStream.close();
            }
            catch (IOException exception) {
                COSTransferTask.loggerWarn(COSUploadTask.TAG, this.taskId, "check parts encounter exception: %s", exception.getMessage());
                throw CosXmlClientException.internalException((String)exception.getMessage());
            }
            COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "you have uploaded %d parts of it, upload offset: %s, partNumber: %d", parts.size(), offset, nextPartNumber);
            return true;
        }

        private long parseInitiatedDate(String date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
            try {
                return dateFormat.parse(date).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
                return 0L;
            }
        }

        private void uploadParts(String uploadId) throws Exception {
            UploadPart lastUploadedPart;
            long offset = 0L;
            long size = this.totalUploadSize;
            int startNumber = 1;
            UploadPart uploadPart = lastUploadedPart = this.uploadParts.isEmpty() ? null : this.uploadParts.last();
            if (lastUploadedPart != null) {
                offset = lastUploadedPart.offset + lastUploadedPart.size;
                size -= offset;
                startNumber = lastUploadedPart.number + 1;
            }
            this.mTransferMetrics.size = size;
            if (size > 0L) {
                COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "start upload parts, offset=%s, size=%d, startNumber=%d", offset, size, startNumber);
                this.uploadPartsTask = this.isParallelUpload() ? new ParallelUploadPartsTask(this.cosDirect, this.putObjectRequest, offset, size, startNumber, uploadId) : new SerialUploadPartsTask(this.cosDirect, this.putObjectRequest, offset, size, startNumber, uploadId);
                this.uploadPartsTask.mMaxPartSize = this.mMaxPartSize;
                this.uploadPartsTask.setTaskId(this.taskId);
                this.uploadPartsTask.setProgressListener(this.putObjectRequest.getProgressListener());
                this.uploadParts.addAll(this.uploadPartsTask.upload());
            }
        }

        private CosXmlResult completeMultipartUpload(String uploadId) throws CosXmlClientException, CosXmlServiceException {
            LinkedHashMap<Integer, String> partNumberAndETag = new LinkedHashMap<Integer, String>();
            for (UploadPart uploadPart : this.uploadParts) {
                partNumberAndETag.put(uploadPart.number, uploadPart.etag);
            }
            try {
                this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.key, uploadId, partNumberAndETag);
                this.completeMultiUploadRequest.setRequestHeaders(this.getCompleteHeaders(this.putObjectRequest));
                CompleteMultiUploadResult completeMultiUploadResult = this.cosDirect.completeMultipartUpload(this.completeMultiUploadRequest);
                COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "complete upload task", this.key, uploadId);
                return completeMultiUploadResult;
            }
            catch (CosXmlServiceException serviceException) {
                if ("NoSuchUpload".equals(serviceException.getErrorCode())) {
                    try {
                        HeadObjectRequest headObjectRequest = new HeadObjectRequest(this.bucket, this.key);
                        headObjectRequest.setRegion(this.region);
                        COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "complete uploadId [%s] failed with NoSuchUpload. check if it has been uploaded by HeadObjectRequest.", uploadId);
                        return this.cosService.headObject(headObjectRequest);
                    }
                    catch (Exception exception) {
                        throw serviceException;
                    }
                }
                throw serviceException;
            }
        }

        private void crc64Verify(String crc64) throws CosXmlClientException {
            if (TextUtils.isEmpty((CharSequence)crc64)) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "unable to verify with crc64 is null");
            }
            try {
                long remoteCrc64 = DigestUtils.getBigIntFromString((String)crc64);
                InputStream inputStream = this.openInputStream();
                long localCrc64 = DigestUtils.getCRC64((InputStream)inputStream);
                inputStream.close();
                if (remoteCrc64 != localCrc64) {
                    throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), String.format(Locale.ENGLISH, "crc64 verify failed, remote crc 64bit value is %d, but local crc 64bit value is %d", remoteCrc64, localCrc64));
                }
                COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "verify crc64 %s success", crc64);
            }
            catch (IOException ioException) {
                throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), String.format(Locale.ENGLISH, "failed open inputStream to verify crc64: %s", ioException.getMessage()));
            }
        }

        private InputStream openInputStream() throws CosXmlClientException {
            InputStream inputStream = this.openUnencryptedInputStream();
            if (this.cosDirect.isTransferSecurely()) {
                if (this.mCryptoContext != null) {
                    inputStream = this.cosDirect.getCryptoModule().newCOSCipherLiteInputStream(this.putObjectRequest, this.mCryptoContext.getCipherLite());
                } else {
                    throw CosXmlClientException.internalException((String)(this.mUploadId + " crypto context not found"));
                }
            }
            this.assetNotNull(inputStream);
            return inputStream;
        }

        private InputStream openUnencryptedInputStream() throws CosXmlClientException {
            InputStream inputStream = null;
            try {
                String filePath = this.putObjectRequest.getSrcPath();
                Uri uri = this.putObjectRequest.getUri();
                if (filePath != null) {
                    inputStream = new ResettableInputStream(filePath);
                } else if (uri != null && ContextHolder.getAppContext() != null) {
                    inputStream = ContextHolder.getAppContext().getContentResolver().openInputStream(uri);
                }
            }
            catch (Exception e) {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), "open InputStream failed");
            }
            this.assetNotNull(inputStream);
            return inputStream;
        }

        private void assetNotNull(Object object) throws CosXmlClientException {
            if (object == null) {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), Object.class.getSimpleName() + "is null");
            }
        }
    }

    private static class SimpleUploadTask
    extends BaseUploadTask {
        SimpleUploadTask(COSDirect apiDirect, PutObjectRequest putObjectRequest, CancellationTokenSource cts, long totalUploadSize) {
            super(apiDirect, putObjectRequest, cts, totalUploadSize);
        }

        @Override
        public void cancel() {
            this.cosDirect.cancel((CosXmlRequest)this.putObjectRequest);
        }

        @Override
        public void cancel(boolean now) {
            this.cosDirect.cancel((CosXmlRequest)this.putObjectRequest, now);
        }

        protected PutObjectResult upload(PutObjectRequest putObjectRequest) throws Exception {
            HttpTaskMetrics httpTaskMetrics = new HttpTaskMetrics();
            this.mTransferMetrics.size = this.totalUploadSize;
            putObjectRequest.attachMetrics(httpTaskMetrics);
            PutObjectResult putObjectResult = this.cosDirect.putObject(putObjectRequest);
            this.mTransferMetrics.connectAddress = httpTaskMetrics.getConnectAddress();
            COSTransferTask.loggerInfo(COSUploadTask.TAG, this.taskId, "complete upload task", new Object[0]);
            return putObjectResult;
        }
    }

    static abstract class BaseUploadTask {
        protected TaskCompletionSource<CosXmlResult> tcs;
        protected COSDirect cosDirect;
        protected PutObjectRequest putObjectRequest;
        protected CancellationTokenSource mTransferTaskCts;
        protected String taskId;
        protected TransferTaskMetrics mTransferMetrics;
        protected long totalUploadSize;

        BaseUploadTask(COSDirect apiDirect, PutObjectRequest putObjectRequest, CancellationTokenSource transferTaskCts, long totalUploadSize) {
            this.cosDirect = apiDirect;
            this.putObjectRequest = putObjectRequest;
            this.tcs = new TaskCompletionSource();
            this.mTransferTaskCts = transferTaskCts;
            this.totalUploadSize = totalUploadSize;
        }

        public Task<CosXmlResult> getTask() {
            return this.tcs.getTask();
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public abstract void cancel();

        public abstract void cancel(boolean var1);

        protected abstract CosXmlResult upload(PutObjectRequest var1) throws Exception;
    }

    static final class UploadPart {
        String etag;
        int number;
        long offset;
        long size;

        public UploadPart(String etag, int number, long offset, long size) {
            this.etag = etag;
            this.number = number;
            this.offset = offset;
            this.size = size;
        }
    }
}

