/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.CosTrackService;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.CallbackResult;
import com.tencent.cos.xml.model.tag.InitiateMultipartUpload;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.model.tag.UrlUploadPolicy;
import com.tencent.cos.xml.model.tag.pic.PicUploadResult;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.utils.CloseUtil;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class COSXMLUploadTask
extends COSXMLTask {
    private final String TAG = "UploadTask";
    private static Executor executor = Executors.newSingleThreadExecutor();
    protected long multiUploadSizeDivision;
    String srcPath;
    private long fileLength;
    private byte[] bytes;
    private InputStream inputStream;
    private Uri uri;
    private URL url;
    private UrlUploadPolicy urlUploadPolicy;
    private PutObjectRequest putObjectRequest;
    private HeadObjectRequest headObjectRequest;
    private boolean isSliceUpload = false;
    protected long sliceSize;
    private String uploadId;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private Object SYNC_UPLOAD_PART = new Object();
    private long startTime = 0L;
    private long simpleAlreadySendDataLen = 0L;
    boolean forceSimpleUpload;
    boolean priorityLow = false;
    HttpTaskMetrics httpTaskMetrics;
    private String clientTraceId;
    private AtomicBoolean sendingCompleteRequest = new AtomicBoolean(false);
    private WeightStrategy weightStrategy = new WeightStrategy();
    private MultiUploadsStateListener multiUploadsStateListenerHandler = new MultiUploadsStateListener(){

        @Override
        public void onInit() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onListParts() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onUploadParts() {
            COSXMLUploadTask.this.completeMultiUpload(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onCompleted(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
            COSXMLUploadTask.this.updateState(TransferState.COMPLETED, null, cosXmlResult, false);
        }

        @Override
        public void onFailed(CosXmlRequest cosXmlRequest, CosXmlClientException clientException, CosXmlServiceException serviceException) {
            Throwable causeException = clientException == null ? serviceException : clientException;
            COSXMLUploadTask.this.reportException(cosXmlRequest, clientException, serviceException);
            COSXMLUploadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
        }
    };

    private COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath) {
        this.cosXmlService = cosXmlService;
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.httpTaskMetrics = new HttpTaskMetrics();
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String srcPath, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.srcPath = srcPath;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, Uri uri, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.uri = uri;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, URL url, UrlUploadPolicy urlUploadPolicy, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.url = url;
        this.urlUploadPolicy = urlUploadPolicy;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, URL url, String uploadId) {
        this(cosXmlService, region, bucket, cosPath);
        this.url = url;
        this.uploadId = uploadId;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, byte[] bytes) {
        this(cosXmlService, region, bucket, cosPath);
        this.bytes = bytes;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, InputStream inputStream) {
        this(cosXmlService, region, bucket, cosPath);
        this.inputStream = inputStream;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, PutObjectRequest putObjectRequest, String uploadId) {
        this(cosXmlService, putObjectRequest.getRegion(), putObjectRequest.getBucket(), putObjectRequest.getPath(cosXmlService.getConfig()));
        this.uri = putObjectRequest.getUri();
        this.url = putObjectRequest.getUrl();
        this.urlUploadPolicy = putObjectRequest.getUrlUploadPolicy();
        this.srcPath = putObjectRequest.getSrcPath();
        this.bytes = putObjectRequest.getData();
        this.inputStream = putObjectRequest.getInputStream();
        this.queries = putObjectRequest.getQueryString();
        this.headers = putObjectRequest.getRequestHeaders();
        this.noSignHeaders = putObjectRequest.getNoSignHeaders();
        this.isNeedMd5 = putObjectRequest.isNeedMD5();
        this.credentialProvider = putObjectRequest.getCredentialProvider();
        this.uploadId = uploadId;
        this.priorityLow = putObjectRequest.isPriorityLow();
    }

    protected boolean checkParameter() {
        Context context;
        if (this.bytes == null && this.inputStream == null && this.srcPath == null && this.uri == null && this.url == null) {
            if (this.IS_EXIT.get()) {
                return false;
            }
            this.IS_EXIT.set(true);
            this.multiUploadsStateListenerHandler.onFailed((CosXmlRequest)new PutObjectRequest(this.bucket, this.cosPath, ""), new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "source is is invalid: null"), null);
            return false;
        }
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            if (!file.exists() || file.isDirectory() || !file.canRead()) {
                if (this.IS_EXIT.get()) {
                    return false;
                }
                this.IS_EXIT.set(true);
                this.multiUploadsStateListenerHandler.onFailed((CosXmlRequest)new PutObjectRequest(this.bucket, this.cosPath, this.srcPath), new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "srcPath is is invalid: " + this.srcPath), null);
                return false;
            }
            this.fileLength = file.length();
        }
        if (this.uri != null && (context = ContextHolder.getAppContext()) != null) {
            this.fileLength = QCloudUtils.getUriContentLength((Uri)this.uri, (ContentResolver)context.getContentResolver());
        }
        if (this.url != null && this.urlUploadPolicy != null) {
            if (this.urlUploadPolicy.getDownloadType() != UrlUploadPolicy.Type.NOTSUPPORT) {
                this.fileLength = this.urlUploadPolicy.getFileLength();
            } else {
                if (this.IS_EXIT.get()) {
                    return false;
                }
                monitor.sendStateMessage(this, TransferState.FAILED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "url not support download")), null, 1);
                this.IS_EXIT.set(true);
                return false;
            }
        }
        return true;
    }

    protected void upload() {
        if (!this.checkParameter()) {
            return;
        }
        this.startTime = System.nanoTime();
        this.clientTraceId = UUID.randomUUID().toString();
        this.startUpload();
    }

    private void dispatchProgressChange(long complete, long target) {
        if (this.cosXmlProgressListener != null) {
            this.cosXmlProgressListener.onProgress(complete, target);
        }
        if (this.internalProgressListener != null) {
            this.internalProgressListener.onProgress(complete, target);
        }
    }

    private void dispatchInitMultipleUpload(InitiateMultipartUpload initiateMultipartUpload) {
        if (this.initMultipleUploadListener != null) {
            this.initMultipleUploadListener.onSuccess(initiateMultipartUpload);
        }
        if (this.internalInitMultipleUploadListener != null) {
            this.internalInitMultipleUploadListener.onSuccess(initiateMultipartUpload);
        }
    }

    private void simpleUpload(CosXmlSimpleService cosXmlService) {
        this.putObjectRequest = this.bytes != null ? new PutObjectRequest(this.bucket, this.cosPath, this.bytes) : (this.inputStream != null ? new PutObjectRequest(this.bucket, this.cosPath, this.inputStream) : (this.uri != null ? new PutObjectRequest(this.bucket, this.cosPath, this.uri) : (this.url != null ? new PutObjectRequest(this.bucket, this.cosPath, this.url) : new PutObjectRequest(this.bucket, this.cosPath, this.srcPath))));
        this.putObjectRequest.setRegion(this.region);
        if (this.url != null) {
            this.putObjectRequest.setNeedMD5(false);
        } else {
            this.putObjectRequest.setNeedMD5(this.isNeedMd5);
        }
        this.putObjectRequest.setRequestHeaders(this.headers);
        this.putObjectRequest.addNoSignHeader(this.noSignHeaders);
        this.putObjectRequest.setCredentialProvider(this.credentialProvider);
        if (this.onSignatureListener != null) {
            this.putObjectRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.putObjectRequest));
        }
        this.getHttpMetrics((CosXmlRequest)this.putObjectRequest, "PutObjectRequest");
        this.putObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (state == 2 || state == 3) {
                    COSXMLUploadTask.this.onUpdateInProgress();
                }
            }
        });
        this.putObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                COSXMLUploadTask.this.simpleAlreadySendDataLen = complete;
                COSXMLUploadTask.this.dispatchProgressChange(complete, target);
            }
        });
        if (this.priorityLow) {
            this.putObjectRequest.setPriorityLow();
        }
        this.putObjectRequest.setClientTraceId(this.clientTraceId);
        cosXmlService.internalPutObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.putObjectRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                CosTrackService.getInstance().reportUploadTaskSuccess(request);
                COSXMLUploadTask.this.updateState(TransferState.COMPLETED, null, result, false);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.putObjectRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, clientException, serviceException);
            }
        });
    }

    private void reportException(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (request == null) {
            request = this.buildCOSXMLTaskRequest();
        }
        if (clientException != null) {
            CosTrackService.getInstance().reportUploadTaskClientException(request, (QCloudClientException)((Object)clientException));
        }
        if (serviceException != null) {
            CosTrackService.getInstance().reportUploadTaskServiceException(request, (QCloudServiceException)serviceException);
        }
    }

    private void multiUpload(CosXmlSimpleService cosXmlService) {
        this.initSlicePart(0L, this.fileLength, 1);
        if (!TextUtils.isEmpty((CharSequence)this.uploadId)) {
            this.listMultiUpload(cosXmlService);
        } else {
            this.initMultiUpload(cosXmlService);
        }
    }

    private void initMultiUpload(CosXmlSimpleService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        this.initMultipartUploadRequest.setRequestHeaders(this.headers);
        this.initMultipartUploadRequest.addNoSignHeader(this.noSignHeaders);
        this.initMultipartUploadRequest.setCredentialProvider(this.credentialProvider);
        if (this.onSignatureListener != null) {
            this.initMultipartUploadRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.initMultipartUploadRequest));
        }
        this.initMultipartUploadRequest.setClientTraceId(this.clientTraceId);
        this.httpTaskMetrics.setDomainName(this.initMultipartUploadRequest.getRequestHost(cosXmlService.getConfig()));
        this.getHttpMetrics((CosXmlRequest)this.initMultipartUploadRequest, "InitMultipartUploadRequest");
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.initMultipartUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.onUpdateInProgress();
                InitiateMultipartUpload initMultipartUpload = ((InitMultipartUploadResult)result).initMultipartUpload;
                COSXMLUploadTask.this.uploadId = initMultipartUpload.uploadId;
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onInit();
                COSXMLUploadTask.this.dispatchInitMultipleUpload(initMultipartUpload);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.initMultipartUploadRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.IS_EXIT.set(true);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    public void listAllPartsAsync(final CosXmlSimpleService cosXmlService, final CosXmlResultListener cosXmlResultListener) {
        final AtomicReference<Object> nextPartNumberMarker = new AtomicReference<Object>(null);
        final ArrayList allParts = new ArrayList();
        Runnable handleResult = new Runnable(){

            @Override
            public void run() {
                if (nextPartNumberMarker.get() != null && !((String)nextPartNumberMarker.get()).isEmpty()) {
                    COSXMLUploadTask.this.listPartsRequest.setPartNumberMarker((String)nextPartNumberMarker.get());
                }
                cosXmlService.listPartsAsync(COSXMLUploadTask.this.listPartsRequest, new CosXmlResultListener(){

                    public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                        ListPartsResult listPartsResult = (ListPartsResult)result;
                        if (listPartsResult.listParts.parts != null && listPartsResult.listParts.parts.size() > 0) {
                            allParts.addAll(listPartsResult.listParts.parts);
                        }
                        nextPartNumberMarker.set(listPartsResult.listParts.nextPartNumberMarker);
                        if (nextPartNumberMarker.get() != null && !((String)nextPartNumberMarker.get()).isEmpty()) {
                            this.run();
                        } else {
                            listPartsResult.listParts.parts = allParts;
                            cosXmlResultListener.onSuccess(request, (CosXmlResult)listPartsResult);
                        }
                    }

                    public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                        cosXmlResultListener.onFail(request, clientException, serviceException);
                    }
                });
            }
        };
        handleResult.run();
    }

    private void listMultiUpload(CosXmlSimpleService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        this.listPartsRequest.setRegion(this.region);
        this.listPartsRequest.setRequestHeaders(this.headers);
        this.listPartsRequest.addNoSignHeader(this.noSignHeaders);
        this.listPartsRequest.setCredentialProvider(this.credentialProvider);
        if (this.onSignatureListener != null) {
            this.listPartsRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.listPartsRequest));
        }
        this.httpTaskMetrics.setDomainName(this.listPartsRequest.getRequestHost(cosXmlService.getConfig()));
        this.getHttpMetrics((CosXmlRequest)this.listPartsRequest, "ListPartsRequest");
        this.listPartsRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.onUpdateInProgress();
            }
        });
        this.listPartsRequest.setClientTraceId(this.clientTraceId);
        this.listAllPartsAsync(cosXmlService, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, final CosXmlResult result) {
                if (request != COSXMLUploadTask.this.listPartsRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (COSXMLUploadTask.this.url != null) {
                    COSXMLUploadTask.this.updateSlicePart((ListPartsResult)result);
                    COSXMLUploadTask.this.multiUploadsStateListenerHandler.onListParts();
                } else {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean verifySuccess;
                            InputStream uploadFileStream = null;
                            try {
                                uploadFileStream = COSXMLUploadTask.this.openUploadFileStream();
                                verifySuccess = COSXMLUploadTask.this.verifyUploadParts(((ListPartsResult)result).listParts, uploadFileStream);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                verifySuccess = false;
                            }
                            finally {
                                if (uploadFileStream != null) {
                                    try {
                                        CloseUtil.closeQuietly((Closeable)uploadFileStream);
                                    }
                                    catch (CosXmlClientException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (verifySuccess) {
                                COSXMLUploadTask.this.updateSlicePart((ListPartsResult)result);
                                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onListParts();
                            } else {
                                COSXMLUploadTask.this.reTrans();
                            }
                        }
                    });
                }
            }

            public void onFail(final CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.listPartsRequest) {
                    return;
                }
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (serviceException != null && "NoSuchUpload".equals(serviceException.getErrorCode())) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            HeadObjectResult headObjectResult = COSXMLUploadTask.this.headObjectToCheckCRC64();
                            if (headObjectResult != null) {
                                COSXMLUploadTask.this.onTransferComplete(request, headObjectResult);
                            } else if (!COSXMLUploadTask.this.IS_EXIT.get()) {
                                COSXMLUploadTask.this.reTrans();
                            }
                        }
                    });
                } else {
                    COSXMLUploadTask.this.IS_EXIT.set(true);
                    COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, clientException, serviceException);
                }
            }
        });
    }

    private void onUpdateInProgress() {
        this.updateState(TransferState.IN_PROGRESS, null, null, false);
        if (this.waitTimeoutTimer != null) {
            this.waitTimeoutTimer.cancel();
        }
    }

    private InputStream openUploadFileStream() throws IOException {
        if (this.srcPath != null) {
            return new FileInputStream(this.srcPath);
        }
        if (this.uri != null) {
            if (ContextHolder.getAppContext() == null) {
                throw new IOException("Open src file failed, Application context is null!");
            }
            return ContextHolder.getAppContext().getContentResolver().openInputStream(this.uri);
        }
        throw new IOException("There is no src file path or uri!");
    }

    private boolean verifyUploadParts(ListParts listParts, InputStream inputStream) throws IOException {
        List<ListParts.Part> parts = listParts.parts;
        Collections.sort(parts, new Comparator<ListParts.Part>(){

            @Override
            public int compare(ListParts.Part a, ListParts.Part b) {
                int bNumb;
                int aNumb = Integer.valueOf(a.partNumber);
                if (aNumb > (bNumb = Integer.valueOf(b.partNumber).intValue())) {
                    return 1;
                }
                if (aNumb < bNumb) {
                    return -1;
                }
                return 0;
            }
        });
        boolean isFixSliceSize = this.isFixSliceSize(parts);
        boolean isContinuousSlice = true;
        int lastPartNumber = 0;
        for (ListParts.Part part : parts) {
            int partNumber = Integer.parseInt(part.partNumber);
            boolean bl = isContinuousSlice = isContinuousSlice && lastPartNumber + 1 == partNumber;
            if (!isFixSliceSize && !isContinuousSlice) {
                return true;
            }
            String localMd5 = DigestUtils.getCOSMd5((InputStream)inputStream, (long)((long)(partNumber - lastPartNumber - 1) * this.sliceSize), (long)Long.parseLong(part.size));
            if (!part.eTag.equals(localMd5)) {
                QCloudLogger.i((String)"UploadTask", (String)("verify upload parts failed, part number " + part.partNumber + ", etag " + part.eTag + ", but local md5 is " + localMd5), (Object[])new Object[0]);
                return false;
            }
            lastPartNumber = partNumber;
        }
        return true;
    }

    @Nullable
    private HeadObjectResult headObjectToCheckCRC64() {
        try {
            this.headObjectRequest = new HeadObjectRequest(this.bucket, this.cosPath);
            this.headObjectRequest.setCredentialProvider(this.credentialProvider);
            this.headObjectRequest.setClientTraceId(this.clientTraceId);
            HeadObjectResult headObjectResult = this.cosXmlService.headObject(this.headObjectRequest);
            String crcValue = this.getCRCValue(headObjectResult);
            long remoteCrc64 = DigestUtils.getBigIntFromString((String)crcValue);
            InputStream inputStream = this.openUploadFileStream();
            long localCrc64 = DigestUtils.getCRC64((InputStream)inputStream);
            inputStream.close();
            if (remoteCrc64 == localCrc64) {
                return headObjectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private String getCRCValue(HeadObjectResult headObjectResult) {
        List crc64Values = (List)headObjectResult.headers.get("x-cos-hash-crc64ecma");
        if (crc64Values != null && crc64Values.size() == 1) {
            return (String)crc64Values.get(0);
        }
        return null;
    }

    private void multiUploadPart(CosXmlSimpleService cosXmlService) {
        boolean isUploadFinished = true;
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = entry.getValue();
            if (slicePartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isUploadFinished = false;
            UploadPartRequest uploadPartRequest = null;
            if (this.srcPath != null) {
                uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.srcPath, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            }
            if (this.uri != null) {
                uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.uri, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            }
            if (this.url != null) {
                uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.url, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            }
            if (this.priorityLow) {
                uploadPartRequest.setPriorityLow();
            }
            uploadPartRequest.setRegion(this.region);
            if (this.url == null) {
                uploadPartRequest.setNeedMD5(this.isNeedMd5);
            } else {
                uploadPartRequest.setNeedMD5(false);
            }
            uploadPartRequest.setRequestHeaders(this.headers);
            uploadPartRequest.addNoSignHeader(this.noSignHeaders);
            uploadPartRequest.setCredentialProvider(this.credentialProvider);
            uploadPartRequest.setOnRequestWeightListener(new CosXmlRequest.OnRequestWeightListener(){

                public int onWeight() {
                    return COSXMLUploadTask.this.weightStrategy.getWeight(COSXMLUploadTask.this.ALREADY_SEND_DATA_LEN.get());
                }
            });
            if (this.onSignatureListener != null) {
                uploadPartRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)uploadPartRequest));
            }
            this.getHttpMetrics((CosXmlRequest)uploadPartRequest, "UploadPartRequest");
            this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
            final UploadPartRequest finalUploadPartRequest = uploadPartRequest;
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    try {
                        long dataLen = COSXMLUploadTask.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)COSXMLUploadTask.this.uploadPartRequestLongMap.get(finalUploadPartRequest));
                        COSXMLUploadTask.this.uploadPartRequestLongMap.put(finalUploadPartRequest, complete);
                        COSXMLUploadTask.this.dispatchProgressChange(dataLen, COSXMLUploadTask.this.fileLength);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            uploadPartRequest.setClientTraceId(this.clientTraceId);
            final UploadPartRequest finalUploadPartRequest1 = uploadPartRequest;
            cosXmlService.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    if (request != finalUploadPartRequest1) {
                        return;
                    }
                    COSXMLUploadTask.this.httpTaskMetrics.merge(request.getMetrics());
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    Object object = COSXMLUploadTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        COSXMLUploadTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (COSXMLUploadTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            COSXMLUploadTask.this.multiUploadsStateListenerHandler.onUploadParts();
                        }
                    }
                }

                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (request != finalUploadPartRequest1) {
                        return;
                    }
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    COSXMLUploadTask.this.IS_EXIT.set(true);
                    COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
                }
            });
        }
        if (isUploadFinished && !this.IS_EXIT.get()) {
            this.dispatchProgressChange(this.fileLength, this.fileLength);
            this.multiUploadsStateListenerHandler.onUploadParts();
        }
    }

    private void completeMultiUpload(CosXmlSimpleService cosXmlService) {
        this.sendingCompleteRequest.set(true);
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        this.completeMultiUploadRequest.setRegion(this.region);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        this.completeMultiUploadRequest.setNeedMD5(this.isNeedMd5);
        this.completeMultiUploadRequest.setRequestHeaders(this.getCustomCompleteHeaders(this.headers));
        this.completeMultiUploadRequest.addNoSignHeader(this.noSignHeaders);
        this.completeMultiUploadRequest.setCredentialProvider(this.credentialProvider);
        if (this.onSignatureListener != null) {
            this.completeMultiUploadRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.completeMultiUploadRequest));
        }
        this.completeMultiUploadRequest.setClientTraceId(this.clientTraceId);
        this.getHttpMetrics((CosXmlRequest)this.completeMultiUploadRequest, "CompleteMultiUploadRequest");
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLUploadTask.this.completeMultiUploadRequest) {
                    return;
                }
                COSXMLUploadTask.this.sendingCompleteRequest.set(false);
                COSXMLUploadTask.this.onTransferComplete(request, result);
            }

            public void onFail(final CosXmlRequest request, final CosXmlClientException clientException, final CosXmlServiceException serviceException) {
                if (request != COSXMLUploadTask.this.completeMultiUploadRequest) {
                    return;
                }
                if (serviceException != null && "NoSuchUpload".equals(serviceException.getErrorCode())) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            HeadObjectResult headObjectResult = COSXMLUploadTask.this.headObjectToCheckCRC64();
                            if (headObjectResult != null) {
                                COSXMLUploadTask.this.onTransferComplete(request, headObjectResult);
                            } else {
                                COSXMLUploadTask.this.encounterError(request, clientException, serviceException);
                            }
                            COSXMLUploadTask.this.sendingCompleteRequest.set(false);
                        }
                    });
                } else {
                    COSXMLUploadTask.this.encounterError(request, clientException, serviceException);
                    COSXMLUploadTask.this.sendingCompleteRequest.set(false);
                }
            }
        });
    }

    private void onTransferComplete(CosXmlRequest request, CosXmlResult result) {
        request.attachMetrics(this.httpTaskMetrics);
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        CosTrackService.getInstance().reportUploadTaskSuccess(request);
        this.multiUploadsStateListenerHandler.onCompleted(request, result);
    }

    @Override
    protected void internalCompleted() {
        this.clear();
    }

    @Override
    protected void internalFailed() {
        this.cancelAllRequest(this.cosXmlService, false);
    }

    @Override
    protected void internalPause(boolean now) {
        CosXmlRequest request = this.buildCOSXMLTaskRequest();
        request.attachMetrics(this.httpTaskMetrics);
        CosTrackService.getInstance().reportUploadTaskSuccess(request);
        this.cancelAllRequest(this.cosXmlService, now);
    }

    public boolean pauseSafely() {
        if (this.sendingCompleteRequest.get()) {
            return false;
        }
        this.pause();
        return true;
    }

    public boolean pauseSafely(boolean now) {
        if (this.sendingCompleteRequest.get()) {
            return false;
        }
        this.pause(now);
        return true;
    }

    @Override
    protected void internalCancel(boolean now) {
        this.cancelAllRequest(this.cosXmlService, now);
        if (this.isSliceUpload) {
            this.abortMultiUpload(this.cosXmlService);
        }
        this.clear();
    }

    @Override
    protected void internalResume() {
        this.taskState = TransferState.WAITING;
        this.IS_EXIT.set(false);
        if (this.inputStream != null) {
            this.IS_EXIT.set(true);
            this.multiUploadsStateListenerHandler.onFailed(this.buildCOSXMLTaskRequest(), new CosXmlClientException(ClientErrorCode.SINK_SOURCE_NOT_FOUND.getCode(), "inputStream closed"), null);
            return;
        }
        this.upload();
    }

    @Override
    protected void encounterError(@Nullable CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        this.multiUploadsStateListenerHandler.onFailed(request != null ? request : this.buildCOSXMLTaskRequest(), clientException, serviceException);
    }

    void cancelAllRequest(CosXmlSimpleService cosXmlService, boolean now) {
        CompleteMultiUploadRequest tempCompleteMultiUploadRequest;
        ListPartsRequest tempListPartsRequest;
        InitMultipartUploadRequest tempInitMultipartUploadRequest;
        PutObjectRequest tempPutObjectRequest;
        HeadObjectRequest tempHeadObjectRequest = this.headObjectRequest;
        if (tempHeadObjectRequest != null) {
            cosXmlService.cancel((CosXmlRequest)tempHeadObjectRequest, now);
        }
        if ((tempPutObjectRequest = this.putObjectRequest) != null) {
            cosXmlService.cancel((CosXmlRequest)tempPutObjectRequest, now);
        }
        if ((tempInitMultipartUploadRequest = this.initMultipartUploadRequest) != null) {
            cosXmlService.cancel((CosXmlRequest)tempInitMultipartUploadRequest, now);
        }
        if ((tempListPartsRequest = this.listPartsRequest) != null) {
            cosXmlService.cancel((CosXmlRequest)tempListPartsRequest, now);
        }
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                cosXmlService.cancel((CosXmlRequest)iterator.next(), now);
            }
        }
        if ((tempCompleteMultiUploadRequest = this.completeMultiUploadRequest) != null) {
            cosXmlService.cancel((CosXmlRequest)tempCompleteMultiUploadRequest, now);
        }
    }

    private void abortMultiUpload(CosXmlSimpleService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        abortMultiUploadRequest.setRegion(this.region);
        abortMultiUploadRequest.setCredentialProvider(this.credentialProvider);
        if (this.onSignatureListener != null) {
            abortMultiUploadRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)abortMultiUploadRequest));
        }
        abortMultiUploadRequest.setClientTraceId(this.clientTraceId);
        this.getHttpMetrics((CosXmlRequest)abortMultiUploadRequest, "AbortMultiUploadRequest");
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    private void clear() {
        if (this.uploadPartRequestLongMap != null) {
            this.uploadPartRequestLongMap.clear();
        }
        if (this.partStructMap != null) {
            this.partStructMap.clear();
        }
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest() {
        COSXMLUploadTaskRequest cosxmlUploadTaskRequest = new COSXMLUploadTaskRequest(this.region, this.bucket, this.cosPath, this.srcPath, this.headers, this.queries);
        return cosxmlUploadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLUploadTaskResult cosxmlUploadTaskResult = new COSXMLUploadTaskResult();
        if (sourceResult != null) {
            cosxmlUploadTaskResult.httpCode = sourceResult.httpCode;
            cosxmlUploadTaskResult.httpMessage = sourceResult.httpMessage;
            cosxmlUploadTaskResult.headers = sourceResult.headers;
            cosxmlUploadTaskResult.accessUrl = sourceResult.accessUrl;
        }
        if (sourceResult instanceof PutObjectResult) {
            PutObjectResult putObjectResult = (PutObjectResult)sourceResult;
            cosxmlUploadTaskResult.eTag = putObjectResult.eTag;
            cosxmlUploadTaskResult.picUploadResult = putObjectResult.picUploadResult();
            cosxmlUploadTaskResult.callbackResult = putObjectResult.callbackResult;
        } else if (sourceResult instanceof CompleteMultiUploadResult) {
            CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)sourceResult;
            if (completeMultiUploadResult.completeMultipartUpload != null) {
                cosxmlUploadTaskResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
                PicUploadResult picUploadResult = new PicUploadResult();
                picUploadResult.originalInfo = completeMultiUploadResult.completeMultipartUpload.getOriginInfo();
                picUploadResult.processResults = completeMultiUploadResult.completeMultipartUpload.processResults;
                cosxmlUploadTaskResult.picUploadResult = picUploadResult;
                cosxmlUploadTaskResult.callbackResult = completeMultiUploadResult.completeMultipartUpload.callbackResult;
            }
        } else if (sourceResult instanceof HeadObjectResult) {
            HeadObjectResult headObjectResult = (HeadObjectResult)sourceResult;
            cosxmlUploadTaskResult.eTag = headObjectResult.eTag;
        }
        return cosxmlUploadTaskResult;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    private void initSlicePart(long fileOffset, long uploadSize, int startNumber) {
        int count = (int)(uploadSize / this.sliceSize);
        for (int numberOffset = 0; numberOffset < count; ++numberOffset) {
            SlicePartStruct slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = startNumber + numberOffset;
            slicePartStruct.offset = fileOffset + (long)numberOffset * this.sliceSize;
            slicePartStruct.sliceSize = this.sliceSize;
            this.partStructMap.put(slicePartStruct.partNumber, slicePartStruct);
        }
        if (uploadSize % this.sliceSize != 0L) {
            SlicePartStruct slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = startNumber + count;
            slicePartStruct.offset = fileOffset + (long)count * this.sliceSize;
            slicePartStruct.sliceSize = fileOffset + uploadSize - slicePartStruct.offset;
            this.partStructMap.put(slicePartStruct.partNumber, slicePartStruct);
            ++count;
        }
        this.UPLOAD_PART_COUNT.set(startNumber + count - 1);
        if (this.IS_EXIT.get()) {
            return;
        }
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        block6: {
            List<ListParts.Part> parts;
            if (listPartsResult == null || listPartsResult.listParts == null || (parts = listPartsResult.listParts.parts) == null || parts.size() <= 0) break block6;
            if (this.isFixSliceSize(parts)) {
                for (ListParts.Part part : parts) {
                    if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                    SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                    slicePartStruct.isAlreadyUpload = true;
                    slicePartStruct.eTag = part.eTag;
                    this.UPLOAD_PART_COUNT.decrementAndGet();
                    this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
                }
            } else {
                int i;
                Collections.sort(parts, new Comparator<ListParts.Part>(){

                    @Override
                    public int compare(ListParts.Part a, ListParts.Part b) {
                        int bNumb;
                        int aNumb = Integer.valueOf(a.partNumber);
                        if (aNumb > (bNumb = Integer.valueOf(b.partNumber).intValue())) {
                            return 1;
                        }
                        if (aNumb < bNumb) {
                            return -1;
                        }
                        return 0;
                    }
                });
                int index = this.getIndexOfParts(parts);
                if (index < 0) {
                    return;
                }
                this.partStructMap.clear();
                long completed = 0L;
                for (i = 0; i <= index; ++i) {
                    ListParts.Part part = parts.get(i);
                    SlicePartStruct slicePartStruct = new SlicePartStruct();
                    slicePartStruct.partNumber = i + 1;
                    slicePartStruct.offset = completed;
                    slicePartStruct.sliceSize = Long.parseLong(part.size);
                    slicePartStruct.eTag = part.eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    completed += slicePartStruct.sliceSize;
                    this.partStructMap.put(i + 1, slicePartStruct);
                }
                this.ALREADY_SEND_DATA_LEN.addAndGet(completed);
                this.initSlicePart(completed, this.fileLength - completed, index + 2);
                for (i = 0; i <= index; ++i) {
                    this.UPLOAD_PART_COUNT.decrementAndGet();
                }
            }
        }
    }

    private boolean isFixSliceSize(List<ListParts.Part> parts) {
        boolean isTrue = true;
        for (ListParts.Part part : parts) {
            if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
            SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
            if (slicePartStruct.sliceSize == Long.valueOf(part.size)) continue;
            isTrue = false;
            break;
        }
        return isTrue;
    }

    private int getIndexOfParts(List<ListParts.Part> parts) {
        int index = -1;
        int currentPartNumber = 1;
        ListParts.Part firstPart = parts.get(0);
        if (Integer.valueOf(firstPart.partNumber) != 1) {
            return index;
        }
        index = 0;
        int i = 1;
        int size = parts.size();
        while (i < size) {
            ListParts.Part tmp = parts.get(i);
            if (Integer.valueOf(tmp.partNumber) != currentPartNumber + 1) break;
            index = i++;
            currentPartNumber = Integer.valueOf(tmp.partNumber);
        }
        return index;
    }

    protected void startUpload() {
        if (this.bytes != null || this.inputStream != null) {
            this.simpleUpload(this.cosXmlService);
            return;
        }
        if (this.fileLength < this.multiUploadSizeDivision || this.forceSimpleUpload) {
            this.simpleUpload(this.cosXmlService);
        } else {
            long defaultPartSize = this.sliceSize;
            double partCount = Math.ceil((double)this.fileLength / (double)defaultPartSize);
            this.sliceSize = partCount > 10000.0 ? (long)Math.ceil((double)this.fileLength / 10000.0) : defaultPartSize;
            this.isSliceUpload = true;
            this.UPLOAD_PART_COUNT = new AtomicInteger(0);
            this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
            this.partStructMap = new LinkedHashMap<Integer, SlicePartStruct>();
            this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
            this.multiUpload(this.cosXmlService);
        }
    }

    private void reTrans() {
        this.uploadId = null;
        this.startUpload();
    }

    public boolean getSendingCompleteRequest() {
        return this.sendingCompleteRequest.get();
    }

    private Map<String, List<String>> getCustomCompleteHeaders(@Nullable Map<String, List<String>> customHeaders) {
        if (customHeaders == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(customHeaders);
        headers.remove("Content-Type");
        return headers;
    }

    public static class COSXMLUploadTaskResult
    extends CosXmlResult {
        public String eTag;
        public PicUploadResult picUploadResult;
        public CallbackResult callbackResult;

        protected COSXMLUploadTaskResult() {
        }
    }

    public static class COSXMLUploadTaskRequest
    extends PutObjectRequest {
        protected COSXMLUploadTaskRequest(String region, String bucket, String cosPath, String srcPath, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, srcPath);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }

    private static interface MultiUploadsStateListener {
        public void onInit();

        public void onListParts();

        public void onUploadParts();

        public void onCompleted(CosXmlRequest var1, CosXmlResult var2);

        public void onFailed(CosXmlRequest var1, CosXmlClientException var2, CosXmlServiceException var3);
    }

    private static class WeightStrategy {
        private final long DEFAULT_WEIGHT_NORMAL_SIZE = 0x5000000L;
        private final long DEFAULT_WEIGHT_HIGH_SIZE = 0x9600000L;
        private long normalSize = 0x5000000L;
        private long highSize = 0x9600000L;

        private WeightStrategy() {
        }

        private int getWeight(long size) {
            if (size > this.highSize) {
                return 2;
            }
            if (size > this.normalSize) {
                return 1;
            }
            return 0;
        }
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }
}

