/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.beacon.core.info.BeaconPubParams;
import com.tencent.beacon.event.open.BeaconReport;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.BasePutObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.transfer.TransferTaskMetrics;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.ConnectionRepository;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.track.TrackService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;

public class BeaconService {
    private static final String TAG = "BeaconProxy";
    private static final String APP_KEY = "0AND0VEVB24UBGDU";
    private static final boolean IS_DEBUG = false;
    private static final String EVENT_CODE_BASE_SERVICE = "base_service";
    private static final String EVENT_CODE_DOWNLOAD = "cos_download";
    private static final String EVENT_CODE_UPLOAD = "cos_upload";
    private static final String EVENT_CODE_COPY = "cos_copy";
    private static final String EVENT_CODE_ERROR = "cos_error";
    private static final String EVENT_PARAMS_SUCCESS = "Success";
    private static final String EVENT_PARAMS_FAILURE = "Failure";
    private static final String EVENT_PARAMS_SERVER = "Server";
    private static final String EVENT_PARAMS_CLIENT = "Client";
    public static final String EVENT_PARAMS_NODE_HEAD = "HeadObjectRequest";
    public static final String EVENT_PARAMS_NODE_GET = "GetObjectRequest";
    private Context applicationContext;
    private CosXmlServiceConfig config;
    private static BeaconService instance;

    private BeaconService(Context applicationContext, CosXmlServiceConfig config) {
        this.applicationContext = applicationContext;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext, CosXmlServiceConfig serviceConfig) {
        Class<BeaconService> clazz = BeaconService.class;
        synchronized (BeaconService.class) {
            if (instance == null) {
                instance = new BeaconService(applicationContext, serviceConfig);
                TrackService.init((Context)applicationContext, (String)APP_KEY, (boolean)false);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static BeaconService getInstance() {
        return instance;
    }

    public void reportRequestSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(this.parseEventCode(request), request, null);
    }

    public CosXmlClientException reportRequestClientException(CosXmlRequest request, QCloudClientException clientException) {
        return this.reportClientException(this.parseEventCode(request), request, clientException, null);
    }

    public CosXmlServiceException reportRequestServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        return this.reportServiceException(this.parseEventCode(request), request, serviceException, null);
    }

    public void reportUploadTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(EVENT_CODE_UPLOAD, request, Collections.singletonMap("name", "UploadTask"));
    }

    public void reportUploadTaskClientException(CosXmlRequest request, QCloudClientException clientException) {
        this.reportClientException(EVENT_CODE_UPLOAD, request, clientException, this.createTransferExtra("UploadTask", request));
    }

    public void reportUploadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        this.reportServiceException(EVENT_CODE_UPLOAD, request, serviceException, this.createTransferExtra("UploadTask", request));
    }

    public void reportDownloadTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(EVENT_CODE_DOWNLOAD, request, Collections.singletonMap("name", "DownloadTask"));
    }

    public void reportDownloadTaskClientException(CosXmlRequest request, QCloudClientException clientException) {
        this.reportClientException(EVENT_CODE_DOWNLOAD, request, clientException, this.createTransferExtra("DownloadTask", request));
    }

    public void reportDownloadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        this.reportServiceException(EVENT_CODE_DOWNLOAD, request, serviceException, this.createTransferExtra("DownloadTask", request));
    }

    private String cosUploadName(boolean cse) {
        return cse ? "COSUploadTask-CSE" : "COSUploadTask";
    }

    private String cosDownloadName(boolean cse) {
        return cse ? "COSDownloadTask-CSE" : "COSDownloadTask";
    }

    public void reportCOSUploadTaskSuccess(CosXmlRequest request, boolean cse) {
        this.reportRequestSuccess(EVENT_CODE_UPLOAD, request, Collections.singletonMap("name", this.cosUploadName(cse)));
    }

    public void reportCOSUploadTaskClientException(CosXmlRequest request, QCloudClientException clientException, boolean cse) {
        this.reportClientException(EVENT_CODE_UPLOAD, request, clientException, this.createTransferExtra(this.cosUploadName(cse), request));
    }

    public void reportCOSUploadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException, boolean cse) {
        this.reportServiceException(EVENT_CODE_UPLOAD, request, serviceException, this.createTransferExtra(this.cosUploadName(cse), request));
    }

    public void reportCOSDownloadTaskSuccess(CosXmlRequest request, boolean cse) {
        this.reportRequestSuccess(EVENT_CODE_DOWNLOAD, request, Collections.singletonMap("name", this.cosDownloadName(cse)));
    }

    public void reportCOSDownloadTaskClientException(CosXmlRequest request, QCloudClientException clientException, boolean cse) {
        this.reportClientException(EVENT_CODE_DOWNLOAD, request, clientException, this.createTransferExtra(this.cosDownloadName(cse), request));
    }

    public void reportCOSDownloadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException, boolean cse) {
        this.reportServiceException(EVENT_CODE_DOWNLOAD, request, serviceException, this.createTransferExtra(this.cosDownloadName(cse), request));
    }

    public void reportCopyTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(EVENT_CODE_COPY, request, Collections.singletonMap("name", "CopyTask"));
    }

    public void reportCopyTaskClientException(CosXmlRequest request, CosXmlClientException clientException) {
        this.reportClientException(EVENT_CODE_COPY, request, clientException, this.createTransferExtra("CopyTask", request));
    }

    public void reportCopyTaskServiceException(CosXmlRequest request, CosXmlServiceException serviceException) {
        this.reportServiceException(EVENT_CODE_COPY, request, serviceException, this.createTransferExtra("CopyTask", request));
    }

    private Map<String, String> createTransferExtra(String name, CosXmlRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("error_node", request != null ? request.getClass().getSimpleName() : "null");
        return params;
    }

    public void reportTransferSuccess(CosXmlRequest request, TransferTaskMetrics taskMetrics, boolean encrypted) {
        if (this.isReport(request)) {
            this.reportTransferTask(request, taskMetrics, encrypted, true, null);
        }
    }

    public void reportTransferClientException(CosXmlRequest request, TransferTaskMetrics taskMetrics, CosXmlClientException clientException, boolean encrypted) {
        if (this.isReport(clientException) && this.isReport(request)) {
            this.reportTransferTask(request, taskMetrics, encrypted, false, this.parseClientExceptionParams(clientException));
        }
    }

    public void reportTransferServiceException(CosXmlRequest request, TransferTaskMetrics taskMetrics, CosXmlServiceException serviceException, boolean encrypted) {
        if (this.isReport(serviceException) && this.isReport(request)) {
            this.reportTransferTask(request, taskMetrics, encrypted, false, this.parseServiceExceptionParams(serviceException));
        }
    }

    private void reportTransferTask(CosXmlRequest request, TransferTaskMetrics taskMetrics, boolean encrypted, boolean isSuccess, @Nullable Map<String, String> extras) {
        Map<String, String> params = this.parseUrlParams(request);
        params.put("name", request.getClass().getSimpleName());
        params.putAll(this.getCommonParams());
        params.putAll(this.parseSimplePerfParams(taskMetrics));
        params.put("encrypted", String.valueOf(encrypted));
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        if (extras != null) {
            params.putAll(extras);
        }
        this.report("cos_transfer", params);
    }

    private void reportRequestSuccess(String eventCode, CosXmlRequest request, @Nullable Map<String, String> extra) {
        if (this.isReport(request)) {
            HttpTaskMetrics taskMetrics = request.getMetrics();
            Map<String, String> params = this.parseUrlParams(request);
            params.putAll(this.getCommonParams());
            params.putAll(this.parseSimplePerfParams(taskMetrics));
            if (extra == null || !extra.containsKey("name")) {
                params.put("name", request.getClass().getSimpleName());
            }
            params.put("result", EVENT_PARAMS_SUCCESS);
            if (extra != null) {
                params.putAll(extra);
            }
            this.report(eventCode, params);
        }
    }

    private CosXmlClientException reportClientException(String eventCode, CosXmlRequest request, QCloudClientException clientException, @Nullable Map<String, String> extra) {
        ReturnClientException returnClientException = this.getClientExceptionParams(clientException);
        if (this.isReport(returnClientException.exception) && this.isReport(request)) {
            HttpTaskMetrics taskMetrics = request.getMetrics();
            Map<String, String> params = this.parseUrlParams(request);
            params.putAll(this.getCommonParams());
            params.putAll(returnClientException.params);
            params.putAll(this.parsePerfParams(taskMetrics));
            params.putAll(this.parseDnsParams(request));
            if (extra == null || !extra.containsKey("name")) {
                params.put("name", request.getClass().getSimpleName());
            }
            params.put("result", EVENT_PARAMS_FAILURE);
            if (extra != null) {
                params.putAll(extra);
            }
            this.report(eventCode, params);
        }
        return returnClientException.exception;
    }

    private CosXmlServiceException reportServiceException(String eventCode, CosXmlRequest request, QCloudServiceException serviceException, @Nullable Map<String, String> extra) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(serviceException);
        if (request instanceof ObjectRequest) {
            String string = ((ObjectRequest)request).getCosPath();
        }
        if (this.isReport(returnServiceException.exception) && this.isReport(request)) {
            Map<String, String> params = this.parseUrlParams(request);
            params.putAll(this.getCommonParams());
            params.putAll(returnServiceException.params);
            params.putAll(this.parsePerfParams(request.getMetrics()));
            params.putAll(this.parseDnsParams(request));
            if (extra == null || !extra.containsKey("name")) {
                params.put("name", request.getClass().getSimpleName());
            }
            params.put("result", EVENT_PARAMS_FAILURE);
            if (extra != null) {
                params.putAll(extra);
            }
            this.report(eventCode, params);
        }
        return returnServiceException.exception;
    }

    private Map<String, String> parseDnsParams(CosXmlRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        String host = this.parseHost(request);
        if (TextUtils.isEmpty((CharSequence)host)) {
            return params;
        }
        HttpTaskMetrics taskMetrics = request.getMetrics();
        List dns = null;
        try {
            dns = ConnectionRepository.getInstance().getDnsRecord(host);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        params.put("ips", this.flatDns(taskMetrics.getConnectAddress(), dns));
        return params;
    }

    private String flatDns(@Nullable InetAddress connect, @Nullable List<InetAddress> dns) {
        if (connect != null && connect.getHostAddress() != null) {
            return String.format("{%s}", connect.getHostAddress());
        }
        return this.flatInetAddressList(dns);
    }

    @Nullable
    private String parseHost(CosXmlRequest request) {
        HttpRequest httpRequest;
        HttpTask httpTask = request.getHttpTask();
        String host = null;
        if (httpTask != null && (httpRequest = httpTask.request()) != null) {
            host = httpRequest.host();
        }
        if (host == null && request.getMetrics() != null) {
            host = request.getMetrics().getDomainName();
        }
        return host;
    }

    private Map<String, String> parsePerfParams(@Nullable HttpTaskMetrics taskMetrics) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskMetrics == null) {
            return params;
        }
        params.put("took_time", String.valueOf(taskMetrics.httpTaskFullTime()));
        params.put("http_dns", String.valueOf(taskMetrics.dnsLookupTookTime()));
        params.put("http_connect", String.valueOf(taskMetrics.connectTookTime()));
        params.put("http_secure_connect", String.valueOf(taskMetrics.secureConnectTookTime()));
        params.put("http_md5", String.valueOf(taskMetrics.calculateMD5STookTime()));
        params.put("http_sign", String.valueOf(taskMetrics.signRequestTookTime()));
        params.put("http_read_header", String.valueOf(taskMetrics.readResponseHeaderTookTime()));
        params.put("http_read_body", String.valueOf(taskMetrics.readResponseBodyTookTime()));
        params.put("http_write_header", String.valueOf(taskMetrics.writeRequestHeaderTookTime()));
        params.put("http_write_body", String.valueOf(taskMetrics.writeRequestBodyTookTime()));
        params.put("http_full", String.valueOf(taskMetrics.fullTaskTookTime()));
        params.put("size", String.valueOf(taskMetrics.requestBodyByteCount() + taskMetrics.responseBodyByteCount()));
        return params;
    }

    private Map<String, String> parseSimplePerfParams(@Nullable HttpTaskMetrics taskMetrics) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskMetrics == null) {
            return params;
        }
        params.put("took_time", String.valueOf(taskMetrics.httpTaskFullTime()));
        params.put("size", String.valueOf(taskMetrics.requestBodyByteCount() + taskMetrics.responseBodyByteCount()));
        return params;
    }

    private Map<String, String> parseSimplePerfParams(@Nullable TransferTaskMetrics taskMetrics) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskMetrics == null) {
            return params;
        }
        params.put("transfer_size", String.valueOf(taskMetrics.getSize()));
        params.put("ip", taskMetrics.getConnectAddress() != null ? taskMetrics.getConnectAddress().getHostAddress() : "");
        params.put("took_time", String.valueOf(taskMetrics.getTookTime()));
        params.put("wait_took_time", String.valueOf(taskMetrics.getWaitTookTime()));
        params.put("first_progress_took_time", String.valueOf(taskMetrics.getFirstProgressTookTime()));
        return params;
    }

    private Map<String, String> parseUrlParams(CosXmlRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        String host = this.parseHost(request);
        if (TextUtils.isEmpty((CharSequence)host)) {
            return params;
        }
        params.put("host", host);
        try {
            Pattern pattern = Pattern.compile(".*\\.cos\\.(.*)\\.myqcloud.com");
            Matcher matcher = pattern.matcher(host);
            if (matcher.find()) {
                params.put("region", matcher.group(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (request instanceof ObjectRequest && !TextUtils.isEmpty((CharSequence)((ObjectRequest)request).getCosPath())) {
            params.put("request_path", ((ObjectRequest)request).getCosPath());
        }
        return params;
    }

    private BasePutObjectRequest emptyPutObjectRequestWithMetrics(HttpTaskMetrics taskMetrics) {
        BasePutObjectRequest putObjectRequest = new BasePutObjectRequest("", "", "");
        putObjectRequest.attachMetrics(taskMetrics);
        return putObjectRequest;
    }

    private GetObjectRequest emptyGetObjectRequestWithMetrics(HttpTaskMetrics taskMetrics) {
        GetObjectRequest getObjectRequest = new GetObjectRequest("", "", "");
        getObjectRequest.attachMetrics(taskMetrics);
        return getObjectRequest;
    }

    private String parseEventCode(CosXmlRequest request) {
        String eventCode = EVENT_CODE_BASE_SERVICE;
        if (this.isUploadTaskRequest(request)) {
            eventCode = EVENT_CODE_UPLOAD;
        } else if (this.isDownloadTaskRequest(request)) {
            eventCode = EVENT_CODE_DOWNLOAD;
        }
        return eventCode;
    }

    private void report(String eventCode, Map<String, String> params) {
        if (!BeaconService.isIncludeBeacon()) {
            return;
        }
        TrackService.getInstance().track(APP_KEY, eventCode, params);
    }

    public void reportError(String source, Exception e) {
        Map<String, String> params = this.getCommonParams();
        params.put("source", source);
        params.put("name", e.getClass().getSimpleName());
        params.put("message", e.getMessage());
        this.report(EVENT_CODE_ERROR, params);
    }

    private static boolean isIncludeBeacon() {
        try {
            Class.forName("com.tencent.beacon.event.open.BeaconReport");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Map<String, String> getBaseServiceParams(CosXmlRequest cosXmlRequest, long tookTime, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("took_time", String.valueOf(tookTime));
        params.put("name", cosXmlRequest.getClass().getSimpleName());
        params.put("region", TextUtils.isEmpty((CharSequence)cosXmlRequest.getRegion()) ? this.config.getRegion() : cosXmlRequest.getRegion());
        params.put("accelerate", cosXmlRequest.isSupportAccelerate() ? "Y" : "N");
        if (!isSuccess) {
            String host;
            HttpTaskMetrics metrics = cosXmlRequest.getMetrics();
            if (metrics != null) {
                params.put("http_dns", String.valueOf(metrics.dnsLookupTookTime()));
                params.put("http_connect", String.valueOf(metrics.connectTookTime()));
                params.put("http_secure_connect", String.valueOf(metrics.secureConnectTookTime()));
                params.put("http_md5", String.valueOf(metrics.calculateMD5STookTime()));
                params.put("http_sign", String.valueOf(metrics.signRequestTookTime()));
                params.put("http_read_header", String.valueOf(metrics.readResponseHeaderTookTime()));
                params.put("http_read_body", String.valueOf(metrics.readResponseBodyTookTime()));
                params.put("http_write_header", String.valueOf(metrics.writeRequestHeaderTookTime()));
                params.put("http_write_body", String.valueOf(metrics.writeRequestBodyTookTime()));
                params.put("http_full", String.valueOf(metrics.fullTaskTookTime()));
            }
            if ((host = cosXmlRequest.getRequestHost(this.config)) != null) {
                params.put("host", host);
                try {
                    List ips = ConnectionRepository.getInstance().getDnsRecord(host);
                    params.put("ips", this.flatInetAddressList(ips));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    private String flatInetAddressList(@Nullable List<InetAddress> ips) {
        if (ips == null) {
            return "{}";
        }
        StringBuilder ipString = new StringBuilder("{");
        int count = 0;
        for (InetAddress ip : ips) {
            boolean isLast;
            ipString.append(ip.getHostAddress());
            boolean bl = isLast = ++count == ips.size();
            if (isLast) {
                ipString.append("}");
                continue;
            }
            ipString.append(",");
        }
        return ipString.toString();
    }

    private String getConnectIp(@Nullable InetSocketAddress socketAddress) {
        if (socketAddress == null || socketAddress.getAddress() == null) {
            return "";
        }
        return socketAddress.getAddress().getHostAddress();
    }

    private Map<String, String> getDownloadParams(String region, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("region", region);
        return params;
    }

    private Map<String, String> getUploadParams(String region, boolean isSuccess) {
        Map<String, String> params = this.getCommonParams();
        params.put("result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
        params.put("region", region);
        return params;
    }

    private Map<String, String> getCommonParams() {
        if (!BeaconService.isIncludeBeacon()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        BeaconPubParams pubParams = BeaconReport.getInstance().getCommonParams(this.applicationContext);
        params.put("boundle_id", pubParams.getBoundleId());
        params.put("network_type", pubParams.getNetworkType());
        params.put("cossdk_version", "5.9.0");
        params.put("cossdk_version_code", String.valueOf(50900));
        return params;
    }

    private ReturnServiceException getServiceExceptionParams(QCloudServiceException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlServiceException serviceException = this.convertServerException(e);
        params.put("error_request_id", serviceException.getRequestId());
        params.put("error_message", serviceException.getErrorMessage());
        params.put("error_code", serviceException.getErrorCode());
        params.put("error_status_code", String.valueOf(serviceException.getStatusCode()));
        params.put("error_service_name", serviceException.getServiceName());
        params.put("error_type", EVENT_PARAMS_SERVER);
        return new ReturnServiceException(serviceException, params);
    }

    private Map<String, String> parseClientExceptionParams(CosXmlClientException clientException) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error_message", clientException.getMessage());
        params.put("error_code", String.valueOf(clientException.errorCode));
        params.put("error_type", EVENT_PARAMS_CLIENT);
        return params;
    }

    private Map<String, String> parseServiceExceptionParams(CosXmlServiceException serviceException) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error_message", serviceException.getErrorMessage());
        params.put("error_code", serviceException.getErrorCode());
        params.put("request_id", serviceException.getRequestId());
        params.put("error_type", EVENT_PARAMS_SERVER);
        return params;
    }

    private ReturnClientException getClientExceptionParams(QCloudClientException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlClientException xmlClientException = this.convertClientException(e);
        String name = xmlClientException.getCause() == null ? ((Object)((Object)xmlClientException)).getClass().getSimpleName() : xmlClientException.getCause().getClass().getSimpleName();
        String message = xmlClientException.getCause() == null ? xmlClientException.getMessage() : xmlClientException.getCause().getMessage();
        params.put("error_name", name);
        params.put("error_message", message);
        params.put("error_code", String.valueOf(xmlClientException.errorCode));
        params.put("error_type", EVENT_PARAMS_CLIENT);
        return new ReturnClientException(xmlClientException, params);
    }

    private CosXmlServiceException convertServerException(QCloudServiceException e) {
        return e instanceof CosXmlServiceException ? (CosXmlServiceException)e : new CosXmlServiceException(e);
    }

    private CosXmlClientException convertClientException(QCloudClientException e) {
        CosXmlClientException xmlClientException;
        if (!TextUtils.isEmpty((CharSequence)e.getMessage()) && e.getMessage().contains("NetworkNotConnected")) {
            return new CosXmlClientException(ClientErrorCode.NETWORK_NOT_CONNECTED.getCode(), (Throwable)e);
        }
        if (e instanceof CosXmlClientException) {
            xmlClientException = (CosXmlClientException)e;
            if (e.getCause() instanceof IOException) {
                xmlClientException = new CosXmlClientException(this.subdivisionIOException(e.getCause()), (Throwable)e);
            }
        } else {
            Throwable causeException = e.getCause();
            xmlClientException = causeException instanceof IllegalArgumentException ? new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), (Throwable)e) : (causeException instanceof QCloudAuthenticationException ? new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), (Throwable)e) : (causeException instanceof IOException ? new CosXmlClientException(this.subdivisionIOException(causeException), (Throwable)e) : new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), (Throwable)e)));
        }
        return xmlClientException;
    }

    private int subdivisionIOException(Throwable causeException) {
        if (causeException instanceof FileNotFoundException) {
            return ClientErrorCode.SINK_SOURCE_NOT_FOUND.getCode();
        }
        if (causeException instanceof UnknownHostException) {
            return 200032;
        }
        if (causeException instanceof SocketTimeoutException) {
            return 200033;
        }
        if (causeException instanceof ConnectException) {
            return 200034;
        }
        if (causeException instanceof HttpRetryException) {
            return 200035;
        }
        if (causeException instanceof NoRouteToHostException) {
            return 200036;
        }
        if (causeException instanceof SSLHandshakeException && !(causeException.getCause() instanceof CertificateException)) {
            return 200037;
        }
        return ClientErrorCode.IO_ERROR.getCode();
    }

    private boolean isReport(CosXmlRequest cosXmlRequest) {
        return true;
    }

    private boolean isDownloadTaskRequest(CosXmlRequest cosXmlRequest) {
        String requestName = cosXmlRequest.getClass().getSimpleName();
        return EVENT_PARAMS_NODE_HEAD.equals(requestName) || EVENT_PARAMS_NODE_GET.equals(requestName);
    }

    private boolean isUploadTaskRequest(CosXmlRequest cosXmlRequest) {
        String requestName = cosXmlRequest.getClass().getSimpleName();
        return "PutObjectRequest".equals(requestName) || "InitMultipartUploadRequest".equals(requestName) || "ListPartsRequest".equals(requestName) || "UploadPartRequest".equals(requestName) || "CompleteMultiUploadRequest".equals(requestName) || "AbortMultiUploadRequest".equals(requestName);
    }

    private boolean isCopyTaskRequest(CosXmlRequest cosXmlRequest) {
        String requestName = cosXmlRequest.getClass().getSimpleName();
        return "UploadPartCopyRequest".equals(requestName) || "CopyObjectRequest".equals(requestName);
    }

    private boolean isReport(CosXmlServiceException e) {
        return true;
    }

    private boolean isReport(CosXmlClientException e) {
        boolean notReport = e.getMessage() != null && e.getMessage().toLowerCase(Locale.ROOT).contains("canceled");
        return !notReport;
    }

    private static class PoorNetworkCode {
        private static final int UnknownHostException = 200032;
        private static final int SocketTimeoutException = 200033;
        private static final int ConnectException = 200034;
        private static final int HttpRetryException = 200035;
        private static final int NoRouteToHostException = 200036;
        private static final int SSLHandshakeException = 200037;

        private PoorNetworkCode() {
        }
    }

    private static class ReturnClientException {
        private final CosXmlClientException exception;
        private final Map<String, String> params;

        public ReturnClientException(CosXmlClientException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }

    private static class ReturnServiceException {
        private final CosXmlServiceException exception;
        private final Map<String, String> params;

        public ReturnServiceException(CosXmlServiceException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }
}

