/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.Range;
import com.tencent.cos.xml.crypto.CipherLite;
import com.tencent.cos.xml.crypto.CipherLiteInputStream;
import com.tencent.cos.xml.crypto.ContentCryptoMaterial;
import com.tencent.cos.xml.crypto.CryptoModuleBase;
import com.tencent.cos.xml.crypto.EncryptionMaterialsProvider;
import com.tencent.cos.xml.crypto.MultipartUploadCryptoContext;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.crypto.QCLOUDKMS;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.utils.FileUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.json.JSONException;

public class CryptoModuleAE
extends CryptoModuleBase {
    public CryptoModuleAE(CosXmlSimpleService cos, QCloudCredentialProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider) {
        this(null, cos, credentialsProvider, kekMaterialsProvider);
    }

    public CryptoModuleAE(QCLOUDKMS kms, CosXmlSimpleService cos, QCloudCredentialProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider) {
        super(kms, cos, credentialsProvider, kekMaterialsProvider);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public GetObjectResult getObjectSecurely(GetObjectRequest req) throws CosXmlClientException, CosXmlServiceException {
        GetObjectResult getObjectResult = this.cos.getObject(req);
        ObjectMetadata metadata = new ObjectMetadata(getObjectResult.headers);
        Range range = req.getRange();
        try {
            long[] lArray;
            if (range == null) {
                lArray = null;
            } else {
                long[] lArray2 = new long[2];
                lArray2[0] = range.getStart();
                lArray = lArray2;
                lArray2[1] = range.getEnd();
            }
            ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(metadata, this.kekMaterialsProvider, null, lArray, false, this.kms);
            CipherLite cipherLite = cekMaterial.getCipherLite();
            CipherLiteInputStream inputStream = new CipherLiteInputStream(new FileInputStream(req.getDownloadPath()), cipherLite);
            String encryptedFilePath = req.getDownloadPath();
            String decryptedFilePath = encryptedFilePath + ".decrypt";
            File decryptedFile = new File(decryptedFilePath);
            FileUtils.saveInputStreamToTmpFile(inputStream, decryptedFile, 0L, -1L);
            FileUtils.deleteFileIfExist(encryptedFilePath);
            if (!decryptedFile.renameTo(new File(encryptedFilePath))) {
                throw CosXmlClientException.internalException("decrypt file failed.");
            }
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            throw CosXmlClientException.internalException(e.getMessage());
        }
        return getObjectResult;
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitMultipartUploadRequest req, ContentCryptoMaterial cekMaterial) {
        return new MultipartUploadCryptoContext(req.getBucket(), req.getCosPath(), cekMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext uploadContext) {
        return uploadContext.getCipherLite();
    }

    @Override
    final long computeLastPartSize(UploadPartRequest req) {
        return req.getFileLength() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected final long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }
}

