/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.crypto.QCLOUDKMS;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.qcloud.core.auth.BasicQCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.kms.v20190118.KmsClient;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;
import java.util.Locale;

public class TencentCloudKMSClient
implements QCLOUDKMS {
    private final KmsClient kmsClient;
    private QCloudCredentialProvider credentialProvider;

    public TencentCloudKMSClient(String region, QCloudCredentialProvider credentialProvider) {
        this.kmsClient = new KmsClient(null, region);
        this.credentialProvider = credentialProvider;
    }

    public void assetCredentials() throws CosXmlClientException {
        Credential kmsCredential = null;
        QCloudCredentials credentials = null;
        try {
            credentials = this.credentialProvider.getCredentials();
            if (credentials instanceof SessionQCloudCredentials) {
                SessionQCloudCredentials sessionQCloudCredentials = (SessionQCloudCredentials)credentials;
                String secretId = sessionQCloudCredentials.getSecretId();
                String secretKey = sessionQCloudCredentials.getSecretKey();
                String token = sessionQCloudCredentials.getToken();
                kmsCredential = new Credential(secretId, secretKey, token);
            } else if (credentials instanceof BasicQCloudCredentials) {
                BasicQCloudCredentials basicQCloudCredentials = (BasicQCloudCredentials)credentials;
                String secretId = basicQCloudCredentials.getSecretId();
                String secretKey = basicQCloudCredentials.getSecretKey();
                kmsCredential = new Credential(secretId, secretKey);
            } else {
                throw CosXmlClientException.internalException("credentials is neither SessionQCloudCredentials nor BasicQCloudCredentials ");
            }
            this.kmsClient.setCredential(kmsCredential);
        }
        catch (QCloudClientException e) {
            throw CosXmlClientException.internalException(e.getMessage());
        }
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) throws CosXmlClientException {
        try {
            this.assetCredentials();
            GenerateDataKeyResponse generateDataKeyRes = this.kmsClient.GenerateDataKey(generateDataKeyRequest);
            return generateDataKeyRes;
        }
        catch (TencentCloudSDKException e) {
            throw this.getClientException(e, "TencentCloudKMS Service got exception while GenerateDataKey");
        }
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) throws CosXmlClientException {
        try {
            this.assetCredentials();
            EncryptResponse encryptResponse = this.kmsClient.Encrypt(encryptRequest);
            return encryptResponse;
        }
        catch (TencentCloudSDKException e) {
            throw this.getClientException(e, "TencentCloudKMS Service got exception while Encrypt");
        }
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) throws CosXmlClientException {
        try {
            this.assetCredentials();
            DecryptResponse decryptResponse = this.kmsClient.Decrypt(decryptRequest);
            return decryptResponse;
        }
        catch (TencentCloudSDKException e) {
            throw this.getClientException(e, "TencentCloudKMS Service got exception while Decrypt");
        }
    }

    private CosXmlClientException getClientException(TencentCloudSDKException e, String errorMessage) {
        String errorCode = e.getErrorCode();
        String requestId = e.getRequestId();
        String message = String.format(Locale.ENGLISH, "%s: %s, error code: %s, requestId: %s", errorMessage, e.getMessage(), errorCode, requestId);
        return new CosXmlClientException(ClientErrorCode.KMS_ERROR.getCode(), message);
    }

    @Override
    public void shutdown() {
    }
}

