/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import android.util.Xml;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.ListMultipartUploads;
import com.tencent.qcloud.core.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ListMultiUploadsResult
extends CosXmlResult {
    public ListMultipartUploads listMultipartUploads;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        this.listMultipartUploads = new ListMultipartUploads();
        try {
            ListMultiUploadsResult.parseListMultipartUploadsResult(response.byteStream(), this.listMultipartUploads);
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
        }
    }

    @Override
    public String printResult() {
        if (this.listMultipartUploads != null) {
            return this.listMultipartUploads.toString();
        }
        return super.printResult();
    }

    public static void parseListMultipartUploadsResult(InputStream inputStream, ListMultipartUploads result) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput(inputStream, "UTF-8");
        int eventType = xmlPullParser.getEventType();
        ListMultipartUploads.CommonPrefixes commonPrefixes = null;
        ListMultipartUploads.Upload upload = null;
        result.uploads = new ArrayList<ListMultipartUploads.Upload>();
        result.commonPrefixes = new ArrayList<ListMultipartUploads.CommonPrefixes>();
        ListMultipartUploads.Initiator initiator = null;
        ListMultipartUploads.Owner owner = null;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String tagName = xmlPullParser.getName();
                    if (tagName.equalsIgnoreCase("Bucket")) {
                        xmlPullParser.next();
                        result.bucket = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Encoding-Type")) {
                        xmlPullParser.next();
                        result.encodingType = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("KeyMarker")) {
                        xmlPullParser.next();
                        result.keyMarker = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("UploadIdMarker")) {
                        xmlPullParser.next();
                        result.uploadIdMarker = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("NextKeyMarker")) {
                        xmlPullParser.next();
                        result.nextKeyMarker = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("NextUploadIdMarker")) {
                        xmlPullParser.next();
                        result.nextUploadIdMarker = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("MaxUploads")) {
                        xmlPullParser.next();
                        result.maxUploads = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("IsTruncated")) {
                        xmlPullParser.next();
                        result.isTruncated = Boolean.parseBoolean(xmlPullParser.getText());
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Prefix")) {
                        xmlPullParser.next();
                        if (commonPrefixes == null) {
                            result.prefix = xmlPullParser.getText();
                            break;
                        }
                        commonPrefixes.prefix = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Delimiter")) {
                        xmlPullParser.next();
                        result.delimiter = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Upload")) {
                        upload = new ListMultipartUploads.Upload();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Key")) {
                        xmlPullParser.next();
                        upload.key = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("UploadId")) {
                        xmlPullParser.next();
                        upload.uploadID = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("StorageClass")) {
                        xmlPullParser.next();
                        upload.storageClass = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Initiator")) {
                        initiator = new ListMultipartUploads.Initiator();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("UIN")) {
                        xmlPullParser.next();
                        if (initiator == null) break;
                        initiator.uin = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Owner")) {
                        owner = new ListMultipartUploads.Owner();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("UID")) {
                        xmlPullParser.next();
                        if (owner == null) break;
                        owner.uid = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("ID")) {
                        xmlPullParser.next();
                        if (owner != null) {
                            owner.id = xmlPullParser.getText();
                            break;
                        }
                        if (initiator == null) break;
                        initiator.id = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("DisplayName")) {
                        xmlPullParser.next();
                        if (owner != null) {
                            owner.displayName = xmlPullParser.getText();
                            break;
                        }
                        if (initiator == null) break;
                        initiator.displayName = xmlPullParser.getText();
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Initiated")) {
                        xmlPullParser.next();
                        upload.initiated = xmlPullParser.getText();
                        break;
                    }
                    if (!tagName.equalsIgnoreCase("CommonPrefixs")) break;
                    commonPrefixes = new ListMultipartUploads.CommonPrefixes();
                    break;
                }
                case 3: {
                    String tagName = xmlPullParser.getName();
                    if (tagName.equalsIgnoreCase("Upload")) {
                        result.uploads.add(upload);
                        upload = null;
                        break;
                    }
                    if (tagName.equalsIgnoreCase("CommonPrefixs")) {
                        result.commonPrefixes.add(commonPrefixes);
                        commonPrefixes = null;
                        break;
                    }
                    if (tagName.equalsIgnoreCase("Owner")) {
                        upload.owner = owner;
                        owner = null;
                        break;
                    }
                    if (!tagName.equalsIgnoreCase("Initiator")) break;
                    upload.initiator = initiator;
                    initiator = null;
                }
            }
            eventType = xmlPullParser.next();
        }
    }
}

