/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.GetObjectRequest;

public class GetSnapshotRequest
extends GetObjectRequest {
    private float time;

    public GetSnapshotRequest(String bucket, String cosPath, String savePath, String fileName, float time) {
        super(bucket, cosPath, savePath, fileName);
        this.time = time;
        this.queryParameters.put("ci-process", "snapshot");
        this.queryParameters.put("time", String.valueOf(time));
    }

    public void setWidth(int width) {
        if (width <= 0) {
            return;
        }
        this.queryParameters.put("width", String.valueOf(width));
    }

    public void setHeight(int height) {
        if (height <= 0) {
            return;
        }
        this.queryParameters.put("height", String.valueOf(height));
    }

    public void setFormat(String format) {
        this.queryParameters.put("format", format);
    }

    public void setRotate(String rotate) {
        this.queryParameters.put("rotate", rotate);
    }

    public void setMode(String mode) {
        this.queryParameters.put("mode", mode);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.time < 0.0f) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Please set a valid time");
        }
    }

    @Override
    public String getMethod() {
        return "GET";
    }
}

