/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.StringUtils;

public class PreviewDocumentInHtmlRequest
extends GetObjectRequest {
    public PreviewDocumentInHtmlRequest(String bucket, String cosPath, String savePath) {
        this(bucket, cosPath, savePath, StringUtils.extractNameNoSuffix(cosPath));
    }

    public PreviewDocumentInHtmlRequest(String bucket, String cosPath, String savePath, String fileName) {
        super(bucket, cosPath, savePath, fileName);
        this.queryParameters.put("ci-process", "doc-preview");
        this.queryParameters.put("dstType", "html");
    }

    public PreviewDocumentInHtmlRequest setCopyable(boolean copyable) {
        this.queryParameters.put("copyable", copyable ? "1" : "0");
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermark(String watermark) {
        try {
            this.queryParameters.put("htmlwaterword", DigestUtils.getSecurityBase64(watermark));
        }
        catch (CosXmlClientException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkColor(String htmlfillstyle) {
        try {
            this.queryParameters.put("htmlfillstyle", DigestUtils.getSecurityBase64(htmlfillstyle));
        }
        catch (CosXmlClientException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkFont(String font) {
        try {
            this.queryParameters.put("htmlfront", DigestUtils.getSecurityBase64(font));
        }
        catch (CosXmlClientException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkRotate(int rotate) {
        this.queryParameters.put("htmlrotate", String.valueOf(rotate));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkHorizontal(int horizontal) {
        this.queryParameters.put("htmlhorizontal", String.valueOf(horizontal));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkVertical(int vertical) {
        this.queryParameters.put("htmlvertical", String.valueOf(vertical));
        return this;
    }

    @Override
    public String getMethod() {
        return "GET";
    }
}

