/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.HashSet;
import java.util.Set;

public class SensitiveContentRecognitionRequest
extends BucketRequest {
    private String cosPath;
    private String detectUrl;
    private int interval;
    private int maxFrames;
    private final Set<String> types = new HashSet<String>();
    private String bizType;
    private boolean largeImageDetect;

    public SensitiveContentRecognitionRequest(String bucket) {
        super(bucket);
    }

    public SensitiveContentRecognitionRequest(String bucket, String cosPath) {
        super(bucket);
        this.setCosPath(cosPath);
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public void setDetectUrl(String detectUrl) {
        this.detectUrl = detectUrl;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setMaxFrames(int maxFrames) {
        this.maxFrames = maxFrames;
    }

    public void setLargeImageDetect(boolean largeImageDetect) {
        this.largeImageDetect = largeImageDetect;
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        return null;
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        return config.getUrlPath(this.bucket, this.cosPath == null ? "" : this.cosPath);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.bucket == null || this.bucket.length() < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket must not be null ");
        }
        if (!(this.cosPath != null && this.cosPath.length() >= 1 || this.detectUrl != null && this.detectUrl.length() >= 1)) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosPath or detectUrl must not be null ");
        }
        this.addCiParams();
    }

    private void addCiParams() {
        if (this.types.isEmpty()) {
            this.types.add("porn");
        }
        StringBuilder typeStr = new StringBuilder();
        int count = 0;
        for (String type : this.types) {
            typeStr.append(type);
            if (++count >= this.types.size()) continue;
            typeStr.append(",");
        }
        this.queryParameters.put("ci-process", "sensitive-content-recognition");
        if (!TextUtils.isEmpty((CharSequence)this.bizType)) {
            this.queryParameters.put("biz-type", this.bizType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.detectUrl)) {
            this.queryParameters.put("detect-url", this.detectUrl);
        }
        if (this.interval > 0) {
            this.queryParameters.put("interval", String.valueOf(this.interval));
        }
        if (this.maxFrames > 0) {
            this.queryParameters.put("max-frames", String.valueOf(this.maxFrames));
        }
        this.queryParameters.put("large-image-detect", this.largeImageDetect ? "1" : "0");
        this.queryParameters.put("detect-type", typeStr.toString());
    }
}

