/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.BasePutObjectRequest;
import com.tencent.cos.xml.model.object.TransferRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.cos.xml.model.tag.pic.PicOperations;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class PutObjectRequest
extends BasePutObjectRequest
implements TransferRequest {
    private ObjectMetadata metadata;

    protected PutObjectRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public PutObjectRequest(String bucket, String cosPath, String srcPath) {
        super(bucket, cosPath, srcPath);
    }

    public PutObjectRequest(String bucket, String cosPath, Uri uri) {
        super(bucket, cosPath, uri);
    }

    public PutObjectRequest(String bucket, String cosPath, byte[] data) {
        super(bucket, cosPath, data);
    }

    public PutObjectRequest(String bucket, String cosPath, StringBuilder stringBuilder) {
        super(bucket, cosPath, stringBuilder);
    }

    public PutObjectRequest(String bucket, String cosPath, InputStream inputStream) {
        super(bucket, cosPath, inputStream);
    }

    public PutObjectRequest(String bucket, String cosPath, URL url) {
        super(bucket, cosPath, url);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.metadata != null) {
            Map<String, Object> rawMetadata = this.metadata.getRawMetadata();
            Map<String, String> useMetadata = this.metadata.getUserMetadata();
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                this.addHeader(entry.getKey(), entry.getValue().toString());
            }
            for (Map.Entry<String, Object> entry : useMetadata.entrySet()) {
                this.addHeader(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.addHeader("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.addHeader("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncoding) {
        if (contentEncoding == null) {
            return;
        }
        this.addHeader("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.addHeader("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setStroageClass(COSStorageClass stroageClass) {
        this.addHeader("x-cos-storage-class", stroageClass.getStorageClass());
    }

    public void setPicOperations(@NonNull PicOperations operations) {
        this.addHeader("Pic-Operations", operations.toJsonStr());
    }
}

