/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import com.tencent.cos.xml.CosXmlBaseService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.BaseMultipartUploadRequest;
import com.tencent.cos.xml.model.object.TransferRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public final class UploadPartRequest
extends BaseMultipartUploadRequest
implements TransferRequest {
    private int partNumber;
    private String uploadId;
    private Uri uri;
    private String srcPath;
    private URL url;
    private byte[] data;
    private InputStream inputStream;
    private long fileOffset = -1L;
    private long fileContentLength = -1L;
    private CosXmlProgressListener progressListener;
    private boolean lastPart;

    private UploadPartRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
        this.setNeedMD5(true);
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, String srcPath, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.srcPath = srcPath;
        this.uploadId = uploadId;
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, Uri uri, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.uri = uri;
        this.uploadId = uploadId;
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, String srcPath, long offset, long length, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.setSrcPath(srcPath, offset, length);
        this.uploadId = uploadId;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, Uri uri, long offset, long length, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.uri = uri;
        this.fileOffset = offset;
        this.fileContentLength = length;
        this.uploadId = uploadId;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, byte[] data, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.data = data;
        this.uploadId = uploadId;
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, InputStream inputStream, String uploadId) throws CosXmlClientException {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.inputStream = inputStream;
        this.uploadId = uploadId;
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, InputStream inputStream, long size, String uploadId) throws CosXmlClientException {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.inputStream = inputStream;
        this.uploadId = uploadId;
        this.fileOffset = 0L;
        this.fileContentLength = size;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, URL url, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.url = url;
        this.uploadId = uploadId;
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
        this.setNeedMD5(false);
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, URL url, long offset, long length, String uploadId) {
        this(bucket, cosPath);
        this.partNumber = partNumber;
        this.url = url;
        this.fileOffset = offset;
        this.fileContentLength = length;
        this.uploadId = uploadId;
        this.setNeedMD5(false);
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getFileContentLength() {
        return this.fileContentLength;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public void setFileContentLength(long fileContentLength) {
        this.fileContentLength = fileContentLength;
    }

    public boolean isLastPart() {
        return this.lastPart;
    }

    public void setLastPart(boolean lastPart) {
        this.lastPart = lastPart;
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("partNumber", String.valueOf(this.partNumber));
        this.queryParameters.put("uploadId", this.uploadId);
        return super.getQueryString();
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        if (this.srcPath != null) {
            if (this.fileOffset != -1L) {
                return RequestBodySerializer.file((String)this.getContentType(), (File)new File(this.srcPath), (long)this.fileOffset, (long)this.fileContentLength);
            }
            return RequestBodySerializer.file((String)this.getContentType(), (File)new File(this.srcPath));
        }
        if (this.data != null) {
            return RequestBodySerializer.bytes((String)this.getContentType(), (byte[])this.data);
        }
        if (this.inputStream != null) {
            return RequestBodySerializer.stream((String)this.getContentType(), (File)new File(CosXmlBaseService.appCachePath, String.valueOf(System.currentTimeMillis())), (InputStream)this.inputStream);
        }
        if (this.uri != null && ContextHolder.getAppContext() != null) {
            return RequestBodySerializer.uri((String)this.getContentType(), (Uri)this.uri, (Context)ContextHolder.getAppContext(), (long)this.fileOffset, (long)this.fileContentLength);
        }
        if (this.url != null) {
            if (this.fileOffset != -1L) {
                return RequestBodySerializer.url((String)this.getContentType(), (URL)this.url, (long)this.fileOffset, (long)this.fileContentLength);
            }
            return RequestBodySerializer.url((String)this.getContentType(), (URL)this.url);
        }
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        Context appContext;
        File file;
        super.checkParameters();
        if (this.requestURL == null) {
            if (this.partNumber <= 0) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "partNumber must be >= 1");
            }
            if (this.uploadId == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "uploadID must not be null");
            }
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null && this.uri == null && this.url == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "upload file does not exist");
        }
        if (this.uri != null && (appContext = ContextHolder.getAppContext()) != null && !QCloudUtils.doesUriFileExist((Uri)this.uri, (ContentResolver)appContext.getContentResolver())) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "upload file does not exist");
        }
    }

    public void setPriorityLow() {
        this.priority = 1;
    }

    public boolean isPriorityLow() {
        return this.priority == 1;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setSrcPath(String srcPath, long fileOffset, long contentLength) {
        this.srcPath = srcPath;
        this.fileOffset = fileOffset;
        this.fileContentLength = contentLength;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFileLength() {
        if (this.data != null) {
            this.fileContentLength = this.data.length;
        } else if (this.srcPath != null && this.fileContentLength == -1L) {
            this.fileContentLength = new File(this.srcPath).length();
        }
        return this.fileContentLength;
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public void setTrafficLimit(long limit) {
        this.addHeader("x-cos-traffic-limit", String.valueOf(limit));
    }
}

