/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.net.Uri;
import android.text.TextUtils;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.transfer.COSUploadTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class BaseUploadPartsTask {
    protected COSDirect mCosDirect;
    protected long mOffset;
    protected long mSize;
    protected int mStartNumber;
    protected String mUploadId;
    protected PutObjectRequest mPutObjectRequest;
    protected Set<COSUploadTask.UploadPart> uploadParts = Collections.synchronizedSet(new HashSet());
    private CosXmlProgressListener progressListener;
    protected String taskId;
    protected long mMaxPartSize = 0x100000L;
    protected final String TAG = "QCloudUpload";

    BaseUploadPartsTask(COSDirect cosDirect, PutObjectRequest putObjectRequest, long offset, long size, int startPartNumber, String uploadId) {
        this.mCosDirect = cosDirect;
        this.mPutObjectRequest = putObjectRequest;
        this.mOffset = offset;
        this.mSize = size;
        this.mStartNumber = startPartNumber;
        this.mUploadId = uploadId;
    }

    public abstract Set<COSUploadTask.UploadPart> upload() throws Exception;

    public abstract void cancel();

    UploadPartRequest getUploadRequest(int partNumber, long offset, long size) {
        if (offset >= this.mOffset + this.mSize) {
            return null;
        }
        String filePath = this.mPutObjectRequest.getSrcPath();
        Uri uri = this.mPutObjectRequest.getUri();
        String bucket = this.mPutObjectRequest.getBucket();
        String key = this.mPutObjectRequest.getCosPath();
        String region = this.mPutObjectRequest.getRegion();
        CosXmlRequest uploadPartRequest = null;
        if (filePath != null) {
            uploadPartRequest = new UploadPartRequest(bucket, key, partNumber, filePath, offset, size, this.mUploadId);
        } else if (uri != null) {
            uploadPartRequest = new UploadPartRequest(bucket, key, partNumber, uri, offset, size, this.mUploadId);
        }
        if (uploadPartRequest != null) {
            if (!TextUtils.isEmpty((CharSequence)region)) {
                uploadPartRequest.setRegion(region);
            }
            uploadPartRequest.setRequestHeaders(this.getUploadPartHeaders(this.mPutObjectRequest));
            ((UploadPartRequest)uploadPartRequest).setLastPart(offset + size >= this.mOffset + this.mSize);
        }
        return uploadPartRequest;
    }

    private Map<String, List<String>> getUploadPartHeaders(PutObjectRequest putObjectRequest) {
        Map<String, List<String>> customHeaders = putObjectRequest.getRequestHeaders();
        if (customHeaders == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (String header : customHeaders.keySet()) {
            if (!header.startsWith("x-cos-server-side-encryption") && !header.equals("x-cos-traffic-limit")) continue;
            headers.put(header, customHeaders.get(header));
        }
        return headers;
    }

    void notifyProgressChange(long complete, long size) {
        if (this.progressListener != null) {
            this.progressListener.onProgress(complete, size);
        }
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

