/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.text.TextUtils;
import android.util.SparseArray;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.BaseUploadPartsTask;
import com.tencent.cos.xml.transfer.COSTransferTask;
import com.tencent.cos.xml.transfer.COSUploadTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class ParallelUploadPartsTask
extends BaseUploadPartsTask {
    private final Set<UploadPartRequest> runningRequestSet = Collections.synchronizedSet(new HashSet());
    private TaskCompletionSource<Set<COSUploadTask.UploadPart>> tcs = new TaskCompletionSource();
    private SparseArray<Long> uploadPartProgress = new SparseArray();
    private AtomicLong mTotalProgress = new AtomicLong(0L);

    ParallelUploadPartsTask(COSDirect cosDirect, PutObjectRequest putObjectRequest, long offset, long size, int startPartNumber, String uploadId) {
        super(cosDirect, putObjectRequest, offset, size, startPartNumber, uploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<COSUploadTask.UploadPart> upload() throws Exception {
        Task task = this.tcs.getTask();
        final int partCount = this.calculatePartNumber(this.mSize, this.mMaxPartSize);
        final AtomicInteger completeCounter = new AtomicInteger(0);
        for (int i = 0; i < partCount; ++i) {
            final int partNumber = this.mStartNumber + i;
            final long startPointer = this.mOffset + (long)i * this.mMaxPartSize;
            final long partSize = Math.min(this.mMaxPartSize, this.mOffset + this.mSize - startPointer);
            final UploadPartRequest uploadPartRequest = this.getUploadRequest(partNumber, startPointer, partSize);
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    ParallelUploadPartsTask.this.updateProgress(uploadPartRequest, complete);
                }
            });
            Set<UploadPartRequest> set = this.runningRequestSet;
            synchronized (set) {
                this.runningRequestSet.add(uploadPartRequest);
            }
            this.mCosDirect.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    Set set = ParallelUploadPartsTask.this.runningRequestSet;
                    synchronized (set) {
                        ParallelUploadPartsTask.this.runningRequestSet.remove(uploadPartRequest);
                    }
                    UploadPartResult uploadPartResult = (UploadPartResult)result;
                    String eTag = uploadPartResult.eTag;
                    COSTransferTask.loggerInfo("QCloudUpload", ParallelUploadPartsTask.this.taskId, "upload part %d, etag=%s", partNumber, eTag);
                    if (TextUtils.isEmpty((CharSequence)eTag)) {
                        ParallelUploadPartsTask.this.tcs.trySetError((Exception)((Object)new CosXmlClientException(ClientErrorCode.ETAG_NOT_FOUND)));
                        ParallelUploadPartsTask.this.cancelAllUploadingRequests();
                        return;
                    }
                    ParallelUploadPartsTask.this.uploadParts.add(new COSUploadTask.UploadPart(uploadPartResult.eTag, partNumber, startPointer, partSize));
                    if (completeCounter.addAndGet(1) >= partCount) {
                        ParallelUploadPartsTask.this.tcs.trySetResult((Object)ParallelUploadPartsTask.this.uploadParts);
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                    if (clientException != null) {
                        ParallelUploadPartsTask.this.tcs.trySetError((Exception)((Object)clientException));
                    } else if (serviceException != null) {
                        ParallelUploadPartsTask.this.tcs.trySetError((Exception)((Object)serviceException));
                    } else {
                        ParallelUploadPartsTask.this.tcs.trySetError((Exception)((Object)new CosXmlClientException(ClientErrorCode.UNKNOWN)));
                    }
                    ParallelUploadPartsTask.this.cancelAllUploadingRequests();
                }
            });
        }
        task.waitForCompletion();
        if (task.isFaulted()) {
            throw task.getError();
        }
        if (task.isCancelled()) {
            throw new CosXmlClientException(ClientErrorCode.USER_CANCELLED);
        }
        return (Set)task.getResult();
    }

    private synchronized void updateProgress(UploadPartRequest request, long progress) {
        int partNumber = request.getPartNumber();
        long lastComplete = (Long)this.uploadPartProgress.get(partNumber, (Object)0L);
        long delta = progress - lastComplete;
        this.uploadPartProgress.put(partNumber, (Object)progress);
        this.notifyProgressChange(this.mOffset + this.mTotalProgress.addAndGet(delta), this.mOffset + this.mSize);
    }

    private int calculatePartNumber(long size, long maxPartSize) {
        int number = (int)(size / maxPartSize);
        if (size % maxPartSize != 0L) {
            ++number;
        }
        return number;
    }

    @Override
    public void cancel() {
        this.tcs.trySetCancelled();
        this.cancelAllUploadingRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllUploadingRequests() {
        Set<UploadPartRequest> set = this.runningRequestSet;
        synchronized (set) {
            for (UploadPartRequest request : this.runningRequestSet) {
                this.mCosDirect.cancel(request);
            }
        }
    }
}

