/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import bolts.CancellationToken;
import bolts.CancellationTokenSource;
import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.COSUploadTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.task.TaskExecutors;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class ParallelUploadTask {
    private List<UploadPartRequest> mRequests;
    private List<UploadPartTask> mUploadPartTasks;
    private Task<?> mTask;
    private TaskCompletionSource<?> mTaskCompletionSource;
    private CancellationTokenSource mCancellationTokenSource;
    private CosXmlSimpleService mCosXmlSimpleService;
    private final Object mCheckingLock = new Object();
    private CosXmlProgressListener mProgressListener;
    private Map<UploadPartRequest, Long> mUploadCompleteMap;
    private long mTotalComplete = 0L;
    private long mOffset;
    private long mSize;
    private long mOffsetPointer;
    private long mNormalNetworkSliceSize = 0x100000L;
    private long mPoolNetworkSliceSize = 0x100000L;
    private PutObjectRequest mPutObjectRequest;
    private volatile boolean isPoolNetwork = true;
    private final long normalNetworkSpeed = 102400L;
    private final int mPartNumber;
    private final String mUploadId;
    private SlidingWindow slidingWindow;
    private Set<COSUploadTask.UploadPart> uploadParts = Collections.synchronizedSet(new HashSet());
    private volatile HttpTaskMetrics httpTaskMetrics;
    private String taskId;

    public ParallelUploadTask(CosXmlSimpleService cosXmlSimpleService, PutObjectRequest putObjectRequest, long offset, long size, int startPartNumber, String uploadId) {
        this.mPartNumber = startPartNumber;
        this.mUploadId = uploadId;
        this.mOffset = offset;
        this.mSize = size;
        this.slidingWindow = new SlidingWindow(startPartNumber, 3);
        this.mOffsetPointer = this.mOffset;
        this.mPutObjectRequest = putObjectRequest;
        this.mTaskCompletionSource = new TaskCompletionSource();
        this.mTask = this.mTaskCompletionSource.getTask();
        this.mCosXmlSimpleService = cosXmlSimpleService;
        this.mCancellationTokenSource = new CancellationTokenSource();
        this.mUploadPartTasks = new LinkedList<UploadPartTask>();
        this.mUploadCompleteMap = new HashMap<UploadPartRequest, Long>();
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.mProgressListener = progressListener;
    }

    public Set<COSUploadTask.UploadPart> waitForComplete() throws CosXmlClientException, CosXmlServiceException {
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger progress = new AtomicInteger(0);
        final AtomicBoolean sendComplete = new AtomicBoolean(false);
        while (!this.mTask.isCompleted()) {
            final int nextNumber = this.slidingWindow.getNextNumber();
            final UploadPartRequest uploadPartRequest = this.nextUploadPartRequest(nextNumber);
            if (uploadPartRequest == null) {
                sendComplete.set(true);
                break;
            }
            uploadPartRequest.attachMetrics(new HttpTaskMetrics());
            count.addAndGet(1);
            UploadPartTask uploadPartTask = new UploadPartTask(this.mCosXmlSimpleService, uploadPartRequest, this.mCancellationTokenSource.getToken());
            this.mUploadPartTasks.add(uploadPartTask);
            uploadPartTask.getTask().continueWith((Continuation)new Continuation<UploadPartResult, Void>(){

                public Void then(Task<UploadPartResult> task) throws Exception {
                    ParallelUploadTask.this.slidingWindow.complete(nextNumber);
                    if (task.isFaulted()) {
                        ParallelUploadTask.this.mTaskCompletionSource.trySetError(task.getError());
                    }
                    if (task.isCompleted()) {
                        UploadPartResult uploadPartResult = (UploadPartResult)task.getResult();
                        COSUploadTask.UploadPart uploadPart = new COSUploadTask.UploadPart(uploadPartResult.eTag, uploadPartRequest.getPartNumber(), uploadPartRequest.getFileOffset(), uploadPartRequest.getFileContentLength());
                        ParallelUploadTask.this.uploadParts.add(uploadPart);
                        ParallelUploadTask.this.mergeTaskMetrics(uploadPartRequest.getMetrics());
                    }
                    if (count.get() == progress.addAndGet(1) && sendComplete.get()) {
                        ParallelUploadTask.this.mTaskCompletionSource.trySetResult(null);
                    }
                    return null;
                }
            });
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    ParallelUploadTask.this.updatePartProgress(uploadPartRequest, complete);
                }
            });
            TaskExecutors.UPLOAD_EXECUTOR.execute(uploadPartTask);
        }
        try {
            this.mTask.waitForCompletion();
            if (this.mTask.isFaulted()) {
                this.checkoutException(this.mTask.getError());
                this.cancelAllUploadTask();
            } else if (this.mTask.isCancelled()) {
                throw CosXmlClientException.manualCancelException();
            }
        }
        catch (InterruptedException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), ClientErrorCode.INTERNAL_ERROR.getErrorMsg() + ": " + e.getMessage());
        }
        return this.uploadParts;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void cancel() {
        this.mCancellationTokenSource.cancel();
        this.mTaskCompletionSource.setCancelled();
        this.cancelAllUploadTask();
    }

    public void setHttpTaskMetrics(HttpTaskMetrics httpTaskMetrics) {
        this.httpTaskMetrics = httpTaskMetrics;
    }

    private synchronized void mergeTaskMetrics(HttpTaskMetrics httpTaskMetrics) {
        if (httpTaskMetrics != null && this.httpTaskMetrics != null) {
            this.httpTaskMetrics.merge(httpTaskMetrics);
        }
    }

    private synchronized void updatePartProgress(UploadPartRequest request, long progress) {
        long lastComplete = 0L;
        if (this.mUploadCompleteMap.containsKey(request)) {
            lastComplete = this.mUploadCompleteMap.get(request);
        }
        long delta = progress - lastComplete;
        this.mUploadCompleteMap.put(request, progress);
        this.mTotalComplete += delta;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgress(this.mTotalComplete + this.mOffset, -1L);
        }
    }

    @Nullable
    private UploadPartRequest nextUploadPartRequest(int partNumber) throws CosXmlClientException {
        if (this.mOffsetPointer >= this.mOffset + this.mSize) {
            return null;
        }
        long offset = this.mOffsetPointer;
        long sliceSize = this.isPoolNetwork ? this.mPoolNetworkSliceSize : this.mNormalNetworkSliceSize;
        sliceSize = Math.min(sliceSize, this.mOffset + this.mSize - this.mOffsetPointer);
        this.mOffsetPointer += sliceSize;
        String filePath = this.mPutObjectRequest.getSrcPath();
        Uri uri = this.mPutObjectRequest.getUri();
        String bucket = this.mPutObjectRequest.getBucket();
        String key = this.mPutObjectRequest.getCosPath();
        String region = this.mPutObjectRequest.getRegion();
        CosXmlRequest uploadPartRequest = null;
        if (filePath != null) {
            uploadPartRequest = new UploadPartRequest(bucket, key, partNumber, filePath, offset, sliceSize, this.mUploadId);
        } else if (uri != null) {
            uploadPartRequest = new UploadPartRequest(bucket, key, partNumber, uri, offset, sliceSize, this.mUploadId);
        }
        if (uploadPartRequest != null && !TextUtils.isEmpty((CharSequence)region)) {
            uploadPartRequest.setRegion(region);
        }
        return uploadPartRequest;
    }

    public void setNormalNetworkSliceSize(long normalNetworkSliceSize) {
        this.mNormalNetworkSliceSize = normalNetworkSliceSize;
    }

    public void setPoolNetworkSliceSize(long poolNetworkSliceSize) {
        this.mPoolNetworkSliceSize = poolNetworkSliceSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllUploadTask() {
        LinkedList<UploadPartTask> snapshot = new LinkedList<UploadPartTask>(this.mUploadPartTasks);
        Object object = this.mCheckingLock;
        synchronized (object) {
            for (UploadPartTask task : snapshot) {
                task.cancel();
            }
        }
    }

    private void checkoutException(Exception e) throws CosXmlClientException, CosXmlServiceException {
        if (e instanceof CosXmlClientException) {
            throw (CosXmlClientException)((Object)e);
        }
        if (e instanceof CosXmlServiceException) {
            throw (CosXmlServiceException)((Object)e);
        }
        throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e.getMessage());
    }

    static class SlidingWindow {
        private int mWidth;
        private int mStart = 0;
        private int mNext = 0;
        private boolean[] completes;

        SlidingWindow(int start, int width) {
            this.mStart = start;
            this.mNext = start;
            this.mWidth = width;
            this.completes = new boolean[this.mWidth];
        }

        synchronized int getNextNumber() {
            while (this.mNext >= this.mStart + this.mWidth) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.mNext++;
        }

        synchronized void complete(int number) {
            this.completes[number - this.mStart] = true;
            int delta = 0;
            for (int i = 0; i < this.completes.length && this.completes[i]; ++i) {
                ++delta;
            }
            if (delta > 0) {
                int i;
                this.mStart += delta;
                int size = this.completes.length;
                for (i = 0; i < size - delta; ++i) {
                    this.completes[i] = this.completes[i + delta];
                }
                for (i = size - delta; i < size; ++i) {
                    this.completes[i] = false;
                }
                this.notifyAll();
            }
        }
    }

    private static class UploadPartTask
    implements Runnable,
    Comparable<UploadPartTask> {
        private TaskCompletionSource<UploadPartResult> tcs;
        private CancellationToken mCancellationToken;
        private CosXmlSimpleService cosXmlSimpleService;
        private UploadPartRequest uploadPartRequest;

        public UploadPartTask(CosXmlSimpleService cosXmlSimpleService, UploadPartRequest uploadPartRequest, CancellationToken cancellationToken) {
            this.cosXmlSimpleService = cosXmlSimpleService;
            this.uploadPartRequest = uploadPartRequest;
            this.tcs = new TaskCompletionSource();
            this.mCancellationToken = cancellationToken;
        }

        @Override
        public void run() {
            if (this.mCancellationToken.isCancellationRequested()) {
                return;
            }
            try {
                this.tcs.setResult((Object)this.cosXmlSimpleService.uploadPart(this.uploadPartRequest));
            }
            catch (CancellationException e) {
                this.tcs.setCancelled();
            }
            catch (Exception e) {
                this.tcs.setError(e);
            }
        }

        public Task<UploadPartResult> getTask() {
            return this.tcs.getTask();
        }

        public void cancel() {
            this.cosXmlSimpleService.cancel(this.uploadPartRequest);
        }

        @Override
        public int compareTo(UploadPartTask o) {
            return 0;
        }
    }
}

