/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.crypto.COSDirectImpl;
import com.tencent.cos.xml.crypto.CryptoModuleAE;
import com.tencent.cos.xml.crypto.CryptoModuleBase;
import com.tencent.cos.xml.crypto.EncryptionMaterialsProvider;
import com.tencent.cos.xml.crypto.QCLOUDKMS;
import com.tencent.cos.xml.crypto.TencentCloudKMSClient;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.transfer.COSDownloadTask;
import com.tencent.cos.xml.transfer.COSUploadTask;
import com.tencent.cos.xml.transfer.TransferConfig;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;

public class TransferService {
    private CryptoModuleBase cryptoModule;
    protected CosXmlSimpleService cosXmlService;
    protected TransferConfig transferConfig;
    private QCLOUDKMS kms;

    public TransferService(CosXmlSimpleService cosXmlService, TransferConfig transferConfig) {
        if (cosXmlService == null) {
            throw new IllegalArgumentException("CosXmlService is null");
        }
        if (transferConfig == null) {
            throw new IllegalArgumentException("TransferConfig is null");
        }
        this.cosXmlService = cosXmlService;
        this.transferConfig = transferConfig;
    }

    public TransferService(CosXmlSimpleService cosXmlService, TransferConfig transferConfig, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(cosXmlService, transferConfig);
        this.kms = this.newTencentCloudKMSClient(cosXmlService.getCredentialProvider());
        this.cryptoModule = new CryptoModuleAE(this.kms, cosXmlService, cosXmlService.getCredentialProvider(), encryptionMaterialsProvider);
    }

    private TencentCloudKMSClient newTencentCloudKMSClient(QCloudCredentialProvider credentialProvider) {
        String region = this.cosXmlService.getConfig().getRegion();
        TencentCloudKMSClient kmsClient = new TencentCloudKMSClient(region, credentialProvider);
        return kmsClient;
    }

    public COSUploadTask upload(PutObjectRequest putObjectRequest) {
        COSUploadTask cosUploadTask = new COSUploadTask((COSDirect)new COSDirectImpl(this.cosXmlService, this.cryptoModule), putObjectRequest);
        cosUploadTask.setPartSize(this.transferConfig.sliceSizeForUpload);
        cosUploadTask.setSliceSizeThreshold(this.transferConfig.divisionForUpload);
        cosUploadTask.forceSimpleUpload(this.transferConfig.isForceSimpleUpload());
        cosUploadTask.setVerifyCRC64(this.transferConfig.isVerifyCRC64());
        cosUploadTask.start();
        return cosUploadTask;
    }

    public COSDownloadTask download(GetObjectRequest getObjectRequest) {
        COSDownloadTask cosDownloadTask = new COSDownloadTask((COSDirect)new COSDirectImpl(this.cosXmlService, this.cryptoModule), getObjectRequest);
        cosDownloadTask.start();
        return cosDownloadTask;
    }
}

