/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.crypto.COSKeyWrapScheme;
import com.tencent.cos.xml.crypto.ContentCryptoScheme;
import java.security.SecureRandom;

final class COSCryptoScheme {
    static final String AES = "AES";
    static final String RSA = "RSA";
    private static final SecureRandom srand = new SecureRandom();
    private final COSKeyWrapScheme kwScheme;
    private final ContentCryptoScheme contentCryptoScheme;

    private COSCryptoScheme(ContentCryptoScheme contentCryptoScheme, COSKeyWrapScheme kwScheme) {
        this.contentCryptoScheme = contentCryptoScheme;
        this.kwScheme = kwScheme;
    }

    SecureRandom getSecureRandom() {
        return srand;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.contentCryptoScheme;
    }

    COSKeyWrapScheme getKeyWrapScheme() {
        return this.kwScheme;
    }

    static boolean isAesGcm(String cipherAlgorithm) {
        return ContentCryptoScheme.AES_GCM.getCipherAlgorithm().equals(cipherAlgorithm);
    }

    static COSCryptoScheme from() {
        return new COSCryptoScheme(ContentCryptoScheme.AES_CTR, new COSKeyWrapScheme());
    }
}

