/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.crypto.Releasable;
import com.tencent.qcloud.core.util.IOUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SdkFilterInputStream
extends FilterInputStream
implements Releasable {
    private volatile boolean aborted = false;

    protected SdkFilterInputStream(InputStream in) {
        super(in);
    }

    protected final void abortIfNeeded() {
        if (Thread.interrupted()) {
            this.abort();
        }
    }

    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        if (this.in instanceof SdkFilterInputStream) {
            ((SdkFilterInputStream)this.in).abort();
        }
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        return this.in.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        this.abortIfNeeded();
        return this.in.read(b2, off, len);
    }

    @Override
    public long skip(long n2) throws IOException {
        this.abortIfNeeded();
        return this.in.skip(n2);
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void release() {
        IOUtils.closeQuietly((InputStream)this);
        if (this.in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)this.in);
            r2.release();
        }
    }
}

