/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.Map;

public final class GetBucketRequest
extends BucketRequest {
    private String prefix = null;
    private String delimiter = null;
    private String encodingType;
    private String marker = null;
    private String maxKeys = "1000";

    public GetBucketRequest(String bucket) {
        super(bucket);
    }

    public GetBucketRequest(String region, String bucket, String prefix) {
        super(bucket);
        this.region = region;
        this.prefix = prefix;
    }

    public String getMethod() {
        return "GET";
    }

    public Map<String, String> getQueryString() {
        if (this.prefix != null) {
            this.queryParameters.put("prefix", this.prefix);
        }
        if (this.delimiter != null) {
            this.queryParameters.put("delimiter", this.delimiter);
        }
        if (this.encodingType != null) {
            this.queryParameters.put("encoding-type", this.encodingType);
        }
        if (this.marker != null) {
            this.queryParameters.put("marker", this.marker);
        }
        if (this.maxKeys != null) {
            this.queryParameters.put("max-keys", this.maxKeys);
        }
        if (this.prefix != null) {
            this.queryParameters.put("prefix", this.prefix);
        }
        return super.getQueryString();
    }

    public RequestBodySerializer getRequestBody() {
        return null;
    }

    public STSCredentialScope[] getSTSCredentialScope(CosXmlServiceConfig config) {
        String action = "name/cos:" + ((Object)((Object)this)).getClass().getSimpleName().replace("Request", "");
        STSCredentialScope scope = new STSCredentialScope(action, config.getBucket(this.bucket), config.getRegion(), this.prefix == null ? null : config.getUrlPath(this.bucket, this.prefix));
        return scope.toArray();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Deprecated
    public void setDelimiter(char delimiter) {
        this.setDelimiter(String.valueOf(delimiter));
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMaxKeys(long maxKeys) {
        this.maxKeys = String.valueOf(maxKeys);
    }

    public long getMaxKeys() {
        return Long.parseLong(this.maxKeys);
    }
}

