/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.StringUtils;

public class PreviewDocumentInHtmlRequest
extends GetObjectRequest {
    public PreviewDocumentInHtmlRequest(String bucket, String cosPath, String savePath) {
        this(bucket, cosPath, savePath, StringUtils.extractNameNoSuffix((String)cosPath));
    }

    public PreviewDocumentInHtmlRequest(String bucket, String cosPath, String savePath, String fileName) {
        super(bucket, cosPath, savePath, fileName);
        this.queryParameters.put("ci-process", "doc-preview");
        this.queryParameters.put("dstType", "html");
    }

    public PreviewDocumentInHtmlRequest setSrcType(String srcType) {
        this.queryParameters.put("srcType", srcType);
        return this;
    }

    public PreviewDocumentInHtmlRequest setCopyable(boolean copyable) {
        this.queryParameters.put("copyable", copyable ? "1" : "0");
        return this;
    }

    public PreviewDocumentInHtmlRequest setHtmlParams(String htmlParams) {
        this.queryParameters.put("htmlParams", htmlParams);
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermark(String watermark) throws CosXmlClientException {
        this.queryParameters.put("htmlwaterword", DigestUtils.getSecurityBase64((String)watermark));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkColor(String htmlfillstyle) throws CosXmlClientException {
        this.queryParameters.put("htmlfillstyle", DigestUtils.getSecurityBase64((String)htmlfillstyle));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkFont(String font) throws CosXmlClientException {
        this.queryParameters.put("htmlfront", DigestUtils.getSecurityBase64((String)font));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkRotate(int rotate) {
        this.queryParameters.put("htmlrotate", String.valueOf(rotate));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkHorizontal(int horizontal) {
        this.queryParameters.put("htmlhorizontal", String.valueOf(horizontal));
        return this;
    }

    public PreviewDocumentInHtmlRequest setWatermarkVertical(int vertical) {
        this.queryParameters.put("htmlvertical", String.valueOf(vertical));
        return this;
    }

    public String getMethod() {
        return "GET";
    }
}

