/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.GetObjectRequest;

public class PreviewDocumentRequest
extends GetObjectRequest {
    private int page;

    public PreviewDocumentRequest(String bucket, String cosPath, String savePath, int page) {
        this(bucket, cosPath, savePath, page + ".jpg", page);
    }

    public PreviewDocumentRequest(String bucket, String cosPath, String savePath, String fileName, int page) {
        super(bucket, cosPath, savePath, fileName);
        this.queryParameters.put("ci-process", "doc-preview");
        this.page = page;
        this.queryParameters.put("page", String.valueOf(page));
    }

    public PreviewDocumentRequest setSrcType(String srcType) {
        this.queryParameters.put("srcType", srcType);
        return this;
    }

    public PreviewDocumentRequest setDstType(String dstType) {
        this.queryParameters.put("dstType", dstType);
        return this;
    }

    public PreviewDocumentRequest setPassword(String password) {
        this.queryParameters.put("password", password);
        return this;
    }

    public PreviewDocumentRequest setComment(int comment) {
        this.queryParameters.put("comment", String.valueOf(comment));
        return this;
    }

    public PreviewDocumentRequest setExcelSheet(int sheet) {
        this.queryParameters.put("sheet", String.valueOf(sheet));
        return this;
    }

    public PreviewDocumentRequest setExcelPaperDirection(int excelPaperDirection) {
        this.queryParameters.put("excelPaperDirection", String.valueOf(excelPaperDirection));
        return this;
    }

    public PreviewDocumentRequest setExcelRow(int excelRow) {
        this.queryParameters.put("excelRow", String.valueOf(excelRow));
        return this;
    }

    public PreviewDocumentRequest setExcelCol(int excelCol) {
        this.queryParameters.put("excelCol", String.valueOf(excelCol));
        return this;
    }

    public PreviewDocumentRequest setExcelPaperSize(int excelPaperSize) {
        this.queryParameters.put("excelPaperSize", String.valueOf(excelPaperSize));
        return this;
    }

    public PreviewDocumentRequest setTxtPagination(boolean txtPagination) {
        this.queryParameters.put("txtPagination", String.valueOf(txtPagination));
        return this;
    }

    public PreviewDocumentRequest setImageParams(String imageParams) {
        this.queryParameters.put("ImageParams", String.valueOf(imageParams));
        return this;
    }

    public PreviewDocumentRequest setQuality(int quality) {
        this.queryParameters.put("quality", String.valueOf(quality));
        return this;
    }

    public PreviewDocumentRequest setScale(int scale) {
        this.queryParameters.put("scale", String.valueOf(scale));
        return this;
    }

    public PreviewDocumentRequest setImageDpi(int imageDpi) {
        this.queryParameters.put("imageDpi", String.valueOf(imageDpi));
        return this;
    }

    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.page < 1) {
            // empty if block
        }
    }

    public String getMethod() {
        return "GET";
    }
}

