/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.qcloud.core.http.HttpResponse;

public class PreviewDocumentResult
extends GetObjectResult {
    private int totalPage;
    private String contentType;
    private String errNo;
    private int totalSheet;
    private String sheetName;
    private String previewFilePath;

    public PreviewDocumentResult(String previewFilePath) {
        this.previewFilePath = previewFilePath;
    }

    public void parseResponseBody(HttpResponse response) throws CosXmlClientException, CosXmlServiceException {
        super.parseResponseBody(response);
        String sTotalPage = response.header("X-Total-Page");
        if (sTotalPage != null) {
            try {
                this.totalPage = Integer.parseInt(sTotalPage);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.contentType = response.header("Content-Type");
        this.errNo = response.header("X-ErrNo\t");
        String sTotalSheet = response.header("X-Total-Sheet");
        if (sTotalSheet != null) {
            try {
                this.totalSheet = Integer.parseInt(sTotalSheet);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.sheetName = response.header("X-Sheet-Name");
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getErrNo() {
        return this.errNo;
    }

    public int getTotalSheet() {
        return this.totalSheet;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getPreviewFilePath() {
        return this.previewFilePath;
    }
}

