/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import androidx.annotation.NonNull;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.BaseMultipartUploadRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.Map;

public final class InitMultipartUploadRequest
extends BaseMultipartUploadRequest {
    private ObjectMetadata metadata;

    public InitMultipartUploadRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public void setCacheControl(@NonNull String cacheControl) {
        this.addHeader("Cache-Control", cacheControl);
    }

    public void setContentDisposition(@NonNull String contentDisposition) {
        this.addHeader("Content-Disposition", contentDisposition);
    }

    public void setContentEncoding(@NonNull String contentEncoding) {
        this.addHeader("Content-Encoding", contentEncoding);
    }

    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.metadata != null) {
            Map<String, Object> rawMetadata = this.metadata.getRawMetadata();
            Map<String, String> useMetadata = this.metadata.getUserMetadata();
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                this.addHeader(entry.getKey(), entry.getValue().toString());
            }
            for (Map.Entry<String, Object> entry : useMetadata.entrySet()) {
                this.addHeader(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setExpires(@NonNull String expires) {
        this.addHeader("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setStroageClass(COSStorageClass stroageClass) {
        this.addHeader("x-cos-storage-class", stroageClass.getStorageClass());
    }

    public String getMethod() {
        return "POST";
    }

    public Map<String, String> getQueryString() {
        this.queryParameters.put("uploads", null);
        return this.queryParameters;
    }

    public RequestBodySerializer getRequestBody() {
        return RequestBodySerializer.bytes((String)this.getContentType(), (byte[])new byte[0]);
    }
}

