/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.Locale;

public final class OptionObjectRequest
extends ObjectRequest {
    private String origin;
    private String accessControlMethod;
    private String accessControlHeaders;

    public OptionObjectRequest(String bucket, String cosPath, String origin, String accessControlMethod) {
        super(bucket, cosPath);
        this.origin = origin;
        this.accessControlMethod = accessControlMethod;
        this.setOrigin(origin);
        this.setAccessControlMethod(accessControlMethod);
    }

    public String getMethod() {
        return "OPTIONS";
    }

    public RequestBodySerializer getRequestBody() {
        return null;
    }

    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.origin == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "option request origin must not be null");
        }
        if (this.accessControlMethod == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "option request accessControlMethod must not be null");
        }
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        if (origin != null) {
            this.addHeader("Origin", origin);
        }
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setAccessControlMethod(String accessControlMethod) {
        if (accessControlMethod != null) {
            this.accessControlMethod = accessControlMethod.toUpperCase(Locale.ROOT);
            this.addHeader("Access-Control-Request-Method", this.accessControlMethod);
        }
    }

    public String getAccessControlMethod() {
        return this.accessControlMethod;
    }

    public void setAccessControlHeaders(String accessControlHeaders) {
        this.accessControlHeaders = accessControlHeaders;
        if (accessControlHeaders != null) {
            this.addHeader("Access-Control-Request-Headers", accessControlHeaders);
        }
    }

    public String getAccessControlHeaders() {
        return this.accessControlHeaders;
    }
}

