/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.tag.eventstreaming;

import com.tencent.cos.xml.model.tag.eventstreaming.HeaderValue;
import com.tencent.cos.xml.model.tag.eventstreaming.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;

class Header {
    private final String name;
    private final HeaderValue value;

    Header(String name, HeaderValue value) {
        this.name = name;
        this.value = value;
    }

    Header(String name, String value) {
        this(name, HeaderValue.fromString(value));
    }

    public String getName() {
        return this.name;
    }

    public HeaderValue getValue() {
        return this.value;
    }

    static Header decode(ByteBuffer buf) {
        String name = null;
        try {
            name = Utils.readShortString(buf);
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return new Header(name, HeaderValue.decode(buf));
    }

    static void encode(Map.Entry<String, HeaderValue> header, DataOutputStream dos) throws IOException {
        new Header(header.getKey(), header.getValue()).encode(dos);
    }

    void encode(DataOutputStream dos) throws IOException {
        Utils.writeShortString(dos, this.name);
        this.value.encode(dos);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Header header = (Header)o2;
        if (!this.name.equals(header.name)) {
            return false;
        }
        return this.value.equals(header.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "Header{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

