/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class CRC64Checksum
extends FileChecksum {
    private static final String ALGORITHM_NAME = "CRC64";
    private long crc64 = 0L;

    public CRC64Checksum() {
    }

    public CRC64Checksum(String crc64ecma) {
        try {
            BigInteger bigInteger = new BigInteger(crc64ecma);
            this.crc64 = bigInteger.longValue();
        }
        catch (NumberFormatException e) {
            this.crc64 = 0L;
        }
    }

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public int getLength() {
        return 8;
    }

    public byte[] getBytes() {
        return this.crc64 != 0L ? WritableUtils.toByteArray((Writable[])new Writable[]{this}) : new byte[]{};
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.crc64);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.crc64 = dataInput.readLong();
    }

    public String toString() {
        return "CRC64Checksum{crc64=" + this.crc64 + '}';
    }
}

