/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.qcloud.cos.utils.StringUtils;
import java.io.IOException;

public enum CosEncryptionMethods {
    SSE_COS("SSE-COS", true),
    SSE_C("SSE-C", true),
    NONE("", false);

    static final String UNKNOWN_ALGORITHM_MESSAGE = "COSN unknown the encryption algorithm ";
    private String method;
    private boolean serverSide;

    private CosEncryptionMethods(String method, boolean serverSide) {
        this.method = method;
        this.serverSide = serverSide;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public static CosEncryptionMethods getMethod(String name) throws IOException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            return NONE;
        }
        for (CosEncryptionMethods v : CosEncryptionMethods.values()) {
            if (!v.getMethod().equals(name)) continue;
            return v;
        }
        throw new IOException(UNKNOWN_ALGORITHM_MESSAGE + name);
    }
}

