/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.qcloud.cos.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferPool;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CRC64Checksum;
import org.apache.hadoop.fs.CosFsDataOutputStream;
import org.apache.hadoop.fs.CosFsInputStream;
import org.apache.hadoop.fs.CosNCopyFileContext;
import org.apache.hadoop.fs.CosNCopyFileTask;
import org.apache.hadoop.fs.CosNDeleteFileContext;
import org.apache.hadoop.fs.CosNDeleteFileTask;
import org.apache.hadoop.fs.CosNFileStatus;
import org.apache.hadoop.fs.CosNativeFileSystemStore;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.PartialListing;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class CosFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(CosFileSystem.class);
    static final String SCHEME = "cosn";
    static final String PATH_DELIMITER = "/";
    static final int COS_MAX_LISTING_LENGTH = 999;
    static final Charset METADATA_ENCODING = StandardCharsets.UTF_8;
    static final int MAX_XATTR_SIZE = 1024;
    private URI uri;
    String bucket;
    private NativeFileSystemStore store;
    private Path workingDir;
    private String owner = "Unknown";
    private String group = "Unknown";
    private ExecutorService boundedIOThreadPool;
    private ExecutorService boundedCopyThreadPool;

    public CosFileSystem() {
    }

    public CosFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    public String getScheme() {
        return SCHEME;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.bucket = uri.getHost();
        if (this.store == null) {
            this.store = CosFileSystem.createDefaultStore(conf);
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        this.owner = this.getOwnerId();
        this.group = this.getGroupId();
        LOG.debug("uri: {}, bucket: {}, working dir: {}, owner: {}, group: {}.\nconfiguration: {}.", new Object[]{uri, this.bucket, this.workingDir, this.owner, this.group, conf});
        BufferPool.getInstance().initialize(this.getConf());
        int uploadThreadPoolSize = this.getConf().getInt("fs.cosn.upload_thread_pool", 8);
        int readAheadPoolSize = this.getConf().getInt("fs.cosn.read.ahead.queue.size", 8);
        int ioThreadPoolSize = uploadThreadPoolSize + readAheadPoolSize / 3;
        long threadKeepAlive = this.getConf().getLong("fs.cosn.threads.keep_alive_time", 60L);
        this.boundedIOThreadPool = new ThreadPoolExecutor(ioThreadPoolSize / 2, ioThreadPoolSize, threadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(ioThreadPoolSize * 2), new ThreadFactoryBuilder().setNameFormat("cos-transfer-shared-%d").setDaemon(true).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        LOG.error("put a io task into the download thread pool occurs an exception.", (Throwable)e);
                    }
                }
            }
        });
        int copyThreadPoolSize = this.getConf().getInt("fs.cosn.copy_thread_pool", 3);
        this.boundedCopyThreadPool = new ThreadPoolExecutor(copyThreadPoolSize / 2, copyThreadPoolSize, threadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(copyThreadPoolSize * 2), new ThreadFactoryBuilder().setNameFormat("cos-copy-%d").setDaemon(true).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        LOG.error("put a copy task into the download thread pool occurs an exception.", (Throwable)e);
                    }
                }
            }
        });
    }

    private static NativeFileSystemStore createDefaultStore(Configuration conf) {
        CosNativeFileSystemStore store = new CosNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.cosn.maxRetries", 200), (long)conf.getLong("fs.cosn.retry.interval.seconds", 3L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<IOException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<IOException>, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("storeFile", methodPolicy);
        methodNameToPolicyMap.put("rename", methodPolicy);
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, methodNameToPolicyMap);
    }

    private String getOwnerId() {
        return System.getProperty("user.name");
    }

    private String getGroupId() {
        return System.getProperty("user.name");
    }

    private String getOwnerInfo(boolean getOwnerId) {
        String ownerInfoId = "";
        try {
            int c;
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            if (!getOwnerId) {
                command = "id -g " + userName;
            }
            Process child = Runtime.getRuntime().exec(command);
            child.waitFor();
            InputStream in = child.getInputStream();
            StringBuilder strBuffer = new StringBuilder();
            while ((c = in.read()) != -1) {
                strBuffer.append((char)c);
            }
            in.close();
            ownerInfoId = strBuffer.toString();
        }
        catch (InterruptedException e) {
            LOG.error("getOwnerInfo occur a exception", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("getOwnerInfo occur a exception", (Throwable)e);
        }
        return ownerInfoId;
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath();
        if (ret.endsWith(PATH_DELIMITER) && ret.indexOf(PATH_DELIMITER) != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        if (!key.startsWith(PATH_DELIMITER)) {
            return new Path(PATH_DELIMITER + key);
        }
        return new Path(key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public Path getHomeDirectory() {
        String homePrefix = this.getConf().get("dfs.user.home.dir.prefix");
        if (null != homePrefix) {
            return this.makeQualified(new Path(homePrefix + PATH_DELIMITER + System.getProperty("user.name")));
        }
        return super.getHomeDirectory();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("Not supported currently");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        LOG.debug("Creating a new file [{}] in COS.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        long uploadPartSize = this.getConf().getLong("fs.cosn.upload.part.size", 0x800000L);
        boolean uploadChecksEnabled = this.getConf().getBoolean("fs.cosn.upload.checks.enable", true);
        return new FSDataOutputStream((OutputStream)new CosFsDataOutputStream(this.getConf(), this.store, key, uploadPartSize, this.boundedIOThreadPool, uploadChecksEnabled), this.statistics);
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws PathIOException {
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Can not delete root path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        FileStatus status;
        LOG.debug("Ready to delete path: {}. recursive: {}.", (Object)f, (Object)recursive);
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Delete called for '{}', but the file does not exist and returning the false.", (Object)f);
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        if (key.compareToIgnoreCase(PATH_DELIMITER) == 0) {
            FileStatus[] fileStatuses = this.listStatus(f);
            return this.rejectRootDirectoryDelete(fileStatuses.length == 0, recursive);
        }
        if (status.isDirectory()) {
            PartialListing listing;
            if (!key.endsWith(PATH_DELIMITER)) {
                key = key + PATH_DELIMITER;
            }
            if (!recursive && this.listStatus(f).length > 0) {
                throw new IOException("Can not delete " + f + " as is a not empty directory and recurse option is false");
            }
            CosNDeleteFileContext deleteFileContext = new CosNDeleteFileContext();
            int deleteToFinishes = 0;
            String priorLastKey = null;
            block9: do {
                listing = this.store.list(key, 999, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    this.boundedCopyThreadPool.execute(new CosNDeleteFileTask(this.store, file.getKey(), deleteFileContext));
                    ++deleteToFinishes;
                    if (!deleteFileContext.isDeleteSuccess()) break;
                }
                for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                    this.boundedCopyThreadPool.execute(new CosNDeleteFileTask(this.store, commonPrefix.getKey(), deleteFileContext));
                    ++deleteToFinishes;
                    if (!deleteFileContext.isDeleteSuccess()) continue block9;
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            deleteFileContext.lock();
            try {
                deleteFileContext.awaitAllFinish(deleteToFinishes);
            }
            catch (InterruptedException e) {
                LOG.warn("interrupted when wait delete to finish");
            }
            finally {
                deleteFileContext.unlock();
            }
            if (!deleteFileContext.isDeleteSuccess() && deleteFileContext.hasException()) {
                throw deleteFileContext.getIOException();
            }
            try {
                LOG.debug("Delete the cos key [{}].", (Object)key);
                this.store.delete(key);
            }
            catch (Exception e) {
                LOG.error("Delete the key failed.");
            }
        } else {
            LOG.debug("Delete the cos key [{}].", (Object)key);
            this.store.delete(key);
        }
        this.createParentDirectoryIfNecessary(f);
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LOG.debug("Get file status: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            if (meta.isFile()) {
                LOG.debug("Retrieve the cos key [{}] to find that it is a file.", (Object)key);
                return this.newFile(meta, absolutePath);
            }
            LOG.debug("Retrieve the cos key [{}] to find that it is a directory.", (Object)key);
            return this.newDirectory(meta, absolutePath);
        }
        if (!key.endsWith(PATH_DELIMITER)) {
            key = key + PATH_DELIMITER;
        }
        LOG.debug("List the cos key [{}] to judge whether it is a directory or not.", (Object)key);
        PartialListing listing = this.store.list(key, 1);
        if (listing.getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            LOG.debug("List the cos key [{}] to find that it is a directory.", (Object)key);
            return this.newDirectory(absolutePath);
        }
        LOG.debug("Can not find the cos key [{}] on COS.", (Object)key);
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        LOG.debug("list status:" + f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null && meta.isFile()) {
            return new FileStatus[]{this.newFile(meta, absolutePath)};
        }
        if (!key.endsWith(PATH_DELIMITER)) {
            key = key + PATH_DELIMITER;
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            listing = this.store.list(key, 999, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                Path subPath = CosFileSystem.keyToPath(fileMetadata.getKey());
                if (fileMetadata.getKey().equals(key)) {
                    LOG.debug("This is just the directory we have been asked to list. cos key: {}.", (Object)fileMetadata.getKey());
                    continue;
                }
                status.add(this.newFile(fileMetadata, subPath));
            }
            for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                Path subpath = CosFileSystem.keyToPath(commonPrefix.getKey());
                String relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(commonPrefix, new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        return status.toArray(new FileStatus[status.size()]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new CosNFileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()), meta.getETag(), meta.getCrc64ecm(), meta.getVersionId());
    }

    private FileStatus newDirectory(Path path) {
        return new CosNFileStatus(0L, true, 1, 0L, 0L, 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(FileMetadata meta, Path path) {
        if (meta == null) {
            return this.newDirectory(path);
        }
        return new CosNFileStatus(0L, true, 1, 0L, meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()), meta.getETag(), meta.getCrc64ecm(), meta.getVersionId());
    }

    private void validatePath(Path path) throws IOException {
        Path parent = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(parent);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", parent));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if ((parent = parent.getParent()) != null) continue;
            }
            break;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        LOG.debug("mkdirs path: {}.", (Object)f);
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            this.validatePath(f);
            return this.mkDirRecursively(f, permission);
        }
    }

    public boolean mkDirRecursively(Path f, FsPermission permission) throws IOException {
        Path path;
        LOG.debug("Make the directory recursively. Path: {}, FsPermission: {}.", (Object)f, (Object)permission);
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        Iterator iterator = paths.iterator();
        while (iterator.hasNext() && !(path = (Path)iterator.next()).isRoot()) {
            try {
                FileStatus fileStatus = this.getFileStatus(path);
                if (fileStatus.isFile()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", f));
                }
                if (!fileStatus.isDirectory()) continue;
                if (fileStatus.getModificationTime() <= 0L) {
                    throw new FileNotFoundException("Dir '" + path + "' doesn't exist in COS");
                }
                break;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Make the directory [{}] on COS.", (Object)path);
                String folderPath = CosFileSystem.pathToKey(this.makeAbsolute(path));
                if (!folderPath.endsWith(PATH_DELIMITER)) {
                    folderPath = folderPath + PATH_DELIMITER;
                }
                this.store.storeEmptyFile(folderPath);
            }
        }
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.info("Opening '" + f + "' for reading");
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new CosFsInputStream(this.getConf(), this.store, this.statistics, key, fileStatus.getLen(), this.boundedIOThreadPool), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileStatus srcFileStatus;
        block13: {
            Path dstParentPath;
            LOG.debug("Rename the source path [{}] to the dest path [{}].", (Object)src, (Object)dst);
            if (src.isRoot()) {
                LOG.debug("Cannot rename the root directory of a filesystem.");
                return false;
            }
            try {
                srcFileStatus = this.getFileStatus(src);
            }
            catch (FileNotFoundException e) {
                LOG.debug("The source path [{}] is not exist.", (Object)src);
                return false;
            }
            if (src.equals((Object)dst)) {
                LOG.debug("The source path and the dest path refer to the same file or directory: {}", (Object)dst);
                throw new IOException("the source path and dest path refer to the same file or directory");
            }
            for (dstParentPath = dst.getParent(); null != dstParentPath && !src.equals((Object)dstParentPath); dstParentPath = dstParentPath.getParent()) {
            }
            if (null != dstParentPath) {
                LOG.debug("It is not allowed to rename a parent directory:{} to its subdirectory:{}.", (Object)src, (Object)dst);
                throw new IOException(String.format("It is not allowed to rename a parent directory:%s to its subdirectory:%s", src, dst));
            }
            FileStatus dstFileStatus = null;
            try {
                FileStatus[] statuses;
                dstFileStatus = this.getFileStatus(dst);
                if (dstFileStatus.isFile()) {
                    LOG.debug("File: {} already exists.", (Object)dstFileStatus.getPath());
                    return false;
                }
                dst = new Path(dst, src.getName());
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException e) {
                    statuses = null;
                }
                if (null != statuses && statuses.length > 0) {
                    LOG.debug("Cannot rename {} to {}, file already exists.", (Object)src, (Object)dst);
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                Path tempDstParentPath = dst.getParent();
                FileStatus dstParentStatus = this.getFileStatus(tempDstParentPath);
                if (dstParentStatus.isDirectory()) break block13;
                throw new IOException(String.format("Cannot rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        }
        boolean result = false;
        result = srcFileStatus.isDirectory() ? this.copyDirectory(src, dst) : this.copyFile(src, dst);
        if (!result) {
            return false;
        }
        return this.delete(src, true);
    }

    private boolean copyFile(Path srcPath, Path dstPath) throws IOException {
        String srcKey = CosFileSystem.pathToKey(srcPath);
        String dstKey = CosFileSystem.pathToKey(dstPath);
        this.store.copy(srcKey, dstKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        PartialListing objectList;
        String dstKey;
        String srcKey = CosFileSystem.pathToKey(srcPath);
        if (!srcKey.endsWith(PATH_DELIMITER)) {
            srcKey = srcKey + PATH_DELIMITER;
        }
        if (!(dstKey = CosFileSystem.pathToKey(dstPath)).endsWith(PATH_DELIMITER)) {
            dstKey = dstKey + PATH_DELIMITER;
        }
        if (dstKey.startsWith(srcKey)) {
            throw new IOException("can not copy a directory to a subdirectory of self");
        }
        if (this.store.retrieveMetadata(srcKey) == null) {
            this.store.storeEmptyFile(srcKey);
        } else {
            this.store.copy(srcKey, dstKey);
        }
        CosNCopyFileContext copyFileContext = new CosNCopyFileContext();
        int copiesToFinishes = 0;
        String priorLastKey = null;
        block5: do {
            objectList = this.store.list(srcKey, 999, priorLastKey, true);
            for (FileMetadata file : objectList.getFiles()) {
                this.boundedCopyThreadPool.execute(new CosNCopyFileTask(this.store, file.getKey(), dstKey.concat(file.getKey().substring(srcKey.length())), copyFileContext));
                ++copiesToFinishes;
                if (!copyFileContext.isCopySuccess()) continue block5;
            }
        } while (null != (priorLastKey = objectList.getPriorLastKey()));
        copyFileContext.lock();
        try {
            copyFileContext.awaitAllFinish(copiesToFinishes);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted when wait copies to finish");
        }
        finally {
            copyFileContext.unlock();
        }
        return copyFileContext.isCopySuccess();
    }

    private void createParentDirectoryIfNecessary(Path path) throws IOException {
        String parentKey;
        Path parent = path.getParent();
        if (!(null == parent || parent.isRoot() || StringUtils.isNullOrEmpty((String)(parentKey = CosFileSystem.pathToKey(parent))) || this.exists(parent))) {
            LOG.debug("Create a parent directory [{}] for the path [{}].", (Object)parent, (Object)path);
            if (!parentKey.endsWith(PATH_DELIMITER)) {
                parentKey = parentKey + PATH_DELIMITER;
            }
            this.store.storeEmptyFile(parentKey);
        }
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.cosn.block.size", 0x8000000L);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        LOG.debug("Call the checksum for the path: {}.", (Object)f);
        if (this.getConf().getBoolean("fs.cosn.crc64.checksum.enabled", false)) {
            Path absolutePath = this.makeAbsolute(f);
            String key = CosFileSystem.pathToKey(absolutePath);
            FileMetadata fileMetadata = this.store.retrieveMetadata(key);
            String crc64ecm = fileMetadata.getCrc64ecm();
            return crc64ecm != null ? new CRC64Checksum(crc64ecm) : super.getFileChecksum(f, length);
        }
        return super.getFileChecksum(f, length);
    }

    public void setXAttr(Path f, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        LOG.debug("set XAttr: {}.", (Object)f);
        if (name.getBytes(METADATA_ENCODING).length + value.length > 1024) {
            throw new HadoopIllegalArgumentException(String.format("The maximum combined size of the name and value of an extended attribute in bytes should be less than or equal to %d", 1024));
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        boolean xAttrExists = null != fileMetadata.getUserAttributes() && fileMetadata.getUserAttributes().containsKey(name);
        XAttrSetFlag.validate((String)name, (boolean)xAttrExists, flag);
        if (fileMetadata.isFile()) {
            this.store.storeFileAttribute(key, name, value);
        } else {
            this.store.storeDirAttribute(key, name, value);
        }
    }

    public byte[] getXAttr(Path f, String name) throws IOException {
        LOG.debug("get XAttr: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        if (null != fileMetadata.getUserAttributes()) {
            return fileMetadata.getUserAttributes().get(name);
        }
        return null;
    }

    public Map<String, byte[]> getXAttrs(Path f, List<String> names) throws IOException {
        LOG.debug("get XAttrs: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        HashMap<String, byte[]> attrs = null;
        if (null != fileMetadata.getUserAttributes()) {
            attrs = new HashMap<String, byte[]>();
            for (String name : names) {
                if (!fileMetadata.getUserAttributes().containsKey(name)) continue;
                attrs.put(name, fileMetadata.getUserAttributes().get(name));
            }
        }
        return attrs;
    }

    public void removeXAttr(Path f, String name) throws IOException {
        boolean xAttrExists;
        LOG.debug("remove XAttr: {}.", (Object)f);
        Path absolutPath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutPath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        boolean bl = xAttrExists = null != fileMetadata.getUserAttributes() && fileMetadata.getUserAttributes().containsKey(name);
        if (xAttrExists) {
            if (fileMetadata.isFile()) {
                this.store.removeFileAttribute(key, name);
            } else {
                this.store.removeDirAttribute(key, name);
            }
        }
    }

    public Map<String, byte[]> getXAttrs(Path f) throws IOException {
        LOG.debug("get XAttrs: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        return fileMetadata.getUserAttributes();
    }

    public List<String> listXAttrs(Path f) throws IOException {
        LOG.debug("list XAttrs: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        return new ArrayList<String>(fileMetadata.getUserAttributes().keySet());
    }

    public void close() throws IOException {
        try {
            this.store.close();
            this.boundedIOThreadPool.shutdown();
            this.boundedCopyThreadPool.shutdown();
            BufferPool.getInstance().close();
        }
        finally {
            super.close();
        }
    }

    public NativeFileSystemStore getStore() {
        return this.store;
    }
}

