/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qcloud.cos.model.PartETag;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferInputStream;
import org.apache.hadoop.fs.BufferOutputStream;
import org.apache.hadoop.fs.BufferPool;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.WriteConsistencyChecker;
import org.apache.hadoop.fs.buffer.CosNByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosFsDataOutputStream
extends OutputStream {
    static final Logger LOG = LoggerFactory.getLogger(CosFsDataOutputStream.class);
    private final Configuration conf;
    private final NativeFileSystemStore store;
    private MessageDigest digest;
    private long blockSize;
    private String key;
    private int currentBlockId = 0;
    private CosNByteBuffer currentBlockBuffer;
    private OutputStream currentBlockOutputStream;
    private String uploadId = null;
    private final ListeningExecutorService executorService;
    private final List<ListenableFuture<PartETag>> partEtagList = new LinkedList<ListenableFuture<PartETag>>();
    private int blockWritten = 0;
    private WriteConsistencyChecker writeConsistencyChecker = null;
    private boolean closed = false;

    public CosFsDataOutputStream(Configuration conf, NativeFileSystemStore store, String key, long blockSize, ExecutorService executorService, boolean checksEnabled) throws IOException {
        this.conf = conf;
        this.store = store;
        this.key = key;
        this.blockSize = blockSize;
        if (checksEnabled) {
            LOG.info("The consistency checker is enabled.");
            this.writeConsistencyChecker = new WriteConsistencyChecker(this.store, this.key);
        } else {
            LOG.warn("The consistency checker is disabled.");
        }
        if (this.blockSize < 0x100000L) {
            LOG.warn("The minimum size of a single block is limited to greater than or equal to {}.", (Object)0x100000L);
            this.blockSize = 0x100000L;
        }
        if (this.blockSize > 0x80000000L) {
            LOG.warn("The maximum size of a single block is limited to smaller than or equal to {}.", (Object)0x80000000L);
            this.blockSize = 0x80000000L;
        }
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.currentBlockBuffer = null;
        this.currentBlockOutputStream = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.currentBlockOutputStream == null) {
            this.initCurrentBlock();
        }
        this.currentBlockOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.currentBlockOutputStream == null) {
            this.initCurrentBlock();
        }
        try {
            this.currentBlockOutputStream.flush();
            this.currentBlockOutputStream.close();
            if (this.currentBlockId == 0) {
                LOG.info("Single file upload...  key: {}, blockId: {}, blockWritten: {}.", new Object[]{this.key, this.currentBlockId, this.blockWritten});
                byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                int size = this.currentBlockBuffer.getByteBuffer().remaining();
                this.store.storeFile(this.key, new BufferInputStream(this.currentBlockBuffer), md5Hash, this.currentBlockBuffer.getByteBuffer().remaining());
                if (null != this.writeConsistencyChecker) {
                    this.writeConsistencyChecker.incrementWrittenBytes(size);
                }
                if (null != this.writeConsistencyChecker) {
                    this.writeConsistencyChecker.finish();
                    if (!this.writeConsistencyChecker.getCheckResult().isSucceeded()) {
                        String exceptionMsg = String.format("Failed to upload the key: %s, error message: %s.", this.key, this.writeConsistencyChecker.getCheckResult().getDescription());
                        throw new IOException(exceptionMsg);
                    }
                    LOG.info("Upload the key [{}] successfully. check message: {}.", (Object)this.key, (Object)this.writeConsistencyChecker.getCheckResult().getDescription());
                } else {
                    LOG.info("OutputStream for key [{}] upload complete. But it is not checked.", (Object)this.key);
                }
            } else {
                List<PartETag> futurePartEtagList;
                PartETag partETag = null;
                if (this.blockWritten > 0) {
                    ++this.currentBlockId;
                    LOG.info("Upload the last part. key: {}, blockId: [{}], blockWritten: [{}]", new Object[]{this.key, this.currentBlockId, this.blockWritten});
                    byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                    int size = this.currentBlockBuffer.getByteBuffer().remaining();
                    partETag = this.store.uploadPart(new BufferInputStream(this.currentBlockBuffer), this.key, this.uploadId, this.currentBlockId, this.currentBlockBuffer.getByteBuffer().remaining(), md5Hash);
                    if (null != this.writeConsistencyChecker) {
                        this.writeConsistencyChecker.incrementWrittenBytes(size);
                    }
                }
                if (null == (futurePartEtagList = this.waitForFinishPartUploads())) {
                    throw new IOException("failed to multipart upload to cos, abort it.");
                }
                LinkedList<PartETag> tempPartETagList = new LinkedList<PartETag>(futurePartEtagList);
                if (null != partETag) {
                    tempPartETagList.add(partETag);
                }
                this.store.completeMultipartUpload(this.key, this.uploadId, tempPartETagList);
                if (null != this.writeConsistencyChecker) {
                    this.writeConsistencyChecker.finish();
                    if (!this.writeConsistencyChecker.getCheckResult().isSucceeded()) {
                        String exceptionMsg = String.format("Failed to upload the key: %s, error message: %s.", this.key, this.writeConsistencyChecker.getCheckResult().getDescription());
                        throw new IOException(exceptionMsg);
                    }
                    LOG.info("Upload the key [{}] successfully. check message: {}.", (Object)this.key, (Object)this.writeConsistencyChecker.getCheckResult().getDescription());
                } else {
                    LOG.info("OutputStream for key [{}] upload complete. But it is not checked.", (Object)this.key);
                }
            }
        }
        finally {
            BufferPool.getInstance().returnBuffer(this.currentBlockBuffer);
            this.blockWritten = 0;
            this.closed = true;
            this.writeConsistencyChecker = null;
            this.currentBlockBuffer = null;
            this.currentBlockOutputStream = null;
        }
    }

    private List<PartETag> waitForFinishPartUploads() throws IOException {
        try {
            LOG.info("Waiting for finish part uploads...");
            return (List)Futures.allAsList(this.partEtagList).get();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupt the part upload...", (Throwable)e);
            return null;
        }
        catch (ExecutionException e) {
            LOG.error("Cancelling futures...");
            for (ListenableFuture<PartETag> future : this.partEtagList) {
                future.cancel(true);
            }
            this.store.abortMultipartUpload(this.key, this.uploadId);
            String exceptionMsg = String.format("multipart upload with id: %s to %s.", this.uploadId, this.key);
            throw new IOException(exceptionMsg);
        }
    }

    private void uploadPart() throws IOException {
        this.currentBlockOutputStream.flush();
        this.currentBlockOutputStream.close();
        if (this.currentBlockId == 0) {
            this.uploadId = this.store.getUploadId(this.key);
        }
        ++this.currentBlockId;
        LOG.debug("upload part blockId: {}, uploadId: {}.", (Object)this.currentBlockId, (Object)this.uploadId);
        final byte[] md5Hash = this.digest == null ? null : this.digest.digest();
        ListenableFuture partETagListenableFuture = this.executorService.submit((Callable)new Callable<PartETag>(){
            private final CosNByteBuffer buffer;
            private final String localKey;
            private final String localUploadId;
            private final int blockId;
            private final byte[] blockMD5Hash;
            {
                this.buffer = CosFsDataOutputStream.this.currentBlockBuffer;
                this.localKey = CosFsDataOutputStream.this.key;
                this.localUploadId = CosFsDataOutputStream.this.uploadId;
                this.blockId = CosFsDataOutputStream.this.currentBlockId;
                this.blockMD5Hash = md5Hash;
            }

            @Override
            public PartETag call() throws Exception {
                try {
                    PartETag partETag;
                    PartETag partETag2 = partETag = CosFsDataOutputStream.this.store.uploadPart(new BufferInputStream(this.buffer), this.localKey, this.localUploadId, this.blockId, this.buffer.getByteBuffer().remaining(), this.blockMD5Hash);
                    return partETag2;
                }
                finally {
                    BufferPool.getInstance().returnBuffer(this.buffer);
                }
            }
        });
        this.partEtagList.add((ListenableFuture<PartETag>)partETagListenableFuture);
        try {
            this.currentBlockBuffer = BufferPool.getInstance().getBuffer((int)this.blockSize);
        }
        catch (InterruptedException e) {
            String exceptionMsg = String.format("getting a buffer size: [%d] from the buffer pool occurs an exception.", this.blockSize);
            throw new IOException(exceptionMsg, e);
        }
        if (null != this.digest) {
            this.digest.reset();
            this.currentBlockOutputStream = new DigestOutputStream(new BufferOutputStream(this.currentBlockBuffer), this.digest);
        } else {
            this.currentBlockOutputStream = new BufferOutputStream(this.currentBlockBuffer);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("block stream has been closed.");
        }
        if (this.currentBlockOutputStream == null) {
            this.initCurrentBlock();
        }
        while (len > 0) {
            long writeBytes = 0L;
            writeBytes = (long)(this.blockWritten + len) > this.blockSize ? this.blockSize - (long)this.blockWritten : (long)len;
            this.currentBlockOutputStream.write(b, off, (int)writeBytes);
            this.blockWritten = (int)((long)this.blockWritten + writeBytes);
            if ((long)this.blockWritten >= this.blockSize) {
                this.uploadPart();
                if (null != this.writeConsistencyChecker) {
                    this.writeConsistencyChecker.incrementWrittenBytes(this.blockWritten);
                }
                this.blockWritten = 0;
            }
            len = (int)((long)len - writeBytes);
            off = (int)((long)off + writeBytes);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("block stream has been closed.");
        }
        if (this.currentBlockOutputStream == null) {
            this.initCurrentBlock();
        }
        byte[] singleBytes = new byte[]{(byte)b};
        this.currentBlockOutputStream.write(singleBytes, 0, 1);
        ++this.blockWritten;
        if ((long)this.blockWritten >= this.blockSize) {
            this.uploadPart();
            if (null != this.writeConsistencyChecker) {
                this.writeConsistencyChecker.incrementWrittenBytes(this.blockWritten);
            }
            this.blockWritten = 0;
        }
    }

    private void initCurrentBlock() throws IOException {
        try {
            this.currentBlockBuffer = BufferPool.getInstance().getBuffer((int)this.blockSize);
        }
        catch (InterruptedException e) {
            String exceptionMsg = String.format("Getting a buffer size:[%d] from the buffer pool occurs an exception.", this.blockSize);
            throw new IOException(exceptionMsg);
        }
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.currentBlockOutputStream = new DigestOutputStream(new BufferOutputStream(this.currentBlockBuffer), this.digest);
        }
        catch (NoSuchAlgorithmException e) {
            this.digest = null;
            this.currentBlockOutputStream = new BufferOutputStream(this.currentBlockBuffer);
        }
    }
}

