/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileMetadata {
    private final String key;
    private final long length;
    private final long lastModified;
    private final boolean isFile;
    private final String ETag;
    private final String crc64ecm;
    private final String versionId;
    private final String storageClass;
    private final Map<String, byte[]> userAttributes;

    public FileMetadata(String key, long length, long lastModified) {
        this(key, length, lastModified, true);
    }

    public FileMetadata(String key, long length, long lastModified, boolean isFile) {
        this(key, length, lastModified, isFile, null);
    }

    public FileMetadata(String key, long length, long lastModified, boolean isFile, String ETag) {
        this(key, length, lastModified, isFile, ETag, null, null);
    }

    public FileMetadata(String key, long length, long lastModified, boolean isFile, String eTag, String crc64ecm, String versionId) {
        this(key, length, lastModified, isFile, eTag, crc64ecm, versionId, null, null);
    }

    public FileMetadata(String key, long length, long lastModified, boolean isFile, String eTag, String crc64ecm, String versionId, String storageClass) {
        this(key, length, lastModified, isFile, eTag, crc64ecm, versionId, storageClass, null);
    }

    public FileMetadata(String key, long length, long lastModified, boolean isFile, String eTag, String crc64ecm, String versionId, String storageClass, Map<String, byte[]> userAttributes) {
        this.key = key;
        this.length = length;
        this.lastModified = lastModified;
        this.isFile = isFile;
        this.ETag = eTag;
        this.crc64ecm = crc64ecm;
        this.versionId = versionId;
        this.storageClass = storageClass;
        this.userAttributes = userAttributes;
    }

    public String getKey() {
        return this.key;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.ETag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getCrc64ecm() {
        return this.crc64ecm;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public Map<String, byte[]> getUserAttributes() {
        return this.userAttributes;
    }

    public String toString() {
        return "FileMetadata[" + this.key + ", " + this.length + ", " + this.lastModified + ", file?" + this.isFile + "]";
    }

    public boolean isFile() {
        return this.isFile;
    }
}

