/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteConsistencyChecker {
    private static final Logger LOG = LoggerFactory.getLogger(WriteConsistencyChecker.class);
    private NativeFileSystemStore store;
    private String key;
    private volatile long beforeWrittenBytes;
    private long afterWrittenBytes;
    private volatile boolean finished;
    private CheckResult checkResult;

    public WriteConsistencyChecker(NativeFileSystemStore store, String cosKey) throws IOException {
        if (null == store || null == cosKey || cosKey.isEmpty()) {
            throw new IOException(String.format("Native FileSystem store [%s] or key [%s] is illegal.", store, cosKey));
        }
        this.store = store;
        this.key = cosKey;
        this.beforeWrittenBytes = -1L;
        this.afterWrittenBytes = -1L;
        this.finished = false;
        this.checkResult = new CheckResult("cosn", this.key, false, -1L, -1L);
    }

    public synchronized void incrementWrittenBytes(long writtenBytes) {
        if (this.finished) {
            LOG.error("The cos key [{}] has ended statistics.", (Object)this.key);
            return;
        }
        if (this.beforeWrittenBytes < 0L) {
            LOG.debug("Resetting the beforeWrittenBytes as 0.");
            this.beforeWrittenBytes = 0L;
        }
        this.beforeWrittenBytes += writtenBytes;
    }

    public synchronized void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        try {
            this.afterWrittenBytes = this.store.getFileLength(this.key);
            LOG.debug("Get the target key [{}]'s length: {}.", (Object)this.key, (Object)this.afterWrittenBytes);
        }
        catch (IOException e) {
            LOG.error("Failed to get the target key [{}]'s length.", (Object)this.key, (Object)e);
            this.checkResult.setFsScheme("cosn");
            this.checkResult.setKey(this.key);
            this.checkResult.setExpectedLength(this.beforeWrittenBytes);
            this.checkResult.setRealLength(-1L);
            return;
        }
        this.checkResult.setFsScheme("cosn");
        this.checkResult.setKey(this.key);
        this.checkResult.setExpectedLength(this.beforeWrittenBytes);
        this.checkResult.setRealLength(this.afterWrittenBytes);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public CheckResult getCheckResult() {
        return this.checkResult;
    }

    public static final class CheckResult {
        private String fsScheme;
        private String key;
        private long expectedLength;
        private long realLength;
        private String description;

        public CheckResult() {
            this("", "", false, -1L, -1L);
        }

        public CheckResult(String scheme, String cosKey, boolean checkResult, long expectedLength, long realLength) {
            this.fsScheme = scheme;
            this.key = cosKey;
            this.expectedLength = expectedLength;
            this.realLength = realLength;
            this.description = "";
        }

        public String getFsScheme() {
            return this.fsScheme;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isSucceeded() {
            if (this.expectedLength < 0L && this.realLength < 0L) {
                LOG.debug("Invalid check data. expected length: {}, real length: {}.", (Object)this.expectedLength, (Object)this.realLength);
                return false;
            }
            if (this.expectedLength >= 0L && this.realLength < 0L) {
                LOG.debug("Failed to get actual file length. expected length: {}, real length: {}.", (Object)this.expectedLength, (Object)this.realLength);
                return false;
            }
            if (this.expectedLength < 0L && this.realLength >= 0L) {
                LOG.debug("The expected length is invalid. expected length: {}, real length: {}.", (Object)this.expectedLength, (Object)this.realLength);
                return false;
            }
            LOG.debug("The expected length: {}, the real length: {}.", (Object)this.expectedLength, (Object)this.realLength);
            return this.expectedLength == this.realLength;
        }

        public long getExpectedLength() {
            return this.expectedLength;
        }

        public long getRealLength() {
            return this.realLength;
        }

        public String getDescription() {
            if (!this.description.isEmpty()) {
                return this.description;
            }
            if (this.expectedLength < 0L && this.realLength < 0L) {
                this.description = String.format("Invalid check data. expected length: %d, real length: %d", this.expectedLength, this.realLength);
                return this.description;
            }
            if (this.expectedLength >= 0L && this.realLength < 0L) {
                this.description = String.format("Failed to get actual file length. expected length: %d, real length: %d", this.expectedLength, this.realLength);
                return this.description;
            }
            if (this.expectedLength < 0L && this.realLength >= 0L) {
                this.description = String.format("The expected length is invalid. Forgot to call the write statistics?. expected length: %d, real length: %d", this.expectedLength, this.realLength);
                return this.description;
            }
            this.description = this.expectedLength == this.realLength ? String.format("File verification succeeded. expected length: %d, real length: %d", this.expectedLength, this.realLength) : String.format("File verification failure. expected length: %d, real length: %d", this.expectedLength, this.realLength);
            return this.description;
        }

        public void setFsScheme(String fsScheme) {
            this.fsScheme = fsScheme;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setExpectedLength(long expectedLength) {
            this.expectedLength = expectedLength;
        }

        public void setRealLength(long realLength) {
            this.realLength = realLength;
        }
    }
}

