/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.thirdparty.org.apache.commons.codec.binary.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ConsistencyChecker;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.cosn.Abortable;
import org.apache.hadoop.fs.cosn.BufferInputStream;
import org.apache.hadoop.fs.cosn.BufferOutputStream;
import org.apache.hadoop.fs.cosn.BufferPool;
import org.apache.hadoop.fs.cosn.buffer.CosNByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNFSDataOutputStream
extends OutputStream
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(CosNFSDataOutputStream.class);
    protected final Configuration conf;
    protected final NativeFileSystemStore nativeStore;
    protected final ListeningExecutorService executorService;
    protected final String cosKey;
    protected final long partSize;
    protected MultipartUpload multipartUpload;
    protected int currentPartNumber;
    protected CosNByteBuffer currentPartBuffer;
    protected OutputStream currentPartOutputStream;
    protected long currentPartWriteBytes;
    protected boolean dirty;
    protected boolean committed;
    protected boolean closed;
    protected MessageDigest currentPartMessageDigest;
    protected ConsistencyChecker consistencyChecker;

    public CosNFSDataOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String key, ExecutorService executorService) throws IOException {
        this.conf = conf;
        this.nativeStore = nativeStore;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.cosKey = key;
        long partSize = conf.getLong("fs.cosn.upload.part.size", 0x800000L);
        if (partSize < 0x100000L) {
            LOG.warn("The minimum size of a single block is limited to greater than or equal to {}.", (Object)0x100000L);
            this.partSize = 0x100000L;
        } else if (partSize > 0x80000000L) {
            LOG.warn("The maximum size of a single block is limited to smaller than or equal to {}.", (Object)0x80000000L);
            this.partSize = 0x80000000L;
        } else {
            this.partSize = partSize;
        }
        this.multipartUpload = null;
        this.currentPartNumber = 0;
        this.currentPartBuffer = null;
        this.currentPartOutputStream = null;
        this.currentPartWriteBytes = 0L;
        this.dirty = true;
        this.committed = false;
        this.closed = false;
        if (conf.getBoolean("fs.cosn.upload.part.checksum.enabled", true)) {
            LOG.info("The MPU-UploadPart checksum is enabled, and the message digest algorithm is {}.", (Object)"MD5");
            try {
                this.currentPartMessageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Failed to MD5 digest, the upload will not check.");
                this.currentPartMessageDigest = null;
            }
        } else {
            LOG.warn("The MPU-UploadPart checksum is disabled.");
            this.currentPartMessageDigest = null;
        }
        boolean uploadChecksEnabled = conf.getBoolean("fs.cosn.upload.checks.enabled", true);
        if (uploadChecksEnabled) {
            LOG.info("The consistency checker is enabled.");
            this.consistencyChecker = new ConsistencyChecker(this.nativeStore, this.cosKey);
        } else {
            LOG.warn("The consistency checker is disabled.");
            this.consistencyChecker = null;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkOpened();
        if (this.currentPartBuffer == null) {
            this.initNewCurrentPartResource();
        }
        while (len > 0) {
            long writeBytes = this.currentPartWriteBytes + (long)len > this.partSize ? this.partSize - this.currentPartWriteBytes : (long)len;
            this.currentPartOutputStream.write(b, off, (int)writeBytes);
            this.dirty = true;
            this.committed = false;
            this.currentPartWriteBytes += writeBytes;
            if (null != this.consistencyChecker) {
                this.consistencyChecker.writeBytes(b, off, (int)writeBytes);
            }
            if (this.currentPartWriteBytes >= this.partSize) {
                this.currentPartOutputStream.flush();
                this.currentPartOutputStream.close();
                this.uploadCurrentPart(false);
                this.initNewCurrentPartResource();
            }
            len = (int)((long)len - writeBytes);
            off = (int)((long)off + writeBytes);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkOpened();
        byte[] singleBytes = new byte[]{(byte)b};
        this.write(singleBytes, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkOpened();
        if (!this.dirty) {
            LOG.debug("The stream is up-to-date, no need to refresh.");
            return;
        }
        if (null == this.currentPartBuffer) {
            this.initNewCurrentPartResource();
        }
        this.doFlush();
        this.dirty = false;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        LOG.info("Closing the output stream [{}].", (Object)this);
        try {
            this.flush();
            this.commit();
        }
        finally {
            this.closed = true;
            this.releaseCurrentPartResource();
            this.resetContext();
        }
    }

    @Override
    public synchronized void abort() throws IOException {
        if (this.closed) {
            return;
        }
        LOG.info("Aborting the output stream [{}].", (Object)this);
        try {
            if (null != this.multipartUpload) {
                this.multipartUpload.abort();
            }
        }
        finally {
            this.closed = true;
            this.releaseCurrentPartResource();
            this.resetContext();
        }
    }

    protected void commit() throws IOException {
        if (this.committed) {
            return;
        }
        if (this.currentPartNumber <= 1) {
            byte[] digestHash = this.currentPartMessageDigest == null ? null : this.currentPartMessageDigest.digest();
            BufferInputStream currentPartBufferInputStream = new BufferInputStream(this.currentPartBuffer);
            this.nativeStore.storeFile(this.cosKey, currentPartBufferInputStream, digestHash, this.currentPartBuffer.remaining());
        } else if (null != this.multipartUpload) {
            this.multipartUpload.complete();
        }
        this.committed = true;
        if (null != this.consistencyChecker) {
            this.consistencyChecker.finish();
            if (!this.consistencyChecker.getCheckResult().isSucceeded()) {
                String exceptionMsg = String.format("Failed to upload the key: %s, error message: %s.", this.cosKey, this.consistencyChecker.getCheckResult().getDescription());
                throw new IOException(exceptionMsg);
            }
            LOG.info("Upload the key [{}] successfully. check message: {}.", (Object)this.cosKey, (Object)this.consistencyChecker.getCheckResult().getDescription());
        } else {
            LOG.info("OutputStream for key [{}] upload complete. But it is not checked.", (Object)this.cosKey);
        }
    }

    protected void resetContext() throws IOException {
        if (null != this.multipartUpload && !this.multipartUpload.isCompleted() && !this.multipartUpload.isAborted()) {
            this.multipartUpload.abort();
        }
        if (null != this.currentPartOutputStream) {
            this.currentPartOutputStream.close();
        }
        if (null != this.currentPartBuffer) {
            BufferPool.getInstance().returnBuffer(this.currentPartBuffer);
        }
        this.multipartUpload = null;
        this.currentPartNumber = 0;
        this.currentPartBuffer = null;
        this.currentPartOutputStream = null;
        this.currentPartWriteBytes = 0L;
        this.dirty = true;
        this.committed = false;
        if (this.currentPartMessageDigest != null) {
            this.currentPartMessageDigest.reset();
        }
        if (this.consistencyChecker != null) {
            this.consistencyChecker.reset();
        }
    }

    protected void checkOpened() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    private void doFlush() throws IOException {
        this.currentPartOutputStream.flush();
        try {
            if (this.currentPartNumber > 1 && null != this.multipartUpload) {
                if (this.currentPartWriteBytes > 0L) {
                    this.uploadCurrentPart(true);
                }
                this.multipartUpload.waitForFinishPartUploads();
            }
        }
        finally {
            this.resumeCurrentPartMessageDigest();
            this.currentPartBuffer.flipWrite();
        }
    }

    protected void initNewCurrentPartResource() throws IOException {
        try {
            this.currentPartBuffer = BufferPool.getInstance().getBuffer((int)this.partSize);
            this.currentPartWriteBytes = 0L;
            ++this.currentPartNumber;
        }
        catch (InterruptedException e) {
            String exceptionMsg = String.format("Getting a buffer size:[%d] from the buffer pool occurs an exception.", this.partSize);
            throw new IOException(exceptionMsg);
        }
        if (null != this.currentPartMessageDigest) {
            this.currentPartMessageDigest.reset();
            this.currentPartOutputStream = new DigestOutputStream(new BufferOutputStream(this.currentPartBuffer), this.currentPartMessageDigest);
        } else {
            this.currentPartOutputStream = new BufferOutputStream(this.currentPartBuffer);
        }
    }

    protected void releaseCurrentPartResource() throws IOException {
        if (null != this.currentPartOutputStream) {
            try {
                this.currentPartOutputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Fail to close current part output stream.", (Throwable)e);
            }
            this.currentPartOutputStream = null;
        }
        if (null != this.currentPartMessageDigest) {
            this.currentPartMessageDigest.reset();
        }
        if (null != this.currentPartBuffer) {
            BufferPool.getInstance().returnBuffer(this.currentPartBuffer);
        }
        this.currentPartBuffer = null;
    }

    private void uploadCurrentPart(boolean isLastPart) throws IOException {
        if (null == this.multipartUpload) {
            this.multipartUpload = new MultipartUpload(this.cosKey);
        }
        byte[] digestHash = this.currentPartMessageDigest == null ? null : this.currentPartMessageDigest.digest();
        UploadPart uploadPart = new UploadPart(this.currentPartNumber, this.currentPartBuffer, digestHash, isLastPart);
        this.multipartUpload.uploadPartAsync(uploadPart);
    }

    private void resumeCurrentPartMessageDigest() throws IOException {
        if (null != this.currentPartMessageDigest) {
            this.currentPartMessageDigest.reset();
            DigestOutputStream tempOutputStream = new DigestOutputStream((OutputStream)new NullOutputStream(), this.currentPartMessageDigest);
            BufferInputStream tempInputStream = new BufferInputStream(this.currentPartBuffer);
            byte[] tempChunk = new byte[4096];
            int readBytes = tempInputStream.read(tempChunk);
            while (readBytes != -1) {
                ((OutputStream)tempOutputStream).write(tempChunk, 0, readBytes);
                readBytes = tempInputStream.read(tempChunk);
            }
        }
    }

    private static final class UploadPart {
        private final int partNumber;
        private final CosNByteBuffer cosNByteBuffer;
        private final byte[] md5Hash;
        private final boolean isLast;

        private UploadPart(int partNumber, CosNByteBuffer cosNByteBuffer, byte[] md5Hash, boolean isLast) {
            this.partNumber = partNumber;
            this.cosNByteBuffer = cosNByteBuffer;
            this.md5Hash = md5Hash;
            this.isLast = isLast;
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public CosNByteBuffer getCosNByteBuffer() {
            return this.cosNByteBuffer;
        }

        public long getPartSize() {
            return this.cosNByteBuffer.remaining();
        }

        public byte[] getMd5Hash() {
            return this.md5Hash;
        }

        public String toString() {
            return String.format("UploadPart{partNumber:%d, partSize: %d, md5Hash: %s, isLast: %s}", this.partNumber, this.cosNByteBuffer.flipRead().remaining(), this.md5Hash != null ? Hex.encodeHexString((byte[])this.md5Hash) : "NULL", this.isLast);
        }
    }

    protected class MultipartUpload {
        protected final String uploadId;
        protected final Map<Integer, ListenableFuture<PartETag>> partETagFutures;
        protected final AtomicInteger partsSubmitted;
        protected final AtomicInteger partsUploaded;
        protected final AtomicLong bytesSubmitted;
        protected final AtomicLong bytesUploaded;
        protected volatile boolean aborted;
        protected volatile boolean completed;

        protected MultipartUpload(String cosKey) throws IOException {
            this(cosKey, null);
        }

        protected MultipartUpload(String cosKey, String uploadId) throws IOException {
            this(cosKey, uploadId, null, 0, 0, 0L, 0L);
        }

        protected MultipartUpload(String cosKey, String uploadId, Map<Integer, ListenableFuture<PartETag>> partETagFutures, int partsSubmitted, int partsUploaded, long bytesSubmitted, long bytesUploaded) throws IOException {
            if (null == uploadId) {
                uploadId = CosNFSDataOutputStream.this.nativeStore.getUploadId(cosKey);
            }
            this.uploadId = uploadId;
            LOG.debug("Initial multi-part upload for the cos key [{}] with the upload id [{}].", (Object)cosKey, (Object)uploadId);
            this.partETagFutures = null == partETagFutures ? new HashMap<Integer, ListenableFuture<PartETag>>() : partETagFutures;
            this.partsSubmitted = new AtomicInteger(partsSubmitted);
            this.partsUploaded = new AtomicInteger(partsUploaded);
            this.bytesSubmitted = new AtomicLong(bytesSubmitted);
            this.bytesUploaded = new AtomicLong(bytesUploaded);
            this.aborted = false;
            this.completed = false;
        }

        protected String getUploadId() {
            return this.uploadId;
        }

        protected int getPartsUploaded() {
            return this.partsUploaded.get();
        }

        protected int getPartsSubmitted() {
            return this.partsSubmitted.get();
        }

        protected long getBytesSubmitted() {
            return this.bytesSubmitted.get();
        }

        protected long getBytesUploaded() {
            return this.bytesUploaded.get();
        }

        protected boolean isAborted() {
            return this.aborted;
        }

        protected boolean isCompleted() {
            return this.completed;
        }

        public String toString() {
            return "MultipartUpload{uploadId='" + this.uploadId + '\'' + ", partETagFutures=" + this.partETagFutures + ", partsSubmitted=" + this.partsSubmitted + ", partsUploaded=" + this.partsUploaded + ", bytesSubmitted=" + this.bytesSubmitted + ", bytesUploaded=" + this.bytesUploaded + ", aborted=" + this.aborted + ", completed=" + this.completed + '}';
        }

        protected void uploadPartAsync(final UploadPart uploadPart) throws IOException {
            if (this.isCompleted() || this.isAborted()) {
                throw new IOException(String.format("The MPU [%s] has been closed or aborted. Can not execute the upload operation.", this));
            }
            this.partsSubmitted.incrementAndGet();
            this.bytesSubmitted.addAndGet(uploadPart.getPartSize());
            ListenableFuture partETagListenableFuture = CosNFSDataOutputStream.this.executorService.submit((Callable)new Callable<PartETag>(){
                private final String localKey;
                private final String localUploadId;
                {
                    this.localKey = CosNFSDataOutputStream.this.cosKey;
                    this.localUploadId = MultipartUpload.this.uploadId;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PartETag call() throws Exception {
                    Thread currentThread = Thread.currentThread();
                    LOG.debug("flush task, current classLoader: {}, context ClassLoader: {}", (Object)this.getClass().getClassLoader(), (Object)currentThread.getContextClassLoader());
                    currentThread.setContextClassLoader(this.getClass().getClassLoader());
                    try {
                        LOG.info("Start to upload the part: {}", (Object)uploadPart);
                        PartETag partETag = CosNFSDataOutputStream.this.nativeStore.uploadPart(new BufferInputStream(uploadPart.getCosNByteBuffer()), this.localKey, this.localUploadId, uploadPart.getPartNumber(), uploadPart.getPartSize(), uploadPart.getMd5Hash());
                        MultipartUpload.this.partsUploaded.incrementAndGet();
                        MultipartUpload.this.bytesUploaded.addAndGet(uploadPart.getPartSize());
                        PartETag partETag2 = partETag;
                        return partETag2;
                    }
                    finally {
                        if (!uploadPart.isLast) {
                            BufferPool.getInstance().returnBuffer(uploadPart.getCosNByteBuffer());
                        }
                    }
                }
            });
            this.partETagFutures.put(uploadPart.partNumber, (ListenableFuture<PartETag>)partETagListenableFuture);
        }

        protected List<PartETag> waitForFinishPartUploads() throws IOException {
            try {
                LOG.info("Waiting for finish part uploads...");
                return (List)Futures.allAsList(this.partETagFutures.values()).get();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupt the part upload...", (Throwable)e);
                return null;
            }
            catch (ExecutionException e) {
                LOG.error("Cancelling futures...", (Throwable)e);
                for (ListenableFuture<PartETag> future : this.partETagFutures.values()) {
                    future.cancel(true);
                }
                CosNFSDataOutputStream.this.nativeStore.abortMultipartUpload(CosNFSDataOutputStream.this.cosKey, this.uploadId);
                String exceptionMsg = String.format("multipart upload with id: %s to %s.", this.uploadId, CosNFSDataOutputStream.this.cosKey);
                throw new IOException(exceptionMsg);
            }
        }

        protected void complete() throws IOException {
            LOG.info("Completing the MPU [{}].", (Object)this.getUploadId());
            if (this.isCompleted() || this.isAborted()) {
                throw new IOException(String.format("fail to complete the MPU [%s]. It has been completed or aborted.", this));
            }
            List<PartETag> futurePartETagList = this.waitForFinishPartUploads();
            if (null == futurePartETagList) {
                throw new IOException("failed to multipart upload to cos, abort it.");
            }
            CompleteMultipartUploadResult completeResult = CosNFSDataOutputStream.this.nativeStore.completeMultipartUpload(CosNFSDataOutputStream.this.cosKey, this.uploadId, new LinkedList<PartETag>(futurePartETagList));
            this.completed = true;
            LOG.info("The MPU [{}] has been completed.", (Object)this.getUploadId());
        }

        protected void abort() throws IOException {
            LOG.info("Aborting the MPU [{}].", (Object)this.getUploadId());
            if (this.isCompleted() || this.isAborted()) {
                throw new IOException(String.format("fail to abort the MPU [%s]. It has been completed or aborted.", this.getUploadId()));
            }
            CosNFSDataOutputStream.this.nativeStore.abortMultipartUpload(CosNFSDataOutputStream.this.cosKey, this.uploadId);
            this.aborted = true;
            LOG.info("The MPU [{}] has been aborted.", (Object)this.getUploadId());
        }
    }
}

