/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNFSInputStream;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNFileReadTask
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(CosNFileReadTask.class);
    private final Configuration conf;
    private final String key;
    private final NativeFileSystemStore store;
    private final CosNFSInputStream.ReadBuffer readBuffer;
    private final int socketErrMaxRetryTimes;

    public CosNFileReadTask(Configuration conf, String key, NativeFileSystemStore store, CosNFSInputStream.ReadBuffer readBuffer, int socketErrMaxRetryTimes) {
        this.conf = conf;
        this.key = key;
        this.store = store;
        this.readBuffer = readBuffer;
        this.socketErrMaxRetryTimes = socketErrMaxRetryTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        LOG.debug("flush task, current classLoader: {}, context ClassLoader: {}", (Object)this.getClass().getClassLoader(), (Object)currentThread.getContextClassLoader());
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.readBuffer.lock();
            int retryIndex = 1;
            boolean needRetry = false;
            do {
                try {
                    this.retrieveBlock();
                    needRetry = false;
                }
                catch (IOException ioException) {
                    String errMsg = String.format("retrieve block sdk socket failed, retryIndex: [%d / %d], key: %s, range: [%d , %d], exception: %s", retryIndex, this.socketErrMaxRetryTimes, this.key, this.readBuffer.getStart(), this.readBuffer.getEnd(), ioException.toString());
                    if (retryIndex <= this.socketErrMaxRetryTimes) {
                        LOG.info(errMsg, (Throwable)ioException);
                        long sleepLeast = (long)retryIndex * 300L;
                        long sleepBound = (long)retryIndex * 500L;
                        try {
                            Thread.sleep(ThreadLocalRandom.current().nextLong(sleepLeast, sleepBound));
                            ++retryIndex;
                            needRetry = true;
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            this.setFailResult(errMsg, new IOException(interruptedException.toString()));
                            break;
                        }
                    }
                    this.setFailResult(errMsg, ioException);
                    break;
                }
            } while (needRetry);
            this.readBuffer.signalAll();
        }
        finally {
            this.readBuffer.unLock();
        }
    }

    public void setFailResult(String msg, IOException e) {
        this.readBuffer.setStatus(-1);
        this.readBuffer.setException(e);
        LOG.error(msg);
    }

    public void retrieveBlock() throws IOException {
        InputStream inputStream = this.store.retrieveBlock(this.key, this.readBuffer.getStart(), this.readBuffer.getEnd());
        IOUtils.readFully((InputStream)inputStream, (byte[])this.readBuffer.getBuffer(), (int)0, (int)this.readBuffer.getBuffer().length);
        int readEof = inputStream.read();
        if (readEof != -1) {
            LOG.error("Expect to read the eof, but the return is not -1. key: {}.", (Object)this.key);
        }
        inputStream.close();
        this.readBuffer.setStatus(0);
    }
}

