/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.util.concurrent.ListenableFuture;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.utils.CRC64;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ConsistencyChecker;
import org.apache.hadoop.fs.CosNFSDataOutputStream;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNPosixExtensionDataOutputStream
extends CosNFSDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CosNPosixExtensionDataOutputStream.class);

    public CosNPosixExtensionDataOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String cosKey, ExecutorService executorService) throws IOException {
        this(conf, nativeStore, cosKey, executorService, false);
    }

    public CosNPosixExtensionDataOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String cosKey, ExecutorService executorService, boolean appendFlag) throws IOException {
        super(conf, nativeStore, cosKey, executorService);
        if (appendFlag) {
            this.resumeForWrite();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.committed) {
            this.resumeForWrite();
        }
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.committed) {
            this.resumeForWrite();
        }
        super.write(b);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        super.commit();
    }

    private void resumeForWrite() throws IOException {
        block33: {
            super.resetContext();
            super.initNewCurrentPartResource();
            FileMetadata fileMetadata = this.nativeStore.retrieveMetadata(this.cosKey);
            if (null == fileMetadata) {
                throw new IOException(String.format("The cos key [%s] is not found.", this.cosKey));
            }
            if (!fileMetadata.isFile()) {
                throw new IOException("The cos key is a directory object. Can not resume the write operation for it.");
            }
            try {
                long copyRemaining;
                if (fileMetadata.getLength() < this.partSize) {
                    try (InputStream inputStream = this.nativeStore.retrieve(this.cosKey);){
                        byte[] chunk = new byte[4096];
                        int readBytes = inputStream.read(chunk);
                        while (readBytes != -1) {
                            super.write(chunk, 0, readBytes);
                            readBytes = inputStream.read(chunk);
                        }
                        break block33;
                    }
                }
                this.multipartUpload = new MultipartUploadEx(this.cosKey);
                long firstByte = 0L;
                long lastByte = firstByte + this.partSize - 1L;
                for (copyRemaining = fileMetadata.getLength(); copyRemaining >= this.partSize; copyRemaining -= lastByte - firstByte + 1L) {
                    UploadPartCopy uploadPartCopy = new UploadPartCopy(this.cosKey, this.cosKey, this.currentPartNumber++, firstByte, lastByte);
                    ((MultipartUploadEx)this.multipartUpload).uploadPartCopyAsync(uploadPartCopy);
                    firstByte = lastByte + 1L;
                    lastByte = firstByte + this.partSize - 1L;
                }
                if (copyRemaining > 0L) {
                    lastByte = firstByte + copyRemaining - 1L;
                    try (InputStream inputStream = this.nativeStore.retrieveBlock(this.cosKey, firstByte, lastByte);){
                        byte[] chunk = new byte[4096];
                        int readBytes = inputStream.read(chunk);
                        while (readBytes != -1) {
                            super.write(chunk, 0, readBytes);
                            readBytes = inputStream.read(chunk);
                        }
                    }
                }
                BigInteger bigInteger = new BigInteger(fileMetadata.getCrc64ecm());
                this.consistencyChecker = new ConsistencyChecker(this.nativeStore, this.cosKey, new CRC64(bigInteger.longValue()), fileMetadata.getLength());
            }
            catch (Exception e) {
                LOG.error("Fail to resume for writing. Abort it.", (Throwable)e);
                super.abort();
                throw new IOException(e);
            }
        }
    }

    private static final class UploadPartCopy {
        private final String srcKey;
        private final String destKey;
        private final int partNumber;
        private final long firstByte;
        private final long lastByte;

        private UploadPartCopy(String srcKey, String destKey, int partNumber, long firstByte, long lastByte) {
            this.srcKey = srcKey;
            this.destKey = destKey;
            this.partNumber = partNumber;
            this.firstByte = firstByte;
            this.lastByte = lastByte;
        }

        public String getSrcKey() {
            return this.srcKey;
        }

        public String getDestKey() {
            return this.destKey;
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public long getFirstByte() {
            return this.firstByte;
        }

        public long getLastByte() {
            return this.lastByte;
        }

        public String toString() {
            return "UploadPartCopy{srcKey='" + this.srcKey + '\'' + ", partNumber=" + this.partNumber + ", firstByte=" + this.firstByte + ", lastByte=" + this.lastByte + '}';
        }
    }

    protected class MultipartUploadEx
    extends CosNFSDataOutputStream.MultipartUpload {
        protected MultipartUploadEx(String cosKey) throws IOException {
            this(cosKey, null);
        }

        protected MultipartUploadEx(String cosKey, String uploadId) throws IOException {
            super(cosKey, uploadId);
        }

        protected void uploadPartCopyAsync(final UploadPartCopy uploadPartCopy) throws IOException {
            if (super.isCompleted() || super.isAborted()) {
                throw new IOException(String.format("The MPU [%s] has been closed or aborted. Can not execute the upload part copy operation.", this));
            }
            this.partsSubmitted.incrementAndGet();
            this.bytesSubmitted.addAndGet(uploadPartCopy.lastByte - uploadPartCopy.firstByte + 1L);
            ListenableFuture partETagListenableFuture = CosNPosixExtensionDataOutputStream.this.executorService.submit((Callable)new Callable<PartETag>(){

                @Override
                public PartETag call() throws Exception {
                    LOG.info("Start to copy the part: {}.", (Object)uploadPartCopy);
                    PartETag partETag = CosNPosixExtensionDataOutputStream.this.nativeStore.uploadPartCopy(MultipartUploadEx.this.getUploadId(), uploadPartCopy.getSrcKey(), uploadPartCopy.getDestKey(), uploadPartCopy.getPartNumber(), uploadPartCopy.getFirstByte(), uploadPartCopy.getLastByte());
                    MultipartUploadEx.this.partsUploaded.incrementAndGet();
                    MultipartUploadEx.this.bytesUploaded.addAndGet(uploadPartCopy.getLastByte() - uploadPartCopy.getFirstByte() + 1L);
                    return partETag;
                }
            });
            this.partETagFutures.put(uploadPartCopy.getPartNumber(), (ListenableFuture<PartETag>)partETagListenableFuture);
        }
    }
}

