/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNUtils;
import org.apache.hadoop.fs.RangerCredentialsClient;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;
import org.apache.hadoop.fs.cosn.ranger.security.sts.GetSTSResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerCredentialsProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(RangerCredentialsProvider.class);
    private RangerCredentialsFetcher rangerCredentialsFetcher;
    private String bucketNameWithoutAppid;
    private String bucketRegion;
    private String appId;

    public RangerCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.appId = conf.get("fs.cosn.userinfo.appid");
            this.bucketNameWithoutAppid = CosNUtils.getBucketNameWithoutAppid(uri.getHost(), conf.get("fs.cosn.userinfo.appid"));
            this.bucketRegion = conf.get("fs.cosn.bucket.region");
            if (this.bucketRegion == null || this.bucketRegion.isEmpty()) {
                this.bucketRegion = conf.get("fs.cosn.userinfo.region");
            }
            this.rangerCredentialsFetcher = new RangerCredentialsFetcher(conf.getInt("fs.cosn.ranger.temp.token.refresh.interval", 20));
        }
    }

    public COSCredentials getCredentials() {
        return this.rangerCredentialsFetcher.getCredentials();
    }

    public void refresh() {
    }

    class RangerCredentialsFetcher {
        private int refreshIntervalSeconds;
        private AtomicReference<COSCredentials> lastCredentialsRef;
        private AtomicLong lastGetCredentialsTimeStamp;

        RangerCredentialsFetcher(int refreshIntervalSeconds) {
            this.refreshIntervalSeconds = refreshIntervalSeconds;
            this.lastCredentialsRef = new AtomicReference();
            this.lastGetCredentialsTimeStamp = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        COSCredentials getCredentials() {
            if (this.needSyncFetchNewCredentials()) {
                RangerCredentialsFetcher rangerCredentialsFetcher = this;
                synchronized (rangerCredentialsFetcher) {
                    if (this.needSyncFetchNewCredentials()) {
                        return this.fetchNewCredentials();
                    }
                }
            }
            return this.lastCredentialsRef.get();
        }

        private boolean needSyncFetchNewCredentials() {
            if (this.lastCredentialsRef.get() == null) {
                return true;
            }
            long currentSec = System.currentTimeMillis() / 1000L;
            return currentSec - this.lastGetCredentialsTimeStamp.get() > (long)this.refreshIntervalSeconds;
        }

        private COSCredentials fetchNewCredentials() {
            try {
                GetSTSResponse stsResp = RangerCredentialsClient.rangerQcloudObjectStorageStorageClient.getSTS(RangerCredentialsProvider.this.bucketRegion, RangerCredentialsProvider.this.bucketNameWithoutAppid);
                if (!stsResp.isCheckAuthPass()) {
                    return null;
                }
                BasicSessionCredentials cosCredentials = null;
                cosCredentials = RangerCredentialsProvider.this.appId != null ? new BasicSessionCredentials(RangerCredentialsProvider.this.appId, stsResp.getTempAK(), stsResp.getTempSK(), stsResp.getTempToken()) : new BasicSessionCredentials(stsResp.getTempAK(), stsResp.getTempSK(), stsResp.getTempToken());
                this.lastCredentialsRef.set((COSCredentials)cosCredentials);
                this.lastGetCredentialsTimeStamp.set(System.currentTimeMillis() / 1000L);
                return cosCredentials;
            }
            catch (IOException e) {
                log.error("fetch credentials failed", (Throwable)e);
                return null;
            }
        }
    }
}

