/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;

public class SimpleCredentialProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private String appId;
    private String secretId;
    private String secretKey;

    public SimpleCredentialProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.appId = conf.get("fs.cosn.userinfo.appid");
            this.secretId = conf.get("fs.cosn.userinfo.secretId");
            this.secretKey = conf.get("fs.cosn.userinfo.secretKey");
        }
    }

    public COSCredentials getCredentials() {
        if (!StringUtils.isNullOrEmpty((String)this.secretId) && !StringUtils.isNullOrEmpty((String)this.secretKey)) {
            if (null != this.appId) {
                return new BasicCOSCredentials(this.appId, this.secretId, this.secretKey);
            }
            return new BasicCOSCredentials(this.secretId, this.secretKey);
        }
        return null;
    }

    public void refresh() {
    }
}

