/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsFetcher;
import com.qcloud.cos.auth.InstanceCredentialsProvider;
import com.qcloud.cos.auth.InstanceMetadataCredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceProfileCredentials;
import com.qcloud.cos.exception.CosClientException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;
import org.apache.hadoop.fs.auth.CVMInstanceCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDefinedCredentialsProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CVMInstanceCredentialsProvider.class);
    private final String appId;
    private final COSCredentialsProvider cosCredentialsProvider;

    public CustomDefinedCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (conf == null) {
            throw new IllegalArgumentException("Configuration is null. Please check the core-site.xml.");
        }
        this.appId = conf.get("fs.cosn.userinfo.appid");
        final String providerUrl = conf.get("fs.cosn.custom-credential-provider.url");
        if (providerUrl == null) {
            throw new IllegalArgumentException("fs.cosn.remote-credential-provider.url should not be null.");
        }
        InstanceMetadataCredentialsEndpointProvider endpointProvider = new InstanceMetadataCredentialsEndpointProvider(null){

            public URI getCredentialsEndpoint() throws URISyntaxException {
                return new URI(providerUrl);
            }
        };
        InstanceCredentialsFetcher instanceCredentialsFetcher = new InstanceCredentialsFetcher((CredentialsEndpointProvider)endpointProvider);
        this.cosCredentialsProvider = new InstanceCredentialsProvider(instanceCredentialsFetcher);
        this.getCredentials();
    }

    public COSCredentials getCredentials() {
        try {
            COSCredentials cosCredentials = this.cosCredentialsProvider.getCredentials();
            if (null != this.appId && cosCredentials instanceof InstanceProfileCredentials) {
                return new InstanceProfileCredentials(this.appId, cosCredentials.getCOSAccessKeyId(), cosCredentials.getCOSSecretKey(), ((InstanceProfileCredentials)cosCredentials).getSessionToken(), ((InstanceProfileCredentials)cosCredentials).getExpiredTime());
            }
            return cosCredentials;
        }
        catch (CosClientException e) {
            LOG.error("Failed to obtain the credentials from CustomDefinedCredentialsProvider.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("getCredentials failed", (Throwable)e);
        }
        return null;
    }

    public void refresh() {
        this.cosCredentialsProvider.refresh();
    }
}

