/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.util.concurrent.ListenableFuture;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.utils.CRC64;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ConsistencyChecker;
import org.apache.hadoop.fs.CosNFSDataOutputStream;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.cosn.multipart.upload.UploadPartCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNExtendedFSDataOutputStream
extends CosNFSDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CosNExtendedFSDataOutputStream.class);

    public CosNExtendedFSDataOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String cosKey, ExecutorService executorService) throws IOException {
        this(conf, nativeStore, cosKey, executorService, false);
    }

    public CosNExtendedFSDataOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String cosKey, ExecutorService executorService, boolean appendFlag) throws IOException {
        super(conf, nativeStore, cosKey, executorService);
        if (appendFlag) {
            this.resumeForWrite();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.committed) {
            this.resumeForWrite();
        }
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.committed) {
            this.resumeForWrite();
        }
        super.write(b);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        super.commit();
    }

    private void resumeForWrite() throws IOException {
        block33: {
            FileMetadata fileMetadata = this.nativeStore.retrieveMetadata(this.cosKey);
            if (null == fileMetadata) {
                throw new IOException(String.format("The cos key [%s] is not found.", this.cosKey));
            }
            if (!fileMetadata.isFile()) {
                throw new IOException("The cos key is a directory object. Can not resume the write operation for it.");
            }
            super.resetContext();
            super.initNewCurrentPartResource();
            try {
                long copyRemaining;
                if (fileMetadata.getLength() < this.partSize) {
                    try (InputStream inputStream = this.nativeStore.retrieve(this.cosKey);){
                        byte[] chunk = new byte[4096];
                        int readBytes = inputStream.read(chunk);
                        while (readBytes != -1) {
                            super.write(chunk, 0, readBytes);
                            readBytes = inputStream.read(chunk);
                        }
                        break block33;
                    }
                }
                this.multipartUpload = new MultipartUploadEx(this.cosKey);
                long firstByte = 0L;
                long lastByte = firstByte + this.partSize - 1L;
                for (copyRemaining = fileMetadata.getLength(); copyRemaining >= this.partSize; copyRemaining -= lastByte - firstByte + 1L) {
                    UploadPartCopy uploadPartCopy = new UploadPartCopy(this.cosKey, this.cosKey, this.currentPartNumber++, firstByte, lastByte);
                    ((MultipartUploadEx)this.multipartUpload).uploadPartCopyAsync(uploadPartCopy);
                    firstByte = lastByte + 1L;
                    lastByte = firstByte + this.partSize - 1L;
                }
                if (copyRemaining > 0L) {
                    lastByte = firstByte + copyRemaining - 1L;
                    try (InputStream inputStream = this.nativeStore.retrieveBlock(this.cosKey, firstByte, lastByte);){
                        byte[] chunk = new byte[4096];
                        int readBytes = inputStream.read(chunk);
                        while (readBytes != -1) {
                            super.write(chunk, 0, readBytes);
                            readBytes = inputStream.read(chunk);
                        }
                    }
                }
                BigInteger bigInteger = new BigInteger(fileMetadata.getCrc64ecm());
                this.consistencyChecker = new ConsistencyChecker(this.nativeStore, this.cosKey, new CRC64(bigInteger.longValue()), fileMetadata.getLength(), this.clientEncryptionEnabled);
            }
            catch (Exception e) {
                LOG.error("Failed to resume for writing. Abort it.", (Throwable)e);
                super.doAbort();
                throw new IOException(e);
            }
        }
    }

    protected class MultipartUploadEx
    extends CosNFSDataOutputStream.MultipartUpload {
        protected MultipartUploadEx(String cosKey) throws IOException {
            this(cosKey, null);
        }

        protected MultipartUploadEx(String cosKey, String uploadId) throws IOException {
            super(CosNExtendedFSDataOutputStream.this, cosKey, uploadId);
        }

        protected void uploadPartCopyAsync(final UploadPartCopy uploadPartCopy) throws IOException {
            if (super.isCompleted() || super.isAborted()) {
                throw new IOException(String.format("The MPU [%s] has been closed or aborted. Can not execute the upload part copy operation.", this));
            }
            this.partsSubmitted.incrementAndGet();
            this.bytesSubmitted.addAndGet(uploadPartCopy.getLastByte() - uploadPartCopy.getFirstByte() + 1L);
            ListenableFuture partETagListenableFuture = CosNExtendedFSDataOutputStream.this.executorService.submit((Callable)new Callable<PartETag>(){

                @Override
                public PartETag call() throws Exception {
                    LOG.info("Start to copy the part: {}.", (Object)uploadPartCopy);
                    PartETag partETag = CosNExtendedFSDataOutputStream.this.nativeStore.uploadPartCopy(MultipartUploadEx.this.getUploadId(), uploadPartCopy.getSrcKey(), uploadPartCopy.getDestKey(), uploadPartCopy.getPartNumber(), uploadPartCopy.getFirstByte(), uploadPartCopy.getLastByte());
                    MultipartUploadEx.this.partsUploaded.incrementAndGet();
                    MultipartUploadEx.this.bytesUploaded.addAndGet(uploadPartCopy.getLastByte() - uploadPartCopy.getFirstByte() + 1L);
                    return partETag;
                }
            });
            this.partETagFutures.put(uploadPartCopy.getPartNumber(), (ListenableFuture<PartETag>)partETagListenableFuture);
        }
    }
}

