/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.chdfs.PosixSeekable;
import org.apache.hadoop.fs.cosn.Abortable;
import org.apache.hadoop.fs.cosn.multipart.upload.MultipartManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNSeekableFSDataOutputStream
extends FSDataOutputStream
implements PosixSeekable,
Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(CosNSeekableFSDataOutputStream.class);
    private final SeekableOutputStream seekableOutputStream;

    public CosNSeekableFSDataOutputStream(SeekableOutputStream seekableOutputStream, FileSystem.Statistics stats) throws IOException {
        super((OutputStream)seekableOutputStream, stats);
        this.seekableOutputStream = seekableOutputStream;
    }

    public synchronized int ftruncate(long length) throws IOException {
        try {
            return this.seekableOutputStream.ftruncate(length);
        }
        catch (IOException ioException) {
            LOG.error("Failed to truncate the outputStream to length [{}].", (Object)length);
            return -1;
        }
    }

    public synchronized void seek(long pos) throws IOException {
        this.seekableOutputStream.seek(pos);
    }

    public synchronized boolean seekToNewSource(long pos) throws IOException {
        return this.seekableOutputStream.seekToNewSource(pos);
    }

    @Override
    public synchronized void doAbort() {
        this.seekableOutputStream.doAbort();
    }

    public synchronized long getPos() {
        return this.seekableOutputStream.getPos();
    }

    public static class SeekableOutputStream
    extends OutputStream
    implements PosixSeekable,
    Abortable {
        private final NativeFileSystemStore nativeStore;
        private final String cosKey;
        private final MultipartManager multipartManager;
        private long pos;
        private boolean dirty;
        private boolean committed;
        private boolean closed;

        public SeekableOutputStream(Configuration conf, NativeFileSystemStore nativeStore, String cosKey, ExecutorService executorService) throws IOException {
            Preconditions.checkNotNull((Object)conf, (Object)"hadoop configuration");
            this.nativeStore = (NativeFileSystemStore)Preconditions.checkNotNull((Object)nativeStore, (Object)"nativeStore");
            this.cosKey = (String)Preconditions.checkNotNull((Object)cosKey, (Object)"cosKey");
            long partSize = conf.getLong("fs.cosn.upload.part.size", 0x800000L);
            if (partSize < 0x100000L) {
                LOG.warn("The minimum size of a single block is limited to greater than or equal to {}.", (Object)0x100000L);
            } else if (partSize > 0x80000000L) {
                LOG.warn("The maximum size of a single block is limited to smaller than or equal to {}.", (Object)0x80000000L);
                partSize = 0x80000000L;
            }
            this.multipartManager = new MultipartManager(this.nativeStore, this.cosKey, partSize, executorService);
            this.multipartManager.resumeForWrite();
            this.pos = this.multipartManager.getCurrentSize();
            this.dirty = false;
            this.committed = false;
            this.closed = false;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.checkOpened();
            byte[] singleBytes = new byte[]{(byte)b};
            this.write(singleBytes);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.checkOpened();
            if (this.committed) {
                this.multipartManager.resumeForWrite();
                this.committed = false;
            }
            while (len > 0) {
                int partIndex = (int)(this.pos / this.multipartManager.getPartSize());
                int partOffset = (int)(this.pos % this.multipartManager.getPartSize());
                MultipartManager.LocalPart part = this.multipartManager.getPart(partIndex + 1);
                part.getBuffer().flipWrite();
                part.getBuffer().position(partOffset);
                int writeBytes = Math.min(part.getBuffer().remaining(), len);
                part.getBuffer().put(b, off, writeBytes);
                part.setDirty(true);
                len -= writeBytes;
                off += writeBytes;
                this.pos += (long)writeBytes;
                this.dirty = true;
            }
        }

        public synchronized int ftruncate(long newLen) throws IOException {
            this.checkOpened();
            Preconditions.checkArgument((newLen >= 0L && newLen < this.multipartManager.getMaxFileSizeLimit() ? 1 : 0) != 0, (Object)String.format("The new length must be a non-negative integer and less than the max file limit [%d].", this.multipartManager.getMaxFileSizeLimit()));
            LOG.info("Call the ftruncate({}) on the cos key [{}].", (Object)newLen, (Object)this.cosKey);
            this.flush();
            this.multipartManager.splitParts(newLen);
            this.dirty = true;
            this.committed = false;
            return 0;
        }

        public synchronized void seek(long pos) throws IOException {
            this.checkOpened();
            Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (Object)"The new position must be a non-negative integer.");
            Preconditions.checkArgument((pos < this.multipartManager.getMaxFileSizeLimit() ? 1 : 0) != 0, (Object)String.format("The seek position [%d] exceeds the maximum file limit [%d].", pos, this.multipartManager.getMaxFileSizeLimit()));
            LOG.info("Call the output seek({}) on the cos key [{}].", (Object)pos, (Object)this.cosKey);
            this.pos = pos;
        }

        public synchronized long getPos() {
            return this.pos;
        }

        public synchronized boolean seekToNewSource(long l) throws IOException {
            this.checkOpened();
            return false;
        }

        @Override
        public synchronized void doAbort() {
            if (this.closed) {
                return;
            }
            LOG.info("Aborting the output stream [{}].", (Object)this);
            try {
                if (null != this.multipartManager) {
                    this.multipartManager.abort();
                }
            }
            finally {
                this.closed = true;
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            this.checkOpened();
            if (!this.dirty) {
                return;
            }
            this.commit();
            this.dirty = false;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            LOG.info("Closing the outputStream [{}].", (Object)this);
            try {
                this.flush();
                this.multipartManager.close();
            }
            finally {
                this.closed = true;
            }
        }

        private void commit() throws IOException {
            if (this.committed) {
                return;
            }
            this.multipartManager.commitLocalToRemote();
            this.committed = true;
        }

        private void checkOpened() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
        }
    }
}

