/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import com.qcloud.cos.auth.COSCredentialsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNativeFileSystemStore;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.RangerCredentialsClient;
import org.apache.hadoop.fs.auth.COSCredentialProviderList;
import org.apache.hadoop.fs.auth.CPMInstanceCredentialsProvider;
import org.apache.hadoop.fs.auth.CVMInstanceCredentialsProvider;
import org.apache.hadoop.fs.auth.EMRInstanceCredentialsProvider;
import org.apache.hadoop.fs.auth.EnvironmentVariableCredentialProvider;
import org.apache.hadoop.fs.auth.SessionCredentialProvider;
import org.apache.hadoop.fs.auth.SessionTokenCredentialProvider;
import org.apache.hadoop.fs.auth.SimpleCredentialProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosNUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CosNUtils.class);
    static final String INSTANTIATION_EXCEPTION = "instantiation exception";
    static final String NOT_COS_CREDENTIAL_PROVIDER = "is not cos credential provider";
    static final String ABSTRACT_CREDENTIAL_PROVIDER = "is abstract and therefore cannot be created";

    private CosNUtils() {
    }

    public static NativeFileSystemStore createDefaultStore(Configuration conf) {
        CosNativeFileSystemStore store = new CosNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.cosn.maxRetries", 200), (long)conf.getLong("fs.cosn.retry.interval.seconds", 3L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<IOException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<IOException>, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap methodNameToPolicyMap = new HashMap();
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, methodNameToPolicyMap);
    }

    public static COSCredentialProviderList createCosCredentialsProviderSet(URI uri, Configuration conf, RangerCredentialsClient rangerClient) throws IOException {
        COSCredentialProviderList credentialProviderList = new COSCredentialProviderList();
        Class<?>[] cosClasses = CosNUtils.loadCosProviderClasses(conf, "fs.cosn.credentials.provider", new Class[0]);
        if (0 == cosClasses.length) {
            credentialProviderList.add(new SessionCredentialProvider(uri, conf));
            credentialProviderList.add(new SimpleCredentialProvider(uri, conf));
            credentialProviderList.add(new EnvironmentVariableCredentialProvider(uri, conf));
            credentialProviderList.add(new SessionTokenCredentialProvider(uri, conf));
            credentialProviderList.add(new CVMInstanceCredentialsProvider(uri, conf));
            credentialProviderList.add(new CPMInstanceCredentialsProvider(uri, conf));
            credentialProviderList.add(new EMRInstanceCredentialsProvider(uri, conf));
        } else {
            for (Class<?> credClass : cosClasses) {
                credentialProviderList.add(CosNUtils.createCOSCredentialProvider(uri, conf, rangerClient, credClass));
            }
        }
        return credentialProviderList;
    }

    public static Class<?>[] loadCosProviderClasses(Configuration conf, String key, Class<?> ... defaultValue) throws IOException {
        try {
            return conf.getClasses(key, (Class[])defaultValue);
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option " + key + ' ' + c, c);
        }
    }

    public static COSCredentialsProvider createCOSCredentialProvider(URI uri, Configuration conf, RangerCredentialsClient rangerClient, Class<?> credClass) throws IOException {
        if (!COSCredentialsProvider.class.isAssignableFrom(credClass)) {
            throw new IllegalArgumentException("class " + credClass + " " + NOT_COS_CREDENTIAL_PROVIDER);
        }
        if (Modifier.isAbstract(credClass.getModifiers())) {
            throw new IllegalArgumentException("class " + credClass + " " + ABSTRACT_CREDENTIAL_PROVIDER);
        }
        LOG.debug("Credential Provider class: " + credClass.getName());
        try {
            Constructor<?> constructor = CosNUtils.getConstructor(credClass, new Class[0]);
            if (constructor != null) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(new Object[0]);
                return credentialsProvider;
            }
            constructor = CosNUtils.getConstructor(credClass, Configuration.class);
            if (null != constructor) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(conf);
                return credentialsProvider;
            }
            constructor = CosNUtils.getConstructor(credClass, URI.class, Configuration.class);
            if (null != constructor) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(uri, conf);
                return credentialsProvider;
            }
            constructor = CosNUtils.getConstructor(credClass, URI.class, Configuration.class, RangerCredentialsClient.class);
            if (null != constructor) {
                LOG.info("success get constructor of ranger provider");
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(uri, conf, rangerClient);
                return credentialsProvider;
            }
            Method factory = CosNUtils.getFactoryMethod(credClass, COSCredentialsProvider.class, "getInstance");
            if (null != factory) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)factory.invoke(null, new Object[0]);
                return credentialsProvider;
            }
            throw new IllegalArgumentException("Not supported constructor or factory method found");
        }
        catch (IllegalAccessException e) {
            throw new IOException(credClass.getName() + " " + INSTANTIATION_EXCEPTION + ": " + e, e);
        }
        catch (InstantiationException e) {
            throw new IOException(credClass.getName() + " " + INSTANTIATION_EXCEPTION + ": " + e, e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException == null) {
                targetException = e;
            }
            throw new IOException(credClass.getName() + " " + INSTANTIATION_EXCEPTION + ": " + targetException, targetException);
        }
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?> ... args) {
        try {
            Constructor<?> constructor = cl.getDeclaredConstructor(args);
            return Modifier.isPublic(constructor.getModifiers()) ? constructor : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getFactoryMethod(Class<?> cl, Class<?> returnType, String methodName) {
        try {
            Method m = cl.getDeclaredMethod(methodName, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && returnType.isAssignableFrom(m.getReturnType())) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String getBucketNameWithoutAppid(String originBucketName, String appidStr) {
        if (appidStr == null || appidStr.isEmpty()) {
            return originBucketName;
        }
        if (originBucketName.endsWith("-" + appidStr)) {
            return originBucketName;
        }
        return originBucketName + "-" + appidStr;
    }

    public static KeyPair loadAsymKeyPair(String pubKeyPath, String priKeyPath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File filePublicKey = new File(pubKeyPath);
        FileInputStream fis = new FileInputStream(filePublicKey);
        byte[] encodedPublicKey = new byte[(int)filePublicKey.length()];
        fis.read(encodedPublicKey);
        fis.close();
        File filePrivateKey = new File(priKeyPath);
        fis = new FileInputStream(filePrivateKey);
        byte[] encodedPrivateKey = new byte[(int)filePrivateKey.length()];
        fis.read(encodedPrivateKey);
        fis.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    public static void buildAndSaveAsymKeyPair(String pubKeyPath, String priKeyPath) throws IOException, NoSuchAlgorithmException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom srand = new SecureRandom();
        keyGenerator.initialize(1024, srand);
        KeyPair keyPair = keyGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        FileOutputStream fos = new FileOutputStream(pubKeyPath);
        fos.write(x509EncodedKeySpec.getEncoded());
        fos.close();
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        fos = new FileOutputStream(priKeyPath);
        fos.write(pkcs8EncodedKeySpec.getEncoded());
        fos.close();
    }

    public static Configuration propagateBucketOptions(Configuration source, String bucket) {
        if (null == bucket || 0 == bucket.length()) {
            Preconditions.checkArgument((boolean)false, (Object)"bucket is null or empty");
        }
        String bucketPrefix = "fs.cosn.bucket." + bucket + '.';
        LOG.debug("propagating entries under {}", (Object)bucketPrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry entry : source) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(bucketPrefix) || bucketPrefix.equals(key)) continue;
            String stripped = key.substring(bucketPrefix.length());
            if ("impl".equals(stripped)) {
                LOG.debug("Ignoring bucket option {}", (Object)key);
                continue;
            }
            String generic = "fs.cosn." + stripped;
            LOG.debug("Updating {} from origin", (Object)generic);
            dest.set(generic, value, key);
        }
        return dest;
    }
}

