/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.endpoint.EndpointResolver;
import com.qcloud.cos.endpoint.SuffixEndpointBuilder;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.ResponseNotCompleteException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.GetSymlinkRequest;
import com.qcloud.cos.model.GetSymlinkResult;
import com.qcloud.cos.model.HeadBucketRequest;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.PutSymlinkRequest;
import com.qcloud.cos.model.PutSymlinkResult;
import com.qcloud.cos.model.RenameRequest;
import com.qcloud.cos.model.SSEAlgorithm;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNConfigKeys;
import org.apache.hadoop.fs.CosNEncryptionMethods;
import org.apache.hadoop.fs.CosNEncryptionSecrets;
import org.apache.hadoop.fs.CosNFileSystem;
import org.apache.hadoop.fs.CosNPartialListing;
import org.apache.hadoop.fs.CosNResultInfo;
import org.apache.hadoop.fs.CosNSymlinkMetadata;
import org.apache.hadoop.fs.CosNUtils;
import org.apache.hadoop.fs.CosNXAttr;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.RangerCredentialsClient;
import org.apache.hadoop.fs.auth.COSCredentialProviderList;
import org.apache.hadoop.fs.cosn.CosNPartListing;
import org.apache.hadoop.fs.cosn.CustomerDomainEndpointResolver;
import org.apache.hadoop.fs.cosn.ResettableFileInputStream;
import org.apache.hadoop.fs.cosn.TencentCloudL5EndpointResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CosNativeFileSystemStore
implements NativeFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(CosNativeFileSystemStore.class);
    private static final String XATTR_PREFIX = "cosn-xattr-";
    private static final String CLIENT_SIDE_ENCRYPTION_PREFIX = "client-side-encryption";
    private static final String COS_TAG_LEN_PREFIX = "x-cos-tag-len";
    private static final String CSE_SINGLE_UPLOAD_FILE_SIZE = "client-side-encryption-unencrypted-content-length";
    public static final String CSE_MPU_FILE_SIZE = "client-side-encryption-data-size";
    public static final String CSE_MPU_KEY_SUFFIX = "._CSE_";
    private COSClient cosClient;
    private String bucketName;
    private boolean isPosixBucket = false;
    private StorageClass storageClass;
    private int maxRetryTimes;
    private int trafficLimit;
    private boolean crc32cEnabled;
    private boolean completeMPUCheckEnabled;
    private boolean partConflictCheckEnabled;
    private long partSize;
    private boolean clientEncryptionEnabled;
    private CosNEncryptionSecrets encryptionSecrets;
    private TencentCloudL5EndpointResolver l5EndpointResolver;
    private RangerCredentialsClient rangerCredentialsClient = null;
    private boolean useL5Id = false;
    private int l5UpdateMaxRetryTimes;

    private void initCOSClient(URI uri, Configuration conf) throws IOException {
        String versionNum;
        ClientConfig config;
        COSCredentialProviderList cosCredentialProviderList = CosNUtils.createCosCredentialsProviderSet(uri, conf, this.rangerCredentialsClient);
        String customerDomain = conf.get("fs.cosn.customer.domain");
        if (null == customerDomain) {
            String l5Id;
            String endpointSuffix;
            String region = conf.get("fs.cosn.bucket.region");
            if (null == region) {
                region = conf.get("fs.cosn.userinfo.region");
            }
            if (null == (endpointSuffix = conf.get("fs.cosn.bucket.endpoint_suffix"))) {
                endpointSuffix = conf.get("fs.cosn.userinfo.endpoint_suffix");
            }
            if (null == region && null == endpointSuffix) {
                String exceptionMsg = String.format("config '%s' and '%s' specify at least one.", "fs.cosn.bucket.region", "fs.cosn.bucket.endpoint_suffix");
                throw new IOException(exceptionMsg);
            }
            if (null == region) {
                config = new ClientConfig(new Region(""));
                config.setEndPointSuffix(endpointSuffix);
            } else {
                config = new ClientConfig(new Region(region));
            }
            String customEndpointSuffix = conf.get("fs.cosn.custom.endpoint_suffix");
            if (customEndpointSuffix != null && !customEndpointSuffix.isEmpty()) {
                if (null == region) {
                    String exceptionMsg = String.format("missing config '%s' or '%s'.", "fs.cosn.bucket.region", "fs.cosn.userinfo.region");
                    throw new IOException(exceptionMsg);
                }
                config = new ClientConfig(new Region(region));
                SuffixEndpointBuilder suffixEndPointBuilder = new SuffixEndpointBuilder(customEndpointSuffix);
                config.setEndpointBuilder((EndpointBuilder)suffixEndPointBuilder);
                boolean distinguishHost = conf.getBoolean("fs.cosn.distinguish.host.flag", false);
                LOG.info("{}: {}", (Object)"fs.cosn.distinguish.host.flag", (Object)distinguishHost);
                if (distinguishHost) {
                    config.setIsDistinguishHost(true);
                }
            }
            this.useL5Id = conf.getBoolean("fs.cosn.use.l5.enable", false);
            this.l5UpdateMaxRetryTimes = conf.getInt("fs.cosn.l5.update.maxRetries", 5);
            if (this.useL5Id && null != (l5Id = conf.get("fs.cosn.bucket.l5"))) {
                int l5modId = Integer.parseInt(l5Id.split(",")[0]);
                int l5cmdId = Integer.parseInt(l5Id.split(",")[1]);
                try {
                    Class<?> l5EndpointResolverClass = Class.forName("org.apache.hadoop.fs.cosn.TencentCloudL5EndpointResolverImpl");
                    this.l5EndpointResolver = (TencentCloudL5EndpointResolver)l5EndpointResolverClass.newInstance();
                    this.l5EndpointResolver.setModId(l5modId);
                    this.l5EndpointResolver.setCmdId(l5cmdId);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IOException("The current version does not support L5 resolver.", e);
                }
                config.setEndpointResolver((EndpointResolver)this.l5EndpointResolver);
            }
        } else {
            config = new ClientConfig(new Region(""));
            LOG.info("Use Customer Domain is {}", (Object)customerDomain);
            CustomerDomainEndpointResolver customerDomainEndpointResolver = new CustomerDomainEndpointResolver();
            customerDomainEndpointResolver.setEndpoint(customerDomain);
            config.setEndpointBuilder((EndpointBuilder)customerDomainEndpointResolver);
        }
        boolean useHttps = conf.getBoolean("fs.cosn.useHttps", true);
        if (useHttps) {
            config.setHttpProtocol(HttpProtocol.https);
        } else {
            config.setHttpProtocol(HttpProtocol.http);
        }
        int socketTimeoutSec = conf.getInt("fs.cosn.client.socket.timeoutsec", 30);
        config.setSocketTimeout(socketTimeoutSec * 1000);
        this.crc32cEnabled = conf.getBoolean("fs.cosn.crc32c.checksum.enabled", false);
        this.completeMPUCheckEnabled = conf.getBoolean("fs.cosn.complete.mpu.check", true);
        this.clientEncryptionEnabled = conf.getBoolean("fs.cosn.client-side-encryption.enabled", false);
        String httpProxyIp = conf.getTrimmed("fs.cosn.http.proxy.ip");
        int httpProxyPort = conf.getInt("fs.cosn.http.proxy.port", -1);
        if (null != httpProxyIp && !httpProxyIp.isEmpty()) {
            config.setHttpProxyIp(httpProxyIp);
            if (httpProxyPort >= 0) {
                config.setHttpProxyPort(httpProxyPort);
            } else if (useHttps) {
                LOG.warn("Proxy IP set without port. Using HTTPS default port 443");
                config.setHttpProxyPort(443);
            } else {
                LOG.warn("Proxy IP set without port, Using HTTP default port 80");
                config.setHttpProxyPort(80);
            }
            String proxyUserName = conf.get("fs.cosn.http.proxy.username");
            String proxyPassword = conf.get("fs.cosn.http.proxy.password");
            if ((null == proxyUserName || proxyUserName.isEmpty()) != (null == proxyPassword || proxyPassword.isEmpty())) {
                String exceptionMessage = String.format("Proxy error: '%s' or '%s' set without the other.", "fs.cosn.http.proxy.username", "fs.cosn.http.proxy.password");
                throw new IllegalArgumentException(exceptionMessage);
            }
            config.setProxyUsername(proxyUserName);
            config.setProxyPassword(proxyPassword);
        }
        String versionInfo = (versionNum = this.getPluginVersionInfo()).equals("unknown") ? CosNConfigKeys.DEFAULT_USER_AGENT : "cos-hadoop-plugin-v" + versionNum;
        String userAgent = conf.get("fs.cosn.user.agent", versionInfo);
        String emrVersion = conf.get("fs.emr.version");
        if (null != emrVersion && !emrVersion.isEmpty()) {
            userAgent = String.format("%s on %s", userAgent, emrVersion);
        }
        config.setUserAgent(userAgent);
        this.maxRetryTimes = conf.getInt("fs.cosn.maxRetries", 200);
        this.partSize = conf.getLong("fs.cosn.upload.part.size", 0x800000L);
        if (this.partSize < 0x100000L) {
            LOG.warn("The minimum size of a single block is limited to greater than or equal to {}.", (Object)0x100000L);
            this.partSize = 0x100000L;
        } else if (this.partSize > 0x80000000L) {
            LOG.warn("The maximum size of a single block is limited to smaller than or equal to {}.", (Object)0x80000000L);
            this.partSize = 0x80000000L;
        }
        int clientMaxRetryTimes = conf.getInt("fs.cosn.client.maxRetries", 5);
        config.setMaxErrorRetry(clientMaxRetryTimes);
        LOG.info("hadoop cos retry times: {}, cos client retry times: {}", (Object)this.maxRetryTimes, (Object)clientMaxRetryTimes);
        config.setMaxConnectionsCount(conf.getInt("fs.cosn.max.connection.num", 2048));
        String serverSideEncryptionAlgorithm = conf.get("fs.cosn.server-side-encryption.algorithm", "");
        CosNEncryptionMethods cosSSE = CosNEncryptionMethods.getMethod(serverSideEncryptionAlgorithm);
        String sseKey = conf.get("fs.cosn.server-side-encryption.key", "");
        String sseContext = conf.get("fs.cosn.server-side-encryption.context", "");
        this.checkEncryptionMethod(config, cosSSE, sseKey);
        this.encryptionSecrets = new CosNEncryptionSecrets(cosSSE, sseKey, sseContext);
        this.trafficLimit = conf.getInt("fs.cosn.traffic.limit", -1);
        if (this.trafficLimit >= 0 && (this.trafficLimit < 819200 || this.trafficLimit > 0x32000000)) {
            String exceptionMessage = String.format("The '%s' needs to be between %d and %d. but %d.", "fs.cosn.traffic.limit", 819200, 0x32000000, this.trafficLimit);
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (this.clientEncryptionEnabled) {
            LOG.info("client side encryption enabled");
            config.setHttpProtocol(HttpProtocol.https);
            KeyPair asymKeyPair = null;
            try {
                asymKeyPair = CosNUtils.loadAsymKeyPair(conf.get("fs.cosn.client-side-encryption.public.key.path"), conf.get("fs.cosn.client-side-encryption.private.key.path"));
            }
            catch (Exception e) {
                throw new CosClientException((Throwable)e);
            }
            EncryptionMaterials encryptionMaterials = new EncryptionMaterials(asymKeyPair);
            CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AuthenticatedEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
            this.cosClient = new COSEncryptionClient((COSCredentialsProvider)cosCredentialProviderList, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), config, cryptoConf);
            return;
        }
        this.cosClient = new COSClient((COSCredentialsProvider)cosCredentialProviderList, config);
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        String bucket = uri.getHost();
        RangerCredentialsClient rangerCredentialsClient = new RangerCredentialsClient();
        rangerCredentialsClient.doInitialize(conf, bucket);
        this.initialize(uri, conf, rangerCredentialsClient);
    }

    @Override
    public void initialize(URI uri, Configuration conf, RangerCredentialsClient rangerClient) throws IOException {
        this.preClose();
        try {
            String storageClass;
            if (null == rangerClient) {
                throw new IOException("native store ranger client param is null");
            }
            this.rangerCredentialsClient = rangerClient;
            this.initCOSClient(uri, conf);
            if (null == this.bucketName) {
                this.bucketName = uri.getHost();
            }
            if (null != (storageClass = conf.get("fs.cosn.storage.class")) && !storageClass.isEmpty()) {
                try {
                    this.storageClass = StorageClass.fromValue((String)storageClass);
                }
                catch (IllegalArgumentException e) {
                    String exceptionMessage = String.format("The specified storage class [%s] is invalid. The supported storage classes are: %s, %s, %s, %s and %s.", storageClass, StorageClass.Standard, StorageClass.Standard_IA, StorageClass.Maz_Standard, StorageClass.Maz_Standard_IA, StorageClass.Archive);
                    throw new IllegalArgumentException(exceptionMessage);
                }
            }
            if (null != this.storageClass && StorageClass.Archive == this.storageClass) {
                LOG.warn("The storage class of the CosN FileSystem is set to {}. Some file operations may not be supported.", (Object)this.storageClass);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize the COS native filesystem store.", (Throwable)e);
            this.handleException(e, "");
        }
    }

    private void storeFileWithRetry(String key, InputStream inputStream, byte[] md5Hash, long length) throws IOException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            if (null != md5Hash) {
                objectMetadata.setContentMD5(Base64.encodeAsString((byte[])md5Hash));
            }
            objectMetadata.setContentLength(length);
            if (this.crc32cEnabled) {
                objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, key, inputStream, objectMetadata);
            if (null != this.storageClass) {
                putObjectRequest.setStorageClass(this.storageClass);
            }
            if (this.trafficLimit >= 0) {
                putObjectRequest.setTrafficLimit(this.trafficLimit);
            }
            this.setEncryptionMetadata(putObjectRequest, objectMetadata);
            PutObjectResult putObjectResult = (PutObjectResult)this.callCOSClientWithRetry(putObjectRequest);
            LOG.debug("Store the file successfully. cos key: {}, ETag: {}.", (Object)key, (Object)putObjectResult.getETag());
        }
        catch (CosServiceException cse) {
            int statusCode = cse.getStatusCode();
            if (statusCode == 409) {
                FileMetadata fileMetadata = this.queryObjectMetadata(key);
                if (null == fileMetadata) {
                    this.handleException((Exception)((Object)cse), key);
                }
                LOG.warn("Upload the cos key [{}] concurrently", (Object)key);
            } else {
                this.handleException((Exception)((Object)cse), key);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Store the file failed, cos key: %s, exception: %s.", key, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public HeadBucketResult headBucket(String bucketName) throws IOException {
        HeadBucketRequest headBucketRequest = new HeadBucketRequest(bucketName);
        try {
            HeadBucketResult result = (HeadBucketResult)this.callCOSClientWithRetry(headBucketRequest);
            return result;
        }
        catch (Exception e) {
            String errMsg = String.format("head bucket [%s] occurs an exception: %s.", bucketName, e);
            this.handleException(new Exception(errMsg), bucketName);
            return null;
        }
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        if (null != md5Hash) {
            LOG.debug("Store the file, local path: {}, length: {}, md5hash: {}.", new Object[]{file.getCanonicalPath(), file.length(), Hex.encodeHexString((byte[])md5Hash)});
        }
        this.storeFileWithRetry(key, new ResettableFileInputStream(file), md5Hash, file.length());
    }

    @Override
    public void storeFile(String key, InputStream inputStream, byte[] md5Hash, long contentLength) throws IOException {
        if (null != md5Hash) {
            LOG.debug("Store the file to the cos key: {}, input stream md5 hash: {}, content length: {}.", new Object[]{key, Hex.encodeHexString((byte[])md5Hash), contentLength});
        }
        this.storeFileWithRetry(key, inputStream, md5Hash, contentLength);
    }

    @Override
    public void storeEmptyFile(String key) throws IOException {
        LOG.debug("Store an empty file to the key: {}.", (Object)key);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(0L);
        if (this.crc32cEnabled) {
            objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, key, (InputStream)input, objectMetadata);
        if (null != this.storageClass) {
            putObjectRequest.setStorageClass(this.storageClass);
        }
        try {
            PutObjectResult putObjectResult = (PutObjectResult)this.callCOSClientWithRetry(putObjectRequest);
            LOG.debug("Store the empty file successfully, cos key: {}, ETag: {}.", (Object)key, (Object)putObjectResult.getETag());
        }
        catch (CosServiceException cse) {
            int statusCode = cse.getStatusCode();
            if (statusCode == 409) {
                FileMetadata fileMetadata = this.queryObjectMetadata(key);
                if (null == fileMetadata) {
                    this.handleException((Exception)((Object)cse), key);
                }
                LOG.warn("Upload the file [{}] concurrently.", (Object)key);
            } else {
                this.handleException((Exception)((Object)cse), key);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Store the empty file failed, cos key: %s, exception: %s", key, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public PartETag uploadPart(File file, String key, String uploadId, int partNum, byte[] md5Hash, Boolean isLastPart) throws IOException {
        ResettableFileInputStream inputStream = new ResettableFileInputStream(file);
        return this.uploadPart(inputStream, key, uploadId, partNum, file.length(), md5Hash, isLastPart);
    }

    @Override
    public PartETag uploadPart(InputStream inputStream, String key, String uploadId, int partNum, long partSize, byte[] md5Hash, Boolean isLastPart) throws IOException {
        LOG.debug("Upload the part to the cos key [{}]. upload id: {}, part number: {}, part size: {}", new Object[]{key, uploadId, partNum, partSize});
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (this.crc32cEnabled) {
            objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
        }
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(this.bucketName);
        uploadPartRequest.setUploadId(uploadId);
        uploadPartRequest.setInputStream(inputStream);
        uploadPartRequest.setPartNumber(partNum);
        uploadPartRequest.setPartSize(partSize);
        uploadPartRequest.setObjectMetadata(objectMetadata);
        if (isLastPart == null && this.clientEncryptionEnabled) {
            throw new IOException("when client encryption is enabled, isLastPart can't be null");
        }
        if (isLastPart != null) {
            uploadPartRequest.setLastPart(isLastPart.booleanValue());
        }
        if (null != md5Hash && !this.clientEncryptionEnabled) {
            uploadPartRequest.setMd5Digest(Base64.encodeAsString((byte[])md5Hash));
        }
        uploadPartRequest.setKey(key);
        if (this.trafficLimit >= 0) {
            uploadPartRequest.setTrafficLimit(this.trafficLimit);
        }
        this.setEncryptionMetadata(uploadPartRequest, objectMetadata);
        try {
            UploadPartResult uploadPartResult = (UploadPartResult)this.callCOSClientWithRetry(uploadPartRequest);
            return uploadPartResult.getPartETag();
        }
        catch (CosServiceException cse) {
            String errMsg = String.format("The current thread:%d, cos key: %s, upload id: %s, part num: %d, exception: %s", new Object[]{Thread.currentThread().getId(), key, uploadId, partNum, cse});
            int statusCode = cse.getStatusCode();
            if (409 == statusCode) {
                CosNPartListing partListing = this.listParts(key, uploadId);
                PartETag partETag = this.isPartExist(partListing, partNum, partSize);
                if (null == partETag) {
                    this.handleException(new Exception(errMsg), key);
                }
                LOG.warn("Upload the file [{}] uploadId [{}], part [{}] concurrently." + key, (Object)uploadId, (Object)partNum);
                return partETag;
            }
            this.handleException(new Exception(errMsg), key);
        }
        catch (Exception e) {
            String errMsg = String.format("The current thread:%d, cos key: %s, upload id: %s, part num: %d, exception: %s", Thread.currentThread().getId(), key, uploadId, partNum, e);
            this.handleException(new Exception(errMsg), key);
        }
        return null;
    }

    @Override
    public PartETag uploadPart(File file, String key, String uploadId, int partNum, byte[] md5Hash) throws IOException {
        ResettableFileInputStream inputStream = new ResettableFileInputStream(file);
        return this.uploadPart(inputStream, key, uploadId, partNum, file.length(), md5Hash);
    }

    @Override
    public PartETag uploadPart(InputStream inputStream, String key, String uploadId, int partNum, long partSize, byte[] md5Hash) throws IOException {
        return this.uploadPart(inputStream, key, uploadId, partNum, partSize, md5Hash, null);
    }

    @Override
    public PartETag uploadPartCopy(String uploadId, String srcKey, String destKey, int partNum, long firstByte, long lastByte) throws IOException {
        LOG.debug("Execute a part copy from the source key [{}] to the dest key [{}]. upload id: {}, part number: {}, firstByte: {}, lastByte: {}.", new Object[]{srcKey, destKey, uploadId, partNum, firstByte, lastByte});
        try {
            CopyPartRequest copyPartRequest = new CopyPartRequest();
            copyPartRequest.setSourceBucketName(this.bucketName);
            copyPartRequest.setDestinationBucketName(this.bucketName);
            copyPartRequest.setSourceEndpointBuilder(this.cosClient.getClientConfig().getEndpointBuilder());
            copyPartRequest.setUploadId(uploadId);
            copyPartRequest.setSourceKey(srcKey);
            copyPartRequest.setDestinationKey(destKey);
            copyPartRequest.setPartNumber(partNum);
            copyPartRequest.setFirstByte(Long.valueOf(firstByte));
            copyPartRequest.setLastByte(Long.valueOf(lastByte));
            CopyPartResult copyPartResult = (CopyPartResult)this.callCOSClientWithRetry(copyPartRequest);
            return copyPartResult.getPartETag();
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Copy the object part [%d-%d] from the srcKey[%s] to the destKey[%s] failed. upload id: %s, part number: %d, exception: %s.", firstByte, lastByte, srcKey, destKey, uploadId, partNum, e);
            this.handleException(new Exception(exceptionMessage), srcKey);
            return null;
        }
    }

    @Override
    public void abortMultipartUpload(String key, String uploadId) throws IOException {
        LOG.info("Ready to doAbort the multipart upload. cos key: {}, upload id: {}.", (Object)key, (Object)uploadId);
        try {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.bucketName, key, uploadId);
            this.callCOSClientWithRetry(abortMultipartUploadRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Aborting the multipart upload failed. cos key: %s, upload id: %s. exception: %s.", key, uploadId, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public String getUploadId(String key) throws IOException {
        if (null == key || key.length() == 0) {
            return "";
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (this.crc32cEnabled) {
            objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
        }
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, key);
        if (null != this.storageClass) {
            initiateMultipartUploadRequest.setStorageClass(this.storageClass);
        }
        initiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        this.setEncryptionMetadata(initiateMultipartUploadRequest, objectMetadata);
        if (this.clientEncryptionEnabled) {
            initiateMultipartUploadRequest.setDataSizePartSize(this.partSize, this.partSize);
        }
        try {
            InitiateMultipartUploadResult initiateMultipartUploadResult = (InitiateMultipartUploadResult)this.callCOSClientWithRetry(initiateMultipartUploadRequest);
            return initiateMultipartUploadResult.getUploadId();
        }
        catch (Exception e) {
            String errMsg = String.format("Get the upload id failed, cos key: %s, exception: %s", key, e);
            this.handleException(new Exception(errMsg), key);
            return null;
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(String key, String uploadId, List<PartETag> partETagList) throws IOException {
        Collections.sort(partETagList, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag o1, PartETag o2) {
                return o1.getPartNumber() - o2.getPartNumber();
            }
        });
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            if (this.crc32cEnabled) {
                objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, key, uploadId, partETagList);
            completeMultipartUploadRequest.setObjectMetadata(objectMetadata);
            return (CompleteMultipartUploadResult)this.callCOSClientWithRetry(completeMultipartUploadRequest);
        }
        catch (CosServiceException cse) {
            int statusCode = cse.getStatusCode();
            if (statusCode == 409) {
                FileMetadata fileMetadata = this.queryObjectMetadata(key);
                if (null == fileMetadata) {
                    this.handleException((Exception)((Object)cse), key);
                }
                LOG.warn("Upload the cos key [{}] complete mpu concurrently", (Object)key);
            } else {
                String errMsg = String.format("Complete the multipart upload failed. cos service exception, cos key: %s, upload id: %s, exception: %s", key, uploadId, cse.toString());
                this.handleException(new Exception(errMsg), key);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Complete the multipart upload failed. cos key: %s, upload id: %s, exception: %s", key, uploadId, e.toString());
            this.handleException(new Exception(errMsg), key);
        }
        return null;
    }

    private FileMetadata queryObjectMetadata(String key) throws IOException {
        return this.queryObjectMetadata(key, null);
    }

    private FileMetadata queryObjectMetadata(String key, CosNResultInfo info) throws IOException {
        LOG.debug("Query Object metadata. cos key: {}.", (Object)key);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this.bucketName, key);
        this.setEncryptionMetadata(getObjectMetadataRequest, new ObjectMetadata());
        try {
            ObjectMetadata objectMetadata = (ObjectMetadata)this.callCOSClientWithRetry(getObjectMetadataRequest);
            long mtime = 0L;
            long fileSize = 0L;
            if (objectMetadata.getLastModified() != null) {
                mtime = objectMetadata.getLastModified().getTime();
            }
            fileSize = objectMetadata.getContentLength();
            if (this.clientEncryptionEnabled) {
                if (objectMetadata.getUserMetadata().containsKey(CSE_SINGLE_UPLOAD_FILE_SIZE)) {
                    fileSize = Long.parseLong((String)objectMetadata.getUserMetadata().get(CSE_SINGLE_UPLOAD_FILE_SIZE));
                } else if (objectMetadata.getUserMetadata().containsKey(CSE_MPU_FILE_SIZE)) {
                    fileSize = Long.parseLong((String)objectMetadata.getUserMetadata().get(CSE_MPU_FILE_SIZE));
                }
            }
            String ETag = objectMetadata.getETag();
            String crc64ecm = objectMetadata.getCrc64Ecma();
            String crc32cm = (String)objectMetadata.getRawMetadataValue("x-cos-hash-crc32c");
            String versionId = objectMetadata.getVersionId();
            HashMap<String, byte[]> userMetadata = null;
            if (objectMetadata.getUserMetadata() != null) {
                userMetadata = new HashMap<String, byte[]>();
                for (Map.Entry userMetadataEntry : objectMetadata.getUserMetadata().entrySet()) {
                    if (((String)userMetadataEntry.getKey()).startsWith(CosNativeFileSystemStore.ensureValidAttributeName(XATTR_PREFIX))) {
                        CosNXAttr cosNXAttr;
                        String xAttrJsonStr = new String(Base64.decode((String)((String)userMetadataEntry.getValue())), StandardCharsets.UTF_8);
                        try {
                            cosNXAttr = (CosNXAttr)Jackson.fromJsonString((String)xAttrJsonStr, CosNXAttr.class);
                        }
                        catch (CosClientException e) {
                            LOG.warn("Parse the xAttr failed. name: {}, XAttJsonStr: {}.", userMetadataEntry.getKey(), (Object)xAttrJsonStr);
                            continue;
                        }
                        if (null != cosNXAttr) {
                            userMetadata.put(cosNXAttr.getName(), cosNXAttr.getValue().getBytes(CosNFileSystem.METADATA_ENCODING));
                        }
                    }
                    if (!((String)userMetadataEntry.getKey()).startsWith(CLIENT_SIDE_ENCRYPTION_PREFIX) && !((String)userMetadataEntry.getKey()).startsWith(COS_TAG_LEN_PREFIX)) continue;
                    userMetadata.put((String)userMetadataEntry.getKey(), ((String)userMetadataEntry.getValue()).getBytes(CosNFileSystem.METADATA_ENCODING));
                }
            }
            boolean isFile = true;
            if (this.isPosixBucket) {
                if (objectMetadata.isFileModeDir() || key.equals("/")) {
                    isFile = false;
                }
            } else {
                isFile = !key.endsWith("/");
            }
            FileMetadata fileMetadata = new FileMetadata(key, fileSize, mtime, isFile, ETag, crc64ecm, crc32cm, versionId, objectMetadata.getStorageClass(), userMetadata);
            if (info != null) {
                info.setRequestID(objectMetadata.getRequestId());
            }
            LOG.debug("Retrieve the file metadata. cos key: {}, ETag:{}, length:{}, crc64ecm: {}.", new Object[]{key, objectMetadata.getETag(), objectMetadata.getContentLength(), objectMetadata.getCrc64Ecma()});
            return fileMetadata;
        }
        catch (CosServiceException e) {
            if (info != null) {
                info.setRequestID(e.getRequestId());
            }
            if (e.getStatusCode() != 404) {
                String errorMsg = String.format("Retrieve the file metadata file failure. cos key: %s, exception: %s", new Object[]{key, e});
                this.handleException(new Exception(errorMsg), key);
            }
            return null;
        }
    }

    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        return this.retrieveMetadata(key, null);
    }

    @Override
    public FileMetadata retrieveMetadata(String key, CosNResultInfo info) throws IOException {
        FileMetadata fileMetadata;
        if (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        if (!key.isEmpty() && (fileMetadata = this.queryObjectMetadata(key, info)) != null) {
            return fileMetadata;
        }
        key = key + "/";
        return this.queryObjectMetadata(key, info);
    }

    @Override
    public CosNSymlinkMetadata retrieveSymlinkMetadata(String symlink) throws IOException {
        return this.retrieveSymlinkMetadata(symlink, null);
    }

    @Override
    public CosNSymlinkMetadata retrieveSymlinkMetadata(String symlink, CosNResultInfo info) throws IOException {
        LOG.debug("Get the symlink [{}]'s metadata.", (Object)symlink);
        try {
            GetSymlinkRequest getSymlinkRequest = new GetSymlinkRequest(this.bucketName, symlink, null);
            GetSymlinkResult getSymlinkResult = (GetSymlinkResult)this.callCOSClientWithRetry(getSymlinkRequest);
            if (null != info) {
                info.setRequestID(getSymlinkResult.getRequestId());
            }
            return new CosNSymlinkMetadata(symlink, getSymlinkResult.getContentLength(), getSymlinkResult.getLastModified(), false, getSymlinkResult.getETag(), null, null, getSymlinkResult.getVersionId(), StorageClass.Standard.toString(), getSymlinkResult.getTarget());
        }
        catch (CosServiceException cosServiceException) {
            if (null != info) {
                info.setRequestID(cosServiceException.getRequestId());
            }
            if (cosServiceException.getStatusCode() == 400 && cosServiceException.getErrorCode().compareToIgnoreCase("NotSymlink") == 0) {
                LOG.debug("The key [{}] is not a symlink.", (Object)symlink);
                return null;
            }
            if (cosServiceException.getStatusCode() != 404) {
                String errMsg = String.format("Retrieve the symlink metadata failed. symlink: %s, exception: %s.", new Object[]{symlink, cosServiceException});
                this.handleException(new Exception(errMsg), symlink);
            }
            return null;
        }
    }

    @Override
    public byte[] retrieveAttribute(String key, String attribute) throws IOException {
        LOG.debug("Get the extended attribute. cos key: {}, attribute: {}.", (Object)key, (Object)attribute);
        FileMetadata fileMetadata = this.retrieveMetadata(key);
        if (null != fileMetadata && null != fileMetadata.getUserAttributes()) {
            return fileMetadata.getUserAttributes().get(attribute);
        }
        return null;
    }

    @Override
    public void storeDirAttribute(String key, String attribute, byte[] value) throws IOException {
        LOG.debug("Store a attribute to the specified directory. cos key: {}, attribute: {}, value: {}.", new Object[]{key, attribute, new String(value, CosNFileSystem.METADATA_ENCODING)});
        if (!key.endsWith("/")) {
            key = key + "/";
        }
        this.storeAttribute(key, attribute, value, false);
    }

    @Override
    public void storeFileAttribute(String key, String attribute, byte[] value) throws IOException {
        LOG.debug("Store a attribute to the specified file. cos key: {}, attribute: {}, value: {}.", new Object[]{key, attribute, new String(value, CosNFileSystem.METADATA_ENCODING)});
        this.storeAttribute(key, attribute, value, false);
    }

    @Override
    public void removeDirAttribute(String key, String attribute) throws IOException {
        LOG.debug("Remove the attribute from the specified directory. cos key: {}, attribute: {}.", (Object)key, (Object)attribute);
        if (!key.endsWith("/")) {
            key = key + "/";
        }
        this.storeAttribute(key, attribute, null, true);
    }

    @Override
    public void removeFileAttribute(String key, String attribute) throws IOException {
        LOG.debug("Remove the attribute from the specified file. cos key: {}, attribute: {}.", (Object)key, (Object)attribute);
        this.storeAttribute(key, attribute, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeAttribute(String key, String attribute, byte[] value, boolean deleted) throws IOException {
        ObjectMetadata objectMetadata;
        block12: {
            if (deleted) {
                LOG.debug("Delete the extended attribute. cos key: {}, attribute: {}.", (Object)key, (Object)attribute);
            }
            if (null != value && !deleted) {
                LOG.debug("Store the extended attribute. cos key: {}, attribute: {}, value: {}.", new Object[]{key, attribute, new String(value, StandardCharsets.UTF_8)});
            }
            if (null == value && !deleted) {
                throw new IOException("The attribute value to be set can not be null.");
            }
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this.bucketName, key);
            this.setEncryptionMetadata(getObjectMetadataRequest, new ObjectMetadata());
            objectMetadata = null;
            try {
                objectMetadata = (ObjectMetadata)this.callCOSClientWithRetry(getObjectMetadataRequest);
            }
            catch (CosServiceException e) {
                if (e.getStatusCode() == 404) break block12;
                String errorMessage = String.format("Retrieve the file metadata failed. cos key: %s, exception: %s.", new Object[]{key, e});
                this.handleException(new Exception(errorMessage), key);
            }
        }
        if (null == objectMetadata) return;
        HashMap<String, String> userMetadata = objectMetadata.getUserMetadata();
        if (deleted) {
            if (null == userMetadata) return;
            userMetadata.remove(CosNativeFileSystemStore.ensureValidAttributeName(attribute));
        } else {
            if (null == userMetadata) {
                userMetadata = new HashMap<String, String>();
            }
            CosNXAttr cosNXAttr = new CosNXAttr();
            cosNXAttr.setName(attribute);
            cosNXAttr.setValue(new String(value, CosNFileSystem.METADATA_ENCODING));
            String xAttrJsonStr = Jackson.toJsonString((Object)cosNXAttr);
            userMetadata.put(CosNativeFileSystemStore.ensureValidAttributeName(XATTR_PREFIX + attribute), Base64.encodeAsString((byte[])xAttrJsonStr.getBytes(StandardCharsets.UTF_8)));
        }
        objectMetadata.setUserMetadata(userMetadata);
        if (this.crc32cEnabled) {
            objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
        }
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, key, this.bucketName, key);
        if (null != objectMetadata.getStorageClass()) {
            copyObjectRequest.setStorageClass(objectMetadata.getStorageClass());
        }
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        copyObjectRequest.setRedirectLocation("Replaced");
        this.setEncryptionMetadata(copyObjectRequest, objectMetadata);
        copyObjectRequest.setSourceEndpointBuilder(this.cosClient.getClientConfig().getEndpointBuilder());
        try {
            this.callCOSClientWithRetry(copyObjectRequest);
            return;
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to modify the user-defined attributes. cos key: %s, attribute: %s, exception: %s.", key, attribute, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        LOG.debug("Retrieve the key: {}.", (Object)key);
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        if (this.trafficLimit >= 0) {
            getObjectRequest.setTrafficLimit(this.trafficLimit);
        }
        this.setEncryptionMetadata(getObjectRequest, new ObjectMetadata());
        try {
            COSObject cosObject = (COSObject)this.callCOSClientWithRetry(getObjectRequest);
            return cosObject.getObjectContent();
        }
        catch (Exception e) {
            String errMsg = String.format("Retrieving the cos key [%s] occurs an exception: %s", key, e);
            this.handleException(new Exception(errMsg), key);
            return null;
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            LOG.debug("Retrieve the cos key: {}, byte range start: {}.", (Object)key, (Object)byteRangeStart);
            long fileSize = this.getFileLength(key);
            long byteRangeEnd = fileSize - 1L;
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
            if (this.trafficLimit >= 0) {
                getObjectRequest.setTrafficLimit(this.trafficLimit);
            }
            this.setEncryptionMetadata(getObjectRequest, new ObjectMetadata());
            if (byteRangeEnd >= byteRangeStart) {
                getObjectRequest.setRange(byteRangeStart, fileSize - 1L);
            }
            COSObject cosObject = (COSObject)this.callCOSClientWithRetry(getObjectRequest);
            return cosObject.getObjectContent();
        }
        catch (Exception e) {
            String errMsg = String.format("Retrieving key [%s] with byteRangeStart [%d] occurs an exception: %s.", key, byteRangeStart, e);
            this.handleException(new Exception(errMsg), key);
            return null;
        }
    }

    @Override
    public InputStream retrieveBlock(String key, long byteRangeStart, long byteRangeEnd) throws IOException {
        LOG.debug("Retrieve the cos key: {}, byte range start: {}, byte range end: {}.", new Object[]{key, byteRangeStart, byteRangeEnd});
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, key);
            request.setRange(byteRangeStart, byteRangeEnd);
            if (this.trafficLimit >= 0) {
                request.setTrafficLimit(this.trafficLimit);
            }
            this.setEncryptionMetadata(request, new ObjectMetadata());
            COSObject cosObject = (COSObject)this.callCOSClientWithRetry(request);
            return cosObject.getObjectContent();
        }
        catch (CosServiceException e) {
            String errMsg = String.format("Retrieving the key %s with the byteRangeStart [%d] occurs an exception: %s.", new Object[]{key, byteRangeStart, e});
            this.handleException(new Exception(errMsg), key);
        }
        catch (CosClientException e) {
            String errMsg = String.format("Retrieving key %s with the byteRangeStart [%d] and the byteRangeEnd [%d] occurs an exception: %s.", new Object[]{key, byteRangeStart, byteRangeEnd, e});
            this.handleException(new Exception(errMsg), key);
        }
        return null;
    }

    public ObjectMetadata getClientSideEncryptionHeader(FileMetadata sourceFileMetadata) {
        HashMap<String, String> userClientEncryptionMetadata = new HashMap<String, String>();
        for (Map.Entry<String, byte[]> userMetadataEntry : sourceFileMetadata.getUserAttributes().entrySet()) {
            if (!userMetadataEntry.getKey().startsWith(CLIENT_SIDE_ENCRYPTION_PREFIX) && !userMetadataEntry.getKey().startsWith(COS_TAG_LEN_PREFIX)) continue;
            userClientEncryptionMetadata.put(userMetadataEntry.getKey(), new String(userMetadataEntry.getValue()));
        }
        ObjectMetadata newObjectMetadata = new ObjectMetadata();
        if (!userClientEncryptionMetadata.isEmpty()) {
            newObjectMetadata.setUserMetadata(userClientEncryptionMetadata);
        }
        return newObjectMetadata;
    }

    @Override
    public boolean retrieveBlock(String key, long byteRangeStart, long blockSize, String localBlockPath) throws IOException {
        long fileSize = this.getFileLength(key);
        long byteRangeEnd = 0L;
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, key);
            if (this.trafficLimit >= 0) {
                request.setTrafficLimit(this.trafficLimit);
            }
            this.setEncryptionMetadata(request, new ObjectMetadata());
            if (fileSize > 0L) {
                byteRangeEnd = Math.min(fileSize - 1L, byteRangeStart + blockSize - 1L);
                request.setRange(byteRangeStart, byteRangeEnd);
            }
            this.cosClient.getObject(request, new File(localBlockPath));
            return true;
        }
        catch (Exception e) {
            String errMsg = String.format("Retrieving block key [%s] with range [%d - %d] occurs an exception: %s", key, byteRangeStart, byteRangeEnd, e.getMessage());
            this.handleException(new Exception(errMsg), key);
            return false;
        }
    }

    @Override
    public CosNPartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null);
    }

    @Override
    public CosNPartialListing list(String prefix, int maxListingLength, CosNResultInfo info) throws IOException {
        return this.list(prefix, maxListingLength, null, false, info);
    }

    @Override
    public CosNPartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse) throws IOException {
        return this.list(prefix, maxListingLength, priorLastKey, recurse, null);
    }

    @Override
    public CosNPartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse, CosNResultInfo info) throws IOException {
        return this.list(prefix, recurse ? null : "/", maxListingLength, priorLastKey, info);
    }

    private CosNPartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey, CosNResultInfo info) throws IOException {
        LOG.debug("List the cos key prefix: {}, max listing length: {}, delimiter: {}, prior last key: {}.", new Object[]{prefix, delimiter, maxListingLength, priorLastKey});
        if (!prefix.startsWith("/")) {
            prefix = prefix + "/";
        }
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(this.bucketName);
        listObjectsRequest.setPrefix(prefix);
        listObjectsRequest.setDelimiter(delimiter);
        listObjectsRequest.setMarker(priorLastKey);
        listObjectsRequest.setMaxKeys(Integer.valueOf(maxListingLength));
        ObjectListing objectListing = null;
        try {
            objectListing = (ObjectListing)this.callCOSClientWithRetry(listObjectsRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("prefix: %s, delimiter: %s, maxListingLength: %d, priorLastKey: %s. list occur a exception: %s", prefix, delimiter == null ? "" : delimiter, maxListingLength, priorLastKey, e);
            LOG.error(errMsg);
            this.handleException(new Exception(errMsg), prefix);
        }
        if (null == objectListing) {
            String errMessage = String.format("List objects failed for the prefix: %s, delimiter: %s, maxListingLength:%d, priorLastKey: %s.", prefix, delimiter == null ? "" : delimiter, maxListingLength, priorLastKey);
            this.handleException(new Exception(errMessage), prefix);
        }
        ArrayList<FileMetadata> fileMetadataArray = new ArrayList<FileMetadata>();
        ArrayList<FileMetadata> commonPrefixArray = new ArrayList<FileMetadata>();
        List summaries = objectListing.getObjectSummaries();
        boolean isKeySamePrefix = false;
        for (Object cosObjectSummary : summaries) {
            String filePath = cosObjectSummary.getKey();
            if (!filePath.startsWith("/")) {
                filePath = "/" + filePath;
            }
            if (filePath.equals(prefix)) {
                isKeySamePrefix = true;
                continue;
            }
            long mtime = 0L;
            if (cosObjectSummary.getLastModified() != null) {
                mtime = cosObjectSummary.getLastModified().getTime();
            }
            long fileLen = cosObjectSummary.getSize();
            String fileEtag = cosObjectSummary.getETag();
            if (cosObjectSummary.getKey().endsWith("/") && cosObjectSummary.getSize() == 0L) {
                fileMetadataArray.add(new FileMetadata(filePath, fileLen, mtime, false, fileEtag, null, null, null, cosObjectSummary.getStorageClass()));
                continue;
            }
            fileMetadataArray.add(new FileMetadata(filePath, fileLen, mtime, true, fileEtag, null, null, null, cosObjectSummary.getStorageClass()));
        }
        List commonPrefixes = objectListing.getCommonPrefixes();
        for (String commonPrefix : commonPrefixes) {
            if (!commonPrefix.startsWith("/")) {
                commonPrefix = "/" + commonPrefix;
            }
            commonPrefixArray.add(new FileMetadata(commonPrefix, 0L, 0L, false));
        }
        FileMetadata[] fileMetadata = new FileMetadata[fileMetadataArray.size()];
        for (int i = 0; i < fileMetadataArray.size(); ++i) {
            fileMetadata[i] = (FileMetadata)fileMetadataArray.get(i);
        }
        FileMetadata[] commonPrefixMetaData = new FileMetadata[commonPrefixArray.size()];
        for (int i = 0; i < commonPrefixArray.size(); ++i) {
            commonPrefixMetaData[i] = (FileMetadata)commonPrefixArray.get(i);
        }
        if (!objectListing.isTruncated()) {
            CosNPartialListing ret = new CosNPartialListing(null, fileMetadata, commonPrefixMetaData);
            if (info != null) {
                info.setRequestID(objectListing.getRequestId());
                info.setKeySameToPrefix(isKeySamePrefix);
            }
            return ret;
        }
        CosNPartialListing ret = new CosNPartialListing(objectListing.getNextMarker(), fileMetadata, commonPrefixMetaData);
        if (info != null) {
            info.setRequestID(objectListing.getRequestId());
            info.setKeySameToPrefix(isKeySamePrefix);
        }
        return ret;
    }

    @Override
    public void delete(String key) throws IOException {
        LOG.debug("Delete the cos key: {} from bucket: {}.", (Object)key, (Object)this.bucketName);
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.bucketName, key);
            this.callCOSClientWithRetry(deleteObjectRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Deleting the cos key [%s] occurs an exception: %s", key, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public void deleteRecursive(String key) throws IOException {
        LOG.debug("Delete the cos key recursive: {} from bucket: {}.", (Object)key, (Object)this.bucketName);
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.bucketName, key);
            deleteObjectRequest.setRecursive(true);
            this.callCOSClientWithRetry(deleteObjectRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Deleting the cos key recursive [%s] occurs an exception: %s", key, e);
            this.handleException(new Exception(errMsg), key);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            FileMetadata sourceFileMetadata = this.retrieveMetadata(srcKey);
            ObjectMetadata objectMetadata = this.getClientSideEncryptionHeader(sourceFileMetadata);
            if (this.crc32cEnabled) {
                objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
            }
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, srcKey, this.bucketName, dstKey);
            if (null != sourceFileMetadata && null != sourceFileMetadata.getStorageClass()) {
                copyObjectRequest.setStorageClass(sourceFileMetadata.getStorageClass());
            }
            copyObjectRequest.setNewObjectMetadata(objectMetadata);
            this.setEncryptionMetadata(copyObjectRequest, objectMetadata);
            copyObjectRequest.setSourceEndpointBuilder(this.cosClient.getClientConfig().getEndpointBuilder());
            this.callCOSClientWithRetry(copyObjectRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Copy the object failed, src cos key: %s, dst cos key: %s, exception: %s", srcKey, dstKey, e);
            this.handleException(new Exception(errMsg), srcKey);
        }
    }

    @Override
    public void rename(String srcKey, String dstKey) throws IOException {
        if (!this.isPosixBucket) {
            this.normalBucketRename(srcKey, dstKey);
        } else {
            this.posixBucketRename(srcKey, dstKey);
        }
    }

    @Override
    public void createSymlink(String symLink, String targetKey) throws IOException {
        LOG.debug("Create a symlink [{}] for the target object key [{}].", (Object)symLink, (Object)targetKey);
        try {
            PutSymlinkRequest putSymlinkRequest = new PutSymlinkRequest(this.bucketName, symLink, targetKey);
            PutSymlinkResult putSymlinkResult = (PutSymlinkResult)this.callCOSClientWithRetry(putSymlinkRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Create the symlink failed. symlink: %s, target cos key: %s, exception: %s.", symLink, targetKey, e);
            this.handleException(new Exception(errMsg), symLink);
        }
    }

    @Override
    public String getSymlink(String symlink) throws IOException {
        LOG.debug("Get the symlink [{}].", (Object)symlink);
        try {
            GetSymlinkRequest getSymlinkRequest = new GetSymlinkRequest(this.bucketName, symlink, null);
            GetSymlinkResult getSymlinkResult = (GetSymlinkResult)this.callCOSClientWithRetry(getSymlinkRequest);
            return getSymlinkResult.getTarget();
        }
        catch (CosServiceException cosServiceException) {
            if (cosServiceException.getStatusCode() == 400 && cosServiceException.getErrorCode().compareToIgnoreCase("NotSymlink") == 0) {
                LOG.debug("The key [{}] is not a symlink.", (Object)symlink);
                return null;
            }
            if (cosServiceException.getStatusCode() != 404) {
                String errMsg = String.format("Get the symlink failed. symlink: %s, exception: %s.", new Object[]{symlink, cosServiceException});
                this.handleException(new Exception(errMsg), symlink);
            }
            return null;
        }
    }

    public void normalBucketRename(String srcKey, String dstKey) throws IOException {
        LOG.debug("Rename normal bucket key, the source cos key [{}] to the dest cos key [{}].", (Object)srcKey, (Object)dstKey);
        try {
            FileMetadata sourceFileMetadata = this.retrieveMetadata(srcKey);
            ObjectMetadata objectMetadata = this.getClientSideEncryptionHeader(sourceFileMetadata);
            if (this.crc32cEnabled) {
                objectMetadata.setHeader("x-cos-crc32c-flag", (Object)"cosn");
            }
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, srcKey, this.bucketName, dstKey);
            if (null != sourceFileMetadata.getStorageClass()) {
                copyObjectRequest.setStorageClass(sourceFileMetadata.getStorageClass());
            }
            copyObjectRequest.setNewObjectMetadata(objectMetadata);
            this.setEncryptionMetadata(copyObjectRequest, objectMetadata);
            copyObjectRequest.setSourceEndpointBuilder(this.cosClient.getClientConfig().getEndpointBuilder());
            this.callCOSClientWithRetry(copyObjectRequest);
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.bucketName, srcKey);
            this.callCOSClientWithRetry(deleteObjectRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Rename object failed, normal bucket, source cos key: %s, dest cos key: %s, exception: %s", srcKey, dstKey, e);
            this.handleException(new Exception(errMsg), srcKey);
        }
    }

    public void posixBucketRename(String srcKey, String dstKey) throws IOException {
        LOG.debug("Rename posix bucket key, the source cos key [{}] to the dest cos key [{}].", (Object)srcKey, (Object)dstKey);
        try {
            RenameRequest renameRequest = new RenameRequest(this.bucketName, srcKey, dstKey);
            this.callCOSClientWithRetry(renameRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("Rename object failed, posix bucket, source cos key: %s, dest cos key: %s, exception: %s", srcKey, dstKey, e);
            this.handleException(new Exception(errMsg), srcKey);
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        throw new IOException("purge not supported");
    }

    @Override
    public void dump() throws IOException {
        throw new IOException("dump not supported");
    }

    @Override
    public void close() {
        if (null != this.cosClient) {
            this.cosClient.shutdown();
        }
        if (null != this.rangerCredentialsClient) {
            this.rangerCredentialsClient.close();
        }
        this.rangerCredentialsClient = null;
        this.cosClient = null;
    }

    private void preClose() {
        if (null != this.cosClient) {
            this.cosClient.shutdown();
        }
        this.cosClient = null;
    }

    @Override
    public void setPosixBucket(boolean isPosixBucket) {
        this.isPosixBucket = isPosixBucket;
    }

    private void handleException(Exception e, String key) throws IOException {
        String cosPath = "cosn://" + this.bucketName + key;
        String exceptInfo = String.format("%s : %s", cosPath, e.toString());
        throw new IOException(exceptInfo);
    }

    @Override
    public long getFileLength(String key) throws IOException {
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this.bucketName, key);
        this.setEncryptionMetadata(getObjectMetadataRequest, new ObjectMetadata());
        try {
            ObjectMetadata objectMetadata = (ObjectMetadata)this.callCOSClientWithRetry(getObjectMetadataRequest);
            return objectMetadata.getContentLength();
        }
        catch (Exception e) {
            String errMsg = String.format("Getting the file length occurs an exception, cos key: %s, exception: %s", key, e.getMessage());
            this.handleException(new Exception(errMsg), key);
            return 0L;
        }
    }

    @Override
    public CosNPartListing listParts(String key, String uploadId) throws IOException {
        LOG.debug("List parts key: {}, uploadId: {}", (Object)key, (Object)uploadId);
        ListPartsRequest listPartsRequest = new ListPartsRequest(this.bucketName, key, uploadId);
        PartListing partListing = null;
        LinkedList<PartSummary> partSummaries = new LinkedList<PartSummary>();
        do {
            try {
                partListing = (PartListing)this.callCOSClientWithRetry(listPartsRequest);
            }
            catch (Exception e) {
                String errMsg = String.format("list parts occurs an exception, cos key: %s, upload id: %s, exception: %s", key, uploadId, e.getMessage());
                LOG.error(errMsg);
                this.handleException(new Exception(errMsg), key);
                return null;
            }
            partSummaries.addAll(partListing.getParts());
            listPartsRequest.setPartNumberMarker(partListing.getNextPartNumberMarker());
        } while (partListing.isTruncated());
        return new CosNPartListing(partSummaries);
    }

    @Override
    public boolean isPosixBucket() {
        return this.isPosixBucket;
    }

    private PartETag isPartExist(CosNPartListing partListing, int partNum, long partSize) {
        PartETag ret = null;
        if (null == partListing) {
            return null;
        }
        for (PartSummary partSummary : partListing.getPartSummaries()) {
            if (partSummary.getPartNumber() != partNum || partSummary.getSize() != partSize) continue;
            ret = new PartETag(partSummary.getPartNumber(), partSummary.getETag());
            break;
        }
        return ret;
    }

    private <X> void callCOSClientWithSSEKMS(X request, SSECOSKeyManagementParams managementParams) {
        try {
            if (request instanceof PutObjectRequest) {
                ((PutObjectRequest)request).setSSECOSKeyManagementParams(managementParams);
            } else if (request instanceof CopyObjectRequest) {
                ((CopyObjectRequest)request).setSSECOSKeyManagementParams(managementParams);
            } else if (request instanceof InitiateMultipartUploadRequest) {
                ((InitiateMultipartUploadRequest)request).setSSECOSKeyManagementParams(managementParams);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("callCOSClientWithSSEKMS failed: %s", e);
            LOG.error(errMsg);
        }
    }

    private <X> void callCOSClientWithSSECOS(X request, ObjectMetadata objectMetadata) {
        try {
            objectMetadata.setServerSideEncryption(SSEAlgorithm.AES256.getAlgorithm());
            if (request instanceof PutObjectRequest) {
                ((PutObjectRequest)request).setMetadata(objectMetadata);
            } else if (request instanceof UploadPartRequest) {
                ((UploadPartRequest)request).setObjectMetadata(objectMetadata);
            } else if (request instanceof CopyObjectRequest) {
                ((CopyObjectRequest)request).setNewObjectMetadata(objectMetadata);
            } else if (request instanceof InitiateMultipartUploadRequest) {
                ((InitiateMultipartUploadRequest)request).setObjectMetadata(objectMetadata);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("callCOSClientWithSSECOS failed: %s", e);
            LOG.error(errMsg);
        }
    }

    private <X> void callCOSClientWithSSEC(X request, SSECustomerKey sseKey) {
        try {
            if (request instanceof PutObjectRequest) {
                ((PutObjectRequest)request).setSSECustomerKey(sseKey);
            } else if (request instanceof UploadPartRequest) {
                ((UploadPartRequest)request).setSSECustomerKey(sseKey);
            } else if (request instanceof GetObjectMetadataRequest) {
                ((GetObjectMetadataRequest)request).setSSECustomerKey(sseKey);
            } else if (request instanceof CopyObjectRequest) {
                ((CopyObjectRequest)request).setDestinationSSECustomerKey(sseKey);
                ((CopyObjectRequest)request).setSourceSSECustomerKey(sseKey);
            } else if (request instanceof GetObjectRequest) {
                ((GetObjectRequest)request).setSSECustomerKey(sseKey);
            } else if (request instanceof InitiateMultipartUploadRequest) {
                ((InitiateMultipartUploadRequest)request).setSSECustomerKey(sseKey);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("callCOSClientWithSSEC failed: %s", e);
            LOG.error(errMsg);
        }
    }

    private <X> void setEncryptionMetadata(X request, ObjectMetadata objectMetadata) {
        switch (this.encryptionSecrets.getEncryptionMethod()) {
            case SSE_C: {
                this.callCOSClientWithSSEC(request, new SSECustomerKey(this.encryptionSecrets.getEncryptionKey()));
                break;
            }
            case SSE_COS: {
                this.callCOSClientWithSSECOS(request, objectMetadata);
                break;
            }
            case SSE_KMS: {
                String key = this.encryptionSecrets.getEncryptionKey();
                String context = Base64.encodeAsString((byte[])this.encryptionSecrets.getEncryptionContext().getBytes());
                SSECOSKeyManagementParams ssecosKeyManagementParams = new SSECOSKeyManagementParams(key, context);
                this.callCOSClientWithSSEKMS(request, ssecosKeyManagementParams);
                break;
            }
        }
    }

    private void checkEncryptionMethod(ClientConfig config, CosNEncryptionMethods cosSSE, String sseKey) throws IOException {
        int sseKeyLen = StringUtils.isNullOrEmpty((String)sseKey) ? 0 : sseKey.length();
        String description = "Encryption key:";
        if (sseKey == null) {
            description = description + "null ";
        } else {
            switch (sseKeyLen) {
                case 0: {
                    description = description + " empty";
                    break;
                }
                case 1: {
                    description = description + " of length 1";
                    break;
                }
                default: {
                    description = description + " of length " + sseKeyLen + " ending with " + sseKey.charAt(sseKeyLen - 1);
                }
            }
        }
        switch (cosSSE) {
            case SSE_C: {
                LOG.debug("Using SSE_C with {}", (Object)description);
                config.setHttpProtocol(HttpProtocol.https);
                if (sseKeyLen == 0) {
                    throw new IOException("missing encryption key for SSE_C ");
                }
                if (sseKey.matches("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$")) break;
                throw new IOException("encryption key need to Base64 encoding for SSE_C ");
            }
            case SSE_COS: {
                if (sseKeyLen == 0) break;
                LOG.debug("Using SSE_COS");
                throw new IOException("SSE_COS to encryption with key error:  (" + description + ")");
            }
            case SSE_KMS: {
                System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
                config.setHttpProtocol(HttpProtocol.https);
            }
            default: {
                LOG.debug("Data is unencrypted");
            }
        }
    }

    /*
     * Loose catch block
     */
    private <X> Object callCOSClientWithRetry(X request) throws CosServiceException, IOException {
        String sdkMethod = "";
        int retryIndex = 1;
        int l5ErrorCodeRetryIndex = 1;
        while (true) {
            try {
                if (request instanceof PutObjectRequest) {
                    sdkMethod = "putObject";
                    if (((PutObjectRequest)request).getInputStream().markSupported()) {
                        ((PutObjectRequest)request).getInputStream().mark((int)((PutObjectRequest)request).getMetadata().getContentLength());
                    }
                    return this.cosClient.putObject((PutObjectRequest)request);
                }
                if (request instanceof UploadPartRequest) {
                    sdkMethod = "uploadPart";
                    if (((UploadPartRequest)request).getInputStream().markSupported()) {
                        ((UploadPartRequest)request).getInputStream().mark((int)((UploadPartRequest)request).getPartSize());
                    }
                    return this.cosClient.uploadPart((UploadPartRequest)request);
                }
                if (request instanceof CopyPartRequest) {
                    sdkMethod = "copyPartRequest";
                    return this.cosClient.copyPart((CopyPartRequest)request);
                }
                if (request instanceof HeadBucketRequest) {
                    sdkMethod = "headBucket";
                    return this.cosClient.headBucket((HeadBucketRequest)request);
                }
                if (request instanceof RenameRequest) {
                    sdkMethod = "rename";
                    this.cosClient.rename((RenameRequest)request);
                    return new Object();
                }
                if (request instanceof GetObjectMetadataRequest) {
                    sdkMethod = "queryObjectMeta";
                    return this.cosClient.getObjectMetadata((GetObjectMetadataRequest)request);
                }
                if (request instanceof DeleteObjectRequest) {
                    sdkMethod = "deleteObject";
                    this.cosClient.deleteObject((DeleteObjectRequest)request);
                    return new Object();
                }
                if (request instanceof CopyObjectRequest) {
                    sdkMethod = "copyFile";
                    return this.cosClient.copyObject((CopyObjectRequest)request);
                }
                if (request instanceof GetObjectRequest) {
                    sdkMethod = "getObject";
                    return this.cosClient.getObject((GetObjectRequest)request);
                }
                if (request instanceof ListObjectsRequest) {
                    sdkMethod = "listObjects";
                    return this.cosClient.listObjects((ListObjectsRequest)request);
                }
                if (request instanceof InitiateMultipartUploadRequest) {
                    sdkMethod = "initiateMultipartUpload";
                    return this.cosClient.initiateMultipartUpload((InitiateMultipartUploadRequest)request);
                }
                if (request instanceof CompleteMultipartUploadRequest) {
                    sdkMethod = "completeMultipartUpload";
                    return this.cosClient.completeMultipartUpload((CompleteMultipartUploadRequest)request);
                }
                if (request instanceof AbortMultipartUploadRequest) {
                    sdkMethod = "abortMultipartUpload";
                    this.cosClient.abortMultipartUpload((AbortMultipartUploadRequest)request);
                    return new Object();
                }
                if (request instanceof PutSymlinkRequest) {
                    sdkMethod = "putSymlink";
                    return this.cosClient.putSymlink((PutSymlinkRequest)request);
                }
                if (request instanceof GetSymlinkRequest) {
                    sdkMethod = "getSymlink";
                    return this.cosClient.getSymlink((GetSymlinkRequest)request);
                }
                if (request instanceof ListPartsRequest) {
                    sdkMethod = "listParts";
                    return this.cosClient.listParts((ListPartsRequest)request);
                }
                throw new IOException("no such method");
            }
            catch (ResponseNotCompleteException nce) {
                if (this.completeMPUCheckEnabled && request instanceof CompleteMultipartUploadRequest) {
                    String key = ((CompleteMultipartUploadRequest)request).getKey();
                    FileMetadata fileMetadata = this.queryObjectMetadata(key);
                    if (null == fileMetadata) {
                        this.handleException((Exception)((Object)nce), key);
                    }
                    LOG.warn("Complete mpu resp not complete key [{}]", (Object)key);
                    return new CompleteMultipartUploadResult();
                }
                throw new IOException(nce);
            }
            catch (CosServiceException cse) {
                String errMsg = String.format("all cos sdk failed, retryIndex: [%d / %d], call method: %s, exception: %s", new Object[]{retryIndex, this.maxRetryTimes, sdkMethod, cse});
                int statusCode = cse.getStatusCode();
                String errorCode = cse.getErrorCode();
                LOG.debug("fail to retry statusCode {}, errorCode {}", (Object)statusCode, (Object)errorCode);
                if (request instanceof CopyObjectRequest && this.hasErrorCode(statusCode, errorCode)) {
                    if (retryIndex <= this.maxRetryTimes) {
                        LOG.info(errMsg, (Throwable)cse);
                        ++retryIndex;
                        continue;
                    }
                    LOG.error(errMsg, (Throwable)cse);
                    throw new IOException(errMsg);
                }
                if (request instanceof CompleteMultipartUploadRequest && this.hasErrorCode(statusCode, errorCode)) {
                    String key = ((CompleteMultipartUploadRequest)request).getKey();
                    FileMetadata fileMetadata = this.queryObjectMetadata(key);
                    if (null != fileMetadata) {
                        LOG.info("complete mpu error in body, error code {}, but key {} already exist, length {}", new Object[]{errorCode, key, fileMetadata.getLength()});
                        return new CompleteMultipartUploadResult();
                    }
                    if (retryIndex <= this.maxRetryTimes) {
                        LOG.info(errMsg, (Throwable)cse);
                        ++retryIndex;
                        continue;
                    }
                    LOG.error(errMsg, (Throwable)cse);
                    throw new IOException(errMsg);
                }
                if (statusCode / 100 == 5) {
                    if (retryIndex <= this.maxRetryTimes) {
                        if (statusCode == 503 && this.useL5Id) {
                            if (l5ErrorCodeRetryIndex >= this.l5UpdateMaxRetryTimes) {
                                this.l5EndpointResolver.updateRouteResult(-1);
                                l5ErrorCodeRetryIndex = 1;
                            } else {
                                ++l5ErrorCodeRetryIndex;
                            }
                        }
                        LOG.info(errMsg, (Throwable)cse);
                        long sleepLeast = (long)retryIndex * 300L;
                        long sleepBound = (long)retryIndex * 500L;
                        try {
                            String key;
                            FileMetadata fileMetadata;
                            if (request instanceof PutObjectRequest) {
                                LOG.info("Try to reset the put object request input stream.");
                                if (((PutObjectRequest)request).getInputStream().markSupported()) {
                                    ((PutObjectRequest)request).getInputStream().reset();
                                } else {
                                    LOG.error("The put object request input stream can not be reset, so it can not be retried.");
                                    throw cse;
                                }
                            }
                            if (request instanceof UploadPartRequest) {
                                LOG.info("Try to reset the upload part request input stream.");
                                if (((UploadPartRequest)request).getInputStream().markSupported()) {
                                    ((UploadPartRequest)request).getInputStream().reset();
                                } else {
                                    LOG.error("The upload part request input stream can not be reset, so it can not be retried.");
                                    throw cse;
                                }
                            }
                            if (request instanceof CompleteMultipartUploadRequest && statusCode == 503 && null != (fileMetadata = this.queryObjectMetadata(key = ((CompleteMultipartUploadRequest)request).getKey()))) {
                                LOG.info("complete mpu error might access time out, but key {} already exist, length {}", (Object)key, (Object)fileMetadata.getLength());
                                return new CompleteMultipartUploadResult();
                            }
                            Thread.sleep(ThreadLocalRandom.current().nextLong(sleepLeast, sleepBound));
                            ++retryIndex;
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e.toString());
                        }
                        continue;
                    }
                    LOG.error(errMsg, (Throwable)cse);
                    throw new IOException(errMsg);
                }
                throw cse;
            }
            break;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String ensureValidAttributeName(String attributeName) {
        return attributeName.replace('.', '-').toLowerCase();
    }

    private boolean hasErrorCode(int statusCode, String errCode) {
        return statusCode / 100 == 2 && errCode != null && !errCode.isEmpty();
    }

    public COSClient getCOSClient() {
        return this.cosClient;
    }

    @Override
    public RangerCredentialsClient getRangerCredentialsClient() {
        return this.rangerCredentialsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPluginVersionInfo() {
        String versionStr;
        InputStream inputStream;
        block5: {
            Properties versionProperties = new Properties();
            inputStream = null;
            versionStr = "unknown";
            String versionFile = "hadoopCosPluginVersionInfo.properties";
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("hadoopCosPluginVersionInfo.properties");
                if (inputStream != null) {
                    versionProperties.load(inputStream);
                    versionStr = versionProperties.getProperty("plugin_version");
                    break block5;
                }
                LOG.error("load versionInfo properties failed, propName: {} ", (Object)"hadoopCosPluginVersionInfo.properties");
            }
            catch (IOException e) {
                try {
                    LOG.error("load versionInfo properties exception, propName: {} ", (Object)"hadoopCosPluginVersionInfo.properties");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream, (Logger)LOG);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream, (Logger)LOG);
            }
        }
        IOUtils.closeQuietly((Closeable)inputStream, (Logger)LOG);
        return versionStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void ModifyDataSize(String key, long fileSize) throws IOException {
        block11: {
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this.bucketName, key);
            ObjectMetadata objectMetadata = (ObjectMetadata)this.callCOSClientWithRetry(getObjectMetadataRequest);
            Map objectMetadata_tmp = objectMetadata.getUserMetadata();
            objectMetadata_tmp.put(CSE_MPU_FILE_SIZE, Long.toString(fileSize));
            objectMetadata.setUserMetadata(objectMetadata_tmp);
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, key, this.bucketName, key.substring(0, key.length() - CSE_MPU_KEY_SUFFIX.length()));
            if (null != objectMetadata.getStorageClass()) {
                copyObjectRequest.setStorageClass(objectMetadata.getStorageClass());
            }
            copyObjectRequest.setNewObjectMetadata(objectMetadata);
            this.setEncryptionMetadata(copyObjectRequest, objectMetadata);
            copyObjectRequest.setSourceEndpointBuilder(this.cosClient.getClientConfig().getEndpointBuilder());
            this.callCOSClientWithRetry(copyObjectRequest);
            try {
                this.delete(key);
            }
            catch (IOException e) {
                String errMsg = String.format("delete CSE temporary file failed, cos key: %s, exception: %s", key, e);
                this.handleException(new Exception(errMsg), key);
            }
            break block11;
            catch (Exception e) {
                String errMsg;
                try {
                    errMsg = String.format("Modify the object datasize failed, cos key: %s, exception: %s", key, e);
                    this.handleException(new Exception(errMsg), key);
                }
                catch (Throwable throwable) {
                    try {
                        this.delete(key);
                    }
                    catch (IOException e2) {
                        String errMsg2 = String.format("delete CSE temporary file failed, cos key: %s, exception: %s", key, e2);
                        this.handleException(new Exception(errMsg2), key);
                    }
                    throw throwable;
                }
                try {
                    this.delete(key);
                }
                catch (IOException e3) {
                    errMsg = String.format("delete CSE temporary file failed, cos key: %s, exception: %s", key, e3);
                    this.handleException(new Exception(errMsg), key);
                }
            }
        }
    }
}

