/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.model.PartETag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNPartialListing;
import org.apache.hadoop.fs.CosNResultInfo;
import org.apache.hadoop.fs.CosNSymlinkMetadata;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.RangerCredentialsClient;
import org.apache.hadoop.fs.cosn.CosNPartListing;

@InterfaceAudience.Private
@InterfaceStability.Stable
public interface NativeFileSystemStore {
    public void initialize(URI var1, Configuration var2) throws IOException;

    public void initialize(URI var1, Configuration var2, RangerCredentialsClient var3) throws IOException;

    public HeadBucketResult headBucket(String var1) throws IOException;

    public void storeFile(String var1, File var2, byte[] var3) throws IOException;

    public void storeFile(String var1, InputStream var2, byte[] var3, long var4) throws IOException;

    public void storeEmptyFile(String var1) throws IOException;

    public CompleteMultipartUploadResult completeMultipartUpload(String var1, String var2, List<PartETag> var3) throws IOException;

    public void abortMultipartUpload(String var1, String var2) throws IOException;

    public String getUploadId(String var1) throws IOException;

    public PartETag uploadPart(File var1, String var2, String var3, int var4, byte[] var5, Boolean var6) throws IOException;

    public PartETag uploadPart(InputStream var1, String var2, String var3, int var4, long var5, byte[] var7, Boolean var8) throws IOException;

    public PartETag uploadPart(File var1, String var2, String var3, int var4, byte[] var5) throws IOException;

    public PartETag uploadPart(InputStream var1, String var2, String var3, int var4, long var5, byte[] var7) throws IOException;

    public PartETag uploadPartCopy(String var1, String var2, String var3, int var4, long var5, long var7) throws IOException;

    public FileMetadata retrieveMetadata(String var1) throws IOException;

    public FileMetadata retrieveMetadata(String var1, CosNResultInfo var2) throws IOException;

    public CosNSymlinkMetadata retrieveSymlinkMetadata(String var1) throws IOException;

    public CosNSymlinkMetadata retrieveSymlinkMetadata(String var1, CosNResultInfo var2) throws IOException;

    public byte[] retrieveAttribute(String var1, String var2) throws IOException;

    public void storeDirAttribute(String var1, String var2, byte[] var3) throws IOException;

    public void storeFileAttribute(String var1, String var2, byte[] var3) throws IOException;

    public void removeDirAttribute(String var1, String var2) throws IOException;

    public void removeFileAttribute(String var1, String var2) throws IOException;

    public InputStream retrieve(String var1) throws IOException;

    public InputStream retrieve(String var1, long var2) throws IOException;

    public InputStream retrieveBlock(String var1, long var2, long var4) throws IOException;

    public boolean retrieveBlock(String var1, long var2, long var4, String var6) throws IOException;

    public long getFileLength(String var1) throws IOException;

    public void ModifyDataSize(String var1, long var2) throws IOException;

    public CosNPartialListing list(String var1, int var2) throws IOException;

    public CosNPartialListing list(String var1, int var2, CosNResultInfo var3) throws IOException;

    public CosNPartialListing list(String var1, int var2, String var3, boolean var4) throws IOException;

    public CosNPartialListing list(String var1, int var2, String var3, boolean var4, CosNResultInfo var5) throws IOException;

    public void delete(String var1) throws IOException;

    public void deleteRecursive(String var1) throws IOException;

    public void copy(String var1, String var2) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    public void createSymlink(String var1, String var2) throws IOException;

    public String getSymlink(String var1) throws IOException;

    public CosNPartListing listParts(String var1, String var2) throws IOException;

    public void purge(String var1) throws IOException;

    public void dump() throws IOException;

    public void setPosixBucket(boolean var1);

    public boolean isPosixBucket();

    public RangerCredentialsClient getRangerCredentialsClient();

    public void close();
}

