/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.IOException;

public final class CrcUtils {
    private CrcUtils() {
    }

    public static byte[] intToBytes(int value) {
        byte[] buf = new byte[4];
        try {
            CrcUtils.writeInt(buf, 0, value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buf;
    }

    public static void writeInt(byte[] buf, int offset, int value) throws IOException {
        if (offset + 4 > buf.length) {
            throw new IOException(String.format("writeInt out of bounds: buf.length=%d, offset=%d", buf.length, offset));
        }
        buf[offset + 0] = (byte)(value >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }
}

