/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNConfigKeys;
import org.apache.hadoop.fs.cosn.buffer.CosNRandomAccessMappedBuffer;
import org.apache.hadoop.fs.cosn.buffer.CosNRandomAccessMappedBufferFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalRandomAccessMappedBufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(LocalRandomAccessMappedBufferPool.class);
    private static final LocalRandomAccessMappedBufferPool instance = new LocalRandomAccessMappedBufferPool();
    private final AtomicInteger referCount = new AtomicInteger(0);
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private File cacheDir;
    private long remainingSpace;
    private long highWaterMarkRemainingSpace;
    private long lowWaterMarkRemainingSpace;
    private CosNRandomAccessMappedBufferFactory mappedBufferFactory;

    public static LocalRandomAccessMappedBufferPool getInstance() {
        return instance;
    }

    public synchronized void initialize(Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        LOG.info("Initialize the local cache.");
        if (this.isInitialized.get()) {
            LOG.info("The local file cache [{}] has been initialized and referenced once.current reference count: [{}].", (Object)this, (Object)this.referCount);
            this.referCount.incrementAndGet();
            return;
        }
        String cacheDirPath = configuration.get("fs.cosn.posix_extension.tmp.dir", CosNConfigKeys.DEFAULT_POSIX_EXTENSION_TMP_DIR);
        boolean deleteOnExit = configuration.getBoolean("fs.cosn.map_disk.delete_on_exit.enabled", true);
        this.mappedBufferFactory = new CosNRandomAccessMappedBufferFactory(cacheDirPath, deleteOnExit);
        this.cacheDir = new File(cacheDirPath);
        long usableSpace = this.cacheDir.getParentFile().getUsableSpace();
        long quotaSize = configuration.getLong("fs.cosn.posix_extension.tmp.dir.quota", 0x80000000L);
        Preconditions.checkArgument((quotaSize <= usableSpace ? 1 : 0) != 0, (Object)String.format("The quotaSize [%d] configured should be less than the usableSpace [%d].", quotaSize, usableSpace));
        this.remainingSpace = quotaSize;
        float lowWaterMark = configuration.getFloat("fs.cosn.posix_extension.tmp.dir.watermark.low", 0.5f);
        float highWaterMark = configuration.getFloat("fs.cosn.posix_extension.tmp.dir.watermark.high", 0.85f);
        Preconditions.checkArgument((Math.floor(lowWaterMark * 100.0f) > 0.0 && Math.floor(lowWaterMark * 100.0f) < 100.0 ? 1 : 0) != 0, (Object)String.format("The low watermark [%f] should be in (0,1).", Float.valueOf(lowWaterMark)));
        Preconditions.checkArgument((Math.floor(highWaterMark * 100.0f) > 0.0 && Math.floor(highWaterMark * 100.0f) < 100.0 ? 1 : 0) != 0, (Object)String.format("The high watermark [%f] should be in (0,1).", Float.valueOf(highWaterMark)));
        Preconditions.checkArgument((Float.compare(lowWaterMark, highWaterMark) < 0 ? 1 : 0) != 0, (Object)String.format("The low watermark [%f] should be less than the high watermark [%f].", Float.valueOf(lowWaterMark), Float.valueOf(highWaterMark)));
        this.highWaterMarkRemainingSpace = (long)((float)quotaSize * (1.0f - highWaterMark));
        this.lowWaterMarkRemainingSpace = (long)((float)quotaSize * (1.0f - lowWaterMark));
        this.referCount.incrementAndGet();
        this.isInitialized.set(true);
    }

    public synchronized CosNRandomAccessMappedBuffer create(String fileName, int size) throws CacheSpaceFullException, IOException {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"The file size should be a positive integer.");
        if ((long)size > this.remainingSpace) {
            throw new CacheSpaceFullException(String.format("The requested size [%d] exceeds the remaining space [%d].", size, this.remainingSpace));
        }
        CosNRandomAccessMappedBuffer randomAccessMappedBuffer = this.mappedBufferFactory.create(fileName, size);
        randomAccessMappedBuffer.clear();
        this.remainingSpace -= (long)size;
        return randomAccessMappedBuffer;
    }

    public synchronized boolean shouldRelease() {
        return this.remainingSpace < this.highWaterMarkRemainingSpace;
    }

    public synchronized void releaseFile(CosNRandomAccessMappedBuffer localFile) {
        int returnSpace = localFile.capacity();
        this.mappedBufferFactory.release(localFile);
        this.remainingSpace += (long)returnSpace;
    }

    public synchronized void close() {
        LOG.info("Close the local file cache instance.");
        if (!this.isInitialized.get()) {
            LOG.warn("The local file cache has been closed. no changes would be exeucte.");
            return;
        }
        if (this.referCount.decrementAndGet() > 0) {
            return;
        }
        this.isInitialized.set(false);
    }

    public static class CacheSpaceFullException
    extends IOException {
        public CacheSpaceFullException() {
        }

        public CacheSpaceFullException(String message) {
            super(message);
        }

        public CacheSpaceFullException(String message, Throwable cause) {
            super(message, cause);
        }

        public CacheSpaceFullException(Throwable cause) {
            super(cause);
        }
    }
}

